/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.util;

import java.text.ParseException;

public class Version
implements Comparable {
    private final int major;
    private final int minor;
    private final int patch;
    private final String qualifier;

    public Version(String versionStr, String qualifier) throws ParseException {
        this(versionStr + "." + (qualifier != null ? qualifier : ""));
    }

    public Version(String versionStr) throws ParseException {
        String[] splits = versionStr.split("\\.");
        if (splits == null || splits.length == 0 || splits.length > 4) {
            throw new ParseException("Ill formed OSGi version", 0);
        }
        try {
            this.major = Integer.parseInt(splits[0]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Major part of an OSGi version should be an integer", 0);
        }
        try {
            this.minor = splits.length >= 2 ? Integer.parseInt(splits[1]) : 0;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Minor part of an OSGi version should be an integer", 0);
        }
        try {
            this.patch = splits.length >= 3 ? Integer.parseInt(splits[2]) : 0;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Patch part of an OSGi version should be an integer", 0);
        }
        this.qualifier = splits.length == 4 ? splits[3] : null;
    }

    public Version(int major, int minor, int patch, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
    }

    public Version(Version baseVersion, String extraQualifier) {
        this.major = baseVersion.major;
        this.minor = baseVersion.minor;
        this.patch = baseVersion.patch;
        this.qualifier = baseVersion.qualifier == null ? extraQualifier : baseVersion.qualifier + extraQualifier;
    }

    public String toString() {
        return this.numbersAsString() + (this.qualifier == null ? "" : "." + this.qualifier);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.patch != other.patch) {
            return false;
        }
        return !(this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier));
    }

    public String numbersAsString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public Version withNudgedPatch() {
        return new Version(this.major, this.minor, this.patch + 1, null);
    }

    public Version withoutQualifier() {
        return new Version(this.major, this.minor, this.patch, null);
    }

    public String qualifier() {
        return this.qualifier == null ? "" : this.qualifier;
    }

    public int compareUnqualified(Version other) {
        int diff = this.major - other.major;
        if (diff != 0) {
            return diff;
        }
        diff = this.minor - other.minor;
        if (diff != 0) {
            return diff;
        }
        diff = this.patch - other.patch;
        if (diff != 0) {
            return diff;
        }
        return 0;
    }

    public int compareTo(Object obj) {
        return this.compareTo((Version)obj);
    }

    public int compareTo(Version other) {
        int diff = this.compareUnqualified(other);
        if (diff != 0) {
            return diff;
        }
        if (this.qualifier == null) {
            return other.qualifier != null ? -1 : 0;
        }
        if (other.qualifier == null) {
            return 1;
        }
        return this.qualifier.compareTo(other.qualifier);
    }
}

