/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng.internal;

import java.util.Arrays;
import java.util.Collection;
import org.gradle.internal.impldep.org.testng.xml.IPostProcessor;
import org.gradle.internal.impldep.org.testng.xml.XmlSuite;
import org.gradle.internal.impldep.org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverrideProcessor
implements IPostProcessor {
    private String[] m_groups;
    private String[] m_excludedGroups;

    public OverrideProcessor(String[] groups, String[] excludedGroups) {
        this.m_groups = groups;
        this.m_excludedGroups = excludedGroups;
    }

    @Override
    public Collection<XmlSuite> process(Collection<XmlSuite> suites) {
        for (XmlSuite s : suites) {
            if (this.m_groups != null && this.m_groups.length > 0) {
                for (XmlTest t : s.getTests()) {
                    t.getIncludedGroups().clear();
                    t.getIncludedGroups().addAll(Arrays.asList(this.m_groups));
                }
            }
            if (this.m_excludedGroups == null || this.m_excludedGroups.length <= 0) continue;
            for (XmlTest t : s.getTests()) {
                t.getExcludedGroups().clear();
                t.getExcludedGroups().addAll(Arrays.asList(this.m_excludedGroups));
            }
        }
        return suites;
    }
}

