/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.build.BuildViewManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.TaskRunnerResults;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.gradle.util.GradleVersion;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.plugins.gradle.execution.build.GradleBuildTasksProvider;
import org.jetbrains.plugins.gradle.execution.build.GradleExecutionEnvironmentProvider;
import org.jetbrains.plugins.gradle.execution.build.GradleImprovedHotswapDetection;
import org.jetbrains.plugins.gradle.execution.build.TasksExecutionSettingsBuilder;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.service.task.VersionSpecificInitScript;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectTaskRunner
extends ProjectTaskRunner {
    private static final Logger LOG = Logger.getInstance(GradleProjectTaskRunner.class);
    @Language(value="Groovy")
    private static final String COLLECT_OUTPUT_PATHS_USING_SERVICES_INIT_SCRIPT_TEMPLATE = "import org.gradle.tooling.events.OperationCompletionListener\nimport org.gradle.tooling.events.FinishEvent\nimport org.gradle.api.services.BuildService\nimport org.gradle.api.services.BuildServiceParameters\nimport org.gradle.util.GradleVersion\nimport org.gradle.api.Task\n\ndef outputFile = new File(\"%s\")\n\nabstract class OutputPathCollectorService\n        implements BuildService<OutputPathCollectorService.Params>, AutoCloseable {\n\n    interface Params extends BuildServiceParameters {\n        Property<File> getOutputFile()\n    }\n\n    Set<Task> tasks = new HashSet<Task>()\n\n    void registerTask(Task t) {\n        tasks.add(t)\n    }\n\n    @Override\n    void close() throws Exception {\n        def outputFile = getParameters().outputFile.get()\n        tasks.each { Task task ->\n            def state = task.state\n            def work = state.didWork\n            def fromCache = state.skipped && state.skipMessage == 'FROM-CACHE'\n            def hasOutput = task.outputs.hasOutput\n            if ((work || fromCache) && hasOutput) {\n                task.outputs.files.files.each { outputFile.append(it.path + '\\n') }\n            }\n        }\n    }\n}\n\nProvider<OutputPathCollectorService> provider = gradle.sharedServices.registerIfAbsent(\"outputPathCollectorService\",\n        OutputPathCollectorService) { it.parameters.outputFile.set(outputFile)  }\n\ngradle.taskGraph.whenReady { TaskExecutionGraph tg ->\n    tg.allTasks.each { Task t ->\n        t.onlyIf {\n            provider.get().registerTask(t)\n            return true\n        }\n    }\n}\n";
    @Language(value="Groovy")
    private static final String COLLECT_OUTPUT_PATHS_INIT_SCRIPT_TEMPLATE = "def outputFile = new File(\"%s\")\ndef effectiveTasks = []\ngradle.taskGraph.addTaskExecutionListener(new TaskExecutionAdapter() {\n    void afterExecute(Task task, TaskState state) {\n        if ((state.didWork || (state.skipped && state.skipMessage == 'FROM-CACHE')) && task.outputs.hasOutput) {\n            effectiveTasks.add(task)\n        }\n    }\n})\ngradle.addBuildListener(new BuildAdapter() {\n    void buildFinished(BuildResult result) {\n        effectiveTasks.each { Task task ->\n            task.outputs.files.files.each { outputFile.append(it.path + '\\n') }\n        }\n    }\n})\n";

    public Promise<ProjectTaskRunner.Result> run(final @NotNull Project project, final @NotNull ProjectTaskContext context, ProjectTask ... tasks) {
        if (project == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(1);
        }
        if (tasks == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(2);
        }
        final AsyncPromise resultPromise = new AsyncPromise();
        final TasksExecutionSettingsBuilder executionSettingsBuilder = new TasksExecutionSettingsBuilder(project, tasks);
        final Set<String> rootPaths = executionSettingsBuilder.getRootPaths();
        if (rootPaths.isEmpty()) {
            LOG.warn("Nothing will be run for: " + Arrays.toString(tasks));
            resultPromise.setResult((Object)TaskRunnerResults.SUCCESS);
            return resultPromise;
        }
        final AtomicInteger successCounter = new AtomicInteger();
        final AtomicInteger errorCounter = new AtomicInteger();
        final File outputPathsFile = GradleProjectTaskRunner.createTempOutputPathsFileIfNeeded(context);
        TaskCallback taskCallback = new TaskCallback(){

            public void onSuccess() {
                this.handle(true);
            }

            public void onFailure() {
                this.handle(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handle(boolean success) {
                int errors;
                int successes = success ? successCounter.incrementAndGet() : successCounter.get();
                int n = errors = success ? errorCounter.get() : errorCounter.incrementAndGet();
                if (successes + errors == rootPaths.size()) {
                    if (!project.isDisposed()) {
                        try {
                            if (GradleImprovedHotswapDetection.isEnabled()) {
                                GradleImprovedHotswapDetection.processInitScriptOutput(context, outputPathsFile);
                            } else {
                                Set<String> affectedRoots = GradleProjectTaskRunner.getAffectedOutputRoots(outputPathsFile, context, executionSettingsBuilder);
                                if (!affectedRoots.isEmpty()) {
                                    if (context.isCollectionOfGeneratedFilesEnabled()) {
                                        context.addDirtyOutputPathsProvider(() -> affectedRoots);
                                    }
                                    CompilerUtil.refreshOutputRoots(affectedRoots);
                                }
                            }
                        }
                        finally {
                            if (outputPathsFile != null) {
                                FileUtil.delete((File)outputPathsFile);
                            }
                        }
                    }
                    resultPromise.setResult((Object)(errors > 0 ? TaskRunnerResults.FAILURE : TaskRunnerResults.SUCCESS));
                } else if (successes + errors > rootPaths.size()) {
                    LOG.error("Unexpected callback!");
                }
            }
        };
        for (String rootProjectPath : rootPaths) {
            if (!executionSettingsBuilder.containsTasksToExecuteFor(rootProjectPath)) {
                taskCallback.onSuccess();
                LOG.warn("Nothing will be run for: " + Arrays.toString(tasks) + " at '" + rootProjectPath + "'");
                continue;
            }
            if (outputPathsFile != null && context.isCollectionOfGeneratedFilesEnabled()) {
                String initScriptUsingService;
                String initScript;
                String outputFilePath = FileUtil.toCanonicalPath((String)outputPathsFile.getAbsolutePath());
                GradleVersion v68 = GradleVersion.version((String)"6.8");
                if (GradleImprovedHotswapDetection.isEnabled()) {
                    initScript = GradleImprovedHotswapDetection.getInitScript(outputPathsFile);
                    initScriptUsingService = GradleImprovedHotswapDetection.getInitScriptUsingService(outputPathsFile);
                } else {
                    initScript = String.format(COLLECT_OUTPUT_PATHS_INIT_SCRIPT_TEMPLATE, outputFilePath);
                    initScriptUsingService = String.format(COLLECT_OUTPUT_PATHS_USING_SERVICES_INIT_SCRIPT_TEMPLATE, outputFilePath);
                }
                VersionSpecificInitScript simple = new VersionSpecificInitScript(initScript, "ijpathcollect", v -> v.compareTo(v68) < 0);
                VersionSpecificInitScript services = new VersionSpecificInitScript(initScriptUsingService, "ijpathcollect", v -> v.compareTo(v68) >= 0);
                executionSettingsBuilder.addInitScripts(rootProjectPath, simple, services);
            }
            ExternalSystemTaskExecutionSettings settings = executionSettingsBuilder.build(rootProjectPath);
            UserDataHolderBase userData = new UserDataHolderBase();
            userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, BuildViewManager.class);
            userData.putUserData(GradleTaskManager.VERSION_SPECIFIC_SCRIPTS_KEY, executionSettingsBuilder.getVersionedInitScripts(rootProjectPath));
            userData.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)StringUtil.join(executionSettingsBuilder.getInitScripts(rootProjectPath), (String)System.lineSeparator()));
            userData.putUserData(GradleTaskManager.INIT_SCRIPT_PREFIX_KEY, (Object)settings.getExecutionName());
            ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)"Run", (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)taskCallback, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC, (boolean)false, (UserDataHolderBase)userData);
        }
        return resultPromise;
    }

    @Nullable
    private static File createTempOutputPathsFileIfNeeded(@NotNull ProjectTaskContext context) {
        if (context == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(3);
        }
        File outputFile = null;
        if (context.isCollectionOfGeneratedFilesEnabled()) {
            try {
                outputFile = FileUtil.createTempFile((String)"output", (String)".paths", (boolean)true);
            }
            catch (IOException e) {
                LOG.warn("Can not create temp file to collect Gradle tasks output paths", (Throwable)e);
            }
        }
        return outputFile;
    }

    @NotNull
    private static Set<String> getAffectedOutputRoots(@Nullable File outputPathsFile, @NotNull ProjectTaskContext context, @NotNull TasksExecutionSettingsBuilder executionSettingsBuilder) {
        if (context == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(4);
        }
        if (executionSettingsBuilder == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(5);
        }
        Set<Object> affectedRoots = null;
        if (outputPathsFile != null && context.isCollectionOfGeneratedFilesEnabled()) {
            try {
                String content = FileUtil.loadFile((File)outputPathsFile);
                affectedRoots = StringUtil.isEmpty((String)content) ? Collections.emptySet() : Arrays.stream(StringUtil.splitByLines((String)content, (boolean)true)).collect(Collectors.toSet());
            }
            catch (IOException e) {
                LOG.warn("Can not load temp file with collected Gradle tasks output paths", (Throwable)e);
            }
        }
        if (affectedRoots == null) {
            List<Module> affectedModules = executionSettingsBuilder.getAffectedModules();
            affectedRoots = ContainerUtil.newHashSet((Object[])CompilerPaths.getOutputPaths((Module[])affectedModules.toArray(Module.EMPTY_ARRAY)));
        }
        HashSet hashSet = affectedRoots;
        if (hashSet == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        ProjectModelBuildTask buildTask;
        if (projectTask == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(7);
        }
        if (projectTask instanceof ModuleBuildTask) {
            Module module = ((ModuleBuildTask)projectTask).getModule();
            if (!GradleProjectSettings.isDelegatedBuildEnabled((Module)module)) {
                return false;
            }
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module);
        }
        if (projectTask instanceof ProjectModelBuildTask && (buildTask = (ProjectModelBuildTask)projectTask).getBuildableElement() instanceof Artifact) {
            for (GradleBuildTasksProvider gradleBuildTasksProvider : (GradleBuildTasksProvider[])GradleBuildTasksProvider.EP_NAME.getExtensions()) {
                if (!gradleBuildTasksProvider.isApplicable(buildTask)) continue;
                return true;
            }
        }
        if (projectTask instanceof ExecuteRunConfigurationTask) {
            RunConfigurationModule module;
            RunProfile runProfile = ((ExecuteRunConfigurationTask)projectTask).getRunProfile();
            if (!(!(runProfile instanceof ModuleBasedConfiguration) || ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)(module = ((ModuleBasedConfiguration)runProfile).getConfigurationModule()).getModule()) && GradleProjectSettings.isDelegatedBuildEnabled((Module)module.getModule()))) {
                return false;
            }
            for (GradleBuildTasksProvider gradleBuildTasksProvider : (GradleExecutionEnvironmentProvider[])GradleExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
                if (!gradleBuildTasksProvider.isApplicable((ExecuteRunConfigurationTask)projectTask)) continue;
                return true;
            }
        }
        return false;
    }

    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ExecuteRunConfigurationTask task, @Nullable Executor executor) {
        if (project == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(8);
        }
        if (task == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(9);
        }
        for (GradleExecutionEnvironmentProvider environmentProvider : (GradleExecutionEnvironmentProvider[])GradleExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
            if (!environmentProvider.isApplicable(task)) continue;
            return environmentProvider.createExecutionEnvironment(project, task, executor);
        }
        return null;
    }

    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, ProjectTask ... tasks) {
        ExecutionEnvironment environment;
        if (project == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(10);
        }
        if (tasks == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(11);
        }
        if ((environment = super.createExecutionEnvironment(project, tasks)) != null) {
            return environment;
        }
        TasksExecutionSettingsBuilder executionSettingsBuilder = new TasksExecutionSettingsBuilder(project, tasks);
        Set<String> rootPaths = executionSettingsBuilder.getRootPaths();
        if (rootPaths.size() != 1) {
            return null;
        }
        String rootProjectPath = rootPaths.iterator().next();
        ExternalSystemTaskExecutionSettings settings = executionSettingsBuilder.build(rootProjectPath);
        environment = ExternalSystemUtil.createExecutionEnvironment((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemTaskExecutionSettings)settings, (String)"Run");
        if (environment == null) {
            LOG.warn("Execution environment for " + GradleConstants.SYSTEM_ID + " is null");
            return null;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        assert (runnerAndConfigurationSettings != null);
        ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
        runConfiguration.putUserData(GradleTaskManager.VERSION_SPECIFIC_SCRIPTS_KEY, executionSettingsBuilder.getVersionedInitScripts(rootProjectPath));
        String initScript = StringUtil.join(executionSettingsBuilder.getInitScripts(rootProjectPath), (String)System.lineSeparator());
        runConfiguration.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)initScript);
        runConfiguration.putUserData(GradleTaskManager.INIT_SCRIPT_PREFIX_KEY, (Object)settings.getExecutionName());
        return environment;
    }

    public boolean isFileGeneratedEventsSupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionSettingsBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedOutputRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTempOutputPathsFileIfNeeded";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedOutputRoots";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionEnvironment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

