/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.types;

import com.intellij.debugger.mockJDI.MockMirror;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.types.MockArrayType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.sun.jdi.Type;

public abstract class MockType
extends MockMirror
implements Type {
    public MockType(MockVirtualMachine virtualMachine) {
        super(virtualMachine);
    }

    public static MockType createType(MockVirtualMachine virtualMachine, Class aClass) {
        if (aClass.isPrimitive()) {
            if (aClass == Boolean.TYPE) {
                return virtualMachine.getBooleanType();
            }
            if (aClass == Integer.TYPE) {
                return virtualMachine.getIntType();
            }
            if (aClass == Long.TYPE) {
                return virtualMachine.getLongType();
            }
            if (aClass == Short.TYPE) {
                return virtualMachine.getShortType();
            }
            if (aClass == Void.TYPE) {
                return virtualMachine.getVoidType();
            }
            throw new UnsupportedOperationException("create type for " + aClass);
        }
        return virtualMachine.createReferenceType(aClass);
    }

    public static MockType createType(MockVirtualMachine virtualMachine, PsiType type) {
        PsiClass cls;
        if (type instanceof PsiArrayType) {
            return new MockArrayType(MockType.createType(virtualMachine, ((PsiArrayType)type).getComponentType()));
        }
        if (type instanceof PsiPrimitiveType) {
            if (type.equals(PsiType.BOOLEAN)) {
                return virtualMachine.getBooleanType();
            }
            if (type.equals(PsiType.INT)) {
                return virtualMachine.getIntType();
            }
            if (type.equals(PsiType.LONG)) {
                return virtualMachine.getLongType();
            }
            if (type.equals(PsiType.SHORT)) {
                return virtualMachine.getShortType();
            }
            if (type.equals(PsiType.VOID)) {
                return virtualMachine.getVoidType();
            }
        }
        if (type instanceof PsiClassType && (cls = PsiUtil.resolveClassInClassTypeOnly((PsiType)type)) != null) {
            return virtualMachine.createReferenceType(cls);
        }
        throw new UnsupportedOperationException("create type for " + type);
    }

    @Override
    public String signature() {
        throw new UnsupportedOperationException("Not implemented: \"signature\" in " + this.getClass().getName());
    }

    @Override
    public String name() {
        throw new UnsupportedOperationException("Not implemented: \"name\" in " + this.getClass().getName());
    }
}

