/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Spliterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.assertj.core.api.Abstract2DArrayAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBigIntegerAssert;
import org.assertj.core.api.AbstractBooleanArrayAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractCharArrayAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractCharacterAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractDoubleArrayAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractDurationAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractFloatArrayAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractFutureAssert;
import org.assertj.core.api.AbstractInputStreamAssert;
import org.assertj.core.api.AbstractInstantAssert;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLocalDateAssert;
import org.assertj.core.api.AbstractLocalDateTimeAssert;
import org.assertj.core.api.AbstractLocalTimeAssert;
import org.assertj.core.api.AbstractLongArrayAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AbstractOffsetDateTimeAssert;
import org.assertj.core.api.AbstractOffsetTimeAssert;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.AbstractPeriodAssert;
import org.assertj.core.api.AbstractShortArrayAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.AbstractSpliteratorAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AbstractUriAssert;
import org.assertj.core.api.AbstractUrlAssert;
import org.assertj.core.api.AbstractZonedDateTimeAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssumptionExceptionFactory;
import org.assertj.core.api.AtomicBooleanAssert;
import org.assertj.core.api.AtomicIntegerArrayAssert;
import org.assertj.core.api.AtomicIntegerAssert;
import org.assertj.core.api.AtomicIntegerFieldUpdaterAssert;
import org.assertj.core.api.AtomicLongArrayAssert;
import org.assertj.core.api.AtomicLongAssert;
import org.assertj.core.api.AtomicLongFieldUpdaterAssert;
import org.assertj.core.api.AtomicMarkableReferenceAssert;
import org.assertj.core.api.AtomicReferenceArrayAssert;
import org.assertj.core.api.AtomicReferenceAssert;
import org.assertj.core.api.AtomicReferenceFieldUpdaterAssert;
import org.assertj.core.api.AtomicStampedReferenceAssert;
import org.assertj.core.api.BigDecimalAssert;
import org.assertj.core.api.BigIntegerAssert;
import org.assertj.core.api.Boolean2DArrayAssert;
import org.assertj.core.api.BooleanArrayAssert;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.Byte2DArrayAssert;
import org.assertj.core.api.ByteArrayAssert;
import org.assertj.core.api.ByteAssert;
import org.assertj.core.api.Char2DArrayAssert;
import org.assertj.core.api.CharArrayAssert;
import org.assertj.core.api.CharSequenceAssert;
import org.assertj.core.api.CharacterAssert;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.ClassLoadingStrategyFactory;
import org.assertj.core.api.CollectionAssert;
import org.assertj.core.api.CompletableFutureAssert;
import org.assertj.core.api.DateAssert;
import org.assertj.core.api.Double2DArrayAssert;
import org.assertj.core.api.DoubleArrayAssert;
import org.assertj.core.api.DoubleAssert;
import org.assertj.core.api.DoublePredicateAssert;
import org.assertj.core.api.DurationAssert;
import org.assertj.core.api.FactoryBasedNavigableListAssert;
import org.assertj.core.api.FileAssert;
import org.assertj.core.api.FileSizeAssert;
import org.assertj.core.api.Float2DArrayAssert;
import org.assertj.core.api.FloatArrayAssert;
import org.assertj.core.api.FloatAssert;
import org.assertj.core.api.FutureAssert;
import org.assertj.core.api.GenericComparableAssert;
import org.assertj.core.api.InputStreamAssert;
import org.assertj.core.api.InstantAssert;
import org.assertj.core.api.Int2DArrayAssert;
import org.assertj.core.api.IntArrayAssert;
import org.assertj.core.api.IntPredicateAssert;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.IterableSizeAssert;
import org.assertj.core.api.IteratorAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.LocalDateAssert;
import org.assertj.core.api.LocalDateTimeAssert;
import org.assertj.core.api.LocalTimeAssert;
import org.assertj.core.api.Long2DArrayAssert;
import org.assertj.core.api.LongAdderAssert;
import org.assertj.core.api.LongArrayAssert;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.LongPredicateAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.MapSizeAssert;
import org.assertj.core.api.Object2DArrayAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OffsetDateTimeAssert;
import org.assertj.core.api.OffsetTimeAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.OptionalDoubleAssert;
import org.assertj.core.api.OptionalIntAssert;
import org.assertj.core.api.OptionalLongAssert;
import org.assertj.core.api.PathAssert;
import org.assertj.core.api.PeriodAssert;
import org.assertj.core.api.PredicateAssert;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.Short2DArrayAssert;
import org.assertj.core.api.ShortArrayAssert;
import org.assertj.core.api.ShortAssert;
import org.assertj.core.api.SoftProxies;
import org.assertj.core.api.SpliteratorAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.UriAssert;
import org.assertj.core.api.UrlAssert;
import org.assertj.core.api.ZonedDateTimeAssert;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.configuration.PreferredAssumptionException;
import org.assertj.core.internal.bytebuddy.ByteBuddy;
import org.assertj.core.internal.bytebuddy.TypeCache;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.TypeValidation;
import org.assertj.core.internal.bytebuddy.implementation.Implementation;
import org.assertj.core.internal.bytebuddy.implementation.MethodDelegation;
import org.assertj.core.internal.bytebuddy.implementation.auxiliary.AuxiliaryType;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.SuperCall;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.This;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.CheckReturnValue;

@CheckReturnValue
public class Assumptions {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy().with(TypeValidation.DISABLED).with(new AuxiliaryType.NamingStrategy.SuffixingRandom("Assertj$Assumptions"));
    private static final Implementation ASSUMPTION = MethodDelegation.to(AssumptionMethodInterceptor.class);
    private static final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction<TypeCache.SimpleKey>(TypeCache.Sort.SOFT);

    public static <T> ObjectAssert<T> assumeThat(T actual) {
        return Assumptions.asAssumption(ObjectAssert.class, Object.class, actual);
    }

    public static AbstractStringAssert<?> assumeThat(String actual) {
        return Assumptions.asAssumption(StringAssert.class, String.class, (Object)actual);
    }

    public static AbstractBigDecimalAssert<?> assumeThat(BigDecimal actual) {
        return Assumptions.asAssumption(BigDecimalAssert.class, BigDecimal.class, (Object)actual);
    }

    public static AbstractBigIntegerAssert<?> assumeThat(BigInteger actual) {
        return Assumptions.asAssumption(BigIntegerAssert.class, BigInteger.class, (Object)actual);
    }

    public static AbstractUriAssert<?> assumeThat(URI actual) {
        return Assumptions.asAssumption(UriAssert.class, URI.class, (Object)actual);
    }

    public static AbstractUrlAssert<?> assumeThat(URL actual) {
        return Assumptions.asAssumption(UrlAssert.class, URL.class, (Object)actual);
    }

    public static AbstractBooleanAssert<?> assumeThat(boolean actual) {
        return Assumptions.asAssumption(BooleanAssert.class, Boolean.class, (Object)actual);
    }

    public static AbstractBooleanAssert<?> assumeThat(Boolean actual) {
        return Assumptions.asAssumption(BooleanAssert.class, Boolean.class, (Object)actual);
    }

    public static AbstractBooleanArrayAssert<?> assumeThat(boolean[] actual) {
        return Assumptions.asAssumption(BooleanArrayAssert.class, boolean[].class, (Object)actual);
    }

    public static Boolean2DArrayAssert assumeThat(boolean[][] actual) {
        return Assumptions.asAssumption(Boolean2DArrayAssert.class, boolean[][].class, actual);
    }

    public static AbstractByteAssert<?> assumeThat(byte actual) {
        return Assumptions.asAssumption(ByteAssert.class, Byte.class, (Object)actual);
    }

    public static AbstractByteAssert<?> assumeThat(Byte actual) {
        return Assumptions.asAssumption(ByteAssert.class, Byte.class, (Object)actual);
    }

    public static AbstractByteArrayAssert<?> assumeThat(byte[] actual) {
        return Assumptions.asAssumption(ByteArrayAssert.class, byte[].class, (Object)actual);
    }

    public static Byte2DArrayAssert assumeThat(byte[][] actual) {
        return Assumptions.asAssumption(Byte2DArrayAssert.class, byte[][].class, actual);
    }

    public static AbstractCharacterAssert<?> assumeThat(char actual) {
        return Assumptions.asAssumption(CharacterAssert.class, Character.class, (Object)Character.valueOf(actual));
    }

    public static AbstractCharacterAssert<?> assumeThat(Character actual) {
        return Assumptions.asAssumption(CharacterAssert.class, Character.class, (Object)actual);
    }

    public static AbstractCharArrayAssert<?> assumeThat(char[] actual) {
        return Assumptions.asAssumption(CharArrayAssert.class, char[].class, (Object)actual);
    }

    public static Char2DArrayAssert assumeThat(char[][] actual) {
        return Assumptions.asAssumption(Char2DArrayAssert.class, char[][].class, actual);
    }

    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assumeThat(CharSequence actual) {
        return Assumptions.asAssumption(CharSequenceAssert.class, CharSequence.class, (Object)actual);
    }

    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assumeThat(StringBuilder actual) {
        return Assumptions.asAssumption(CharSequenceAssert.class, CharSequence.class, (Object)actual);
    }

    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assumeThat(StringBuffer actual) {
        return Assumptions.asAssumption(CharSequenceAssert.class, CharSequence.class, (Object)actual);
    }

    public static AbstractShortAssert<?> assumeThat(short actual) {
        return Assumptions.asAssumption(ShortAssert.class, Short.class, (Object)actual);
    }

    public static AbstractShortAssert<?> assumeThat(Short actual) {
        return Assumptions.asAssumption(ShortAssert.class, Short.class, (Object)actual);
    }

    public static AbstractShortArrayAssert<?> assumeThat(short[] actual) {
        return Assumptions.asAssumption(ShortArrayAssert.class, short[].class, (Object)actual);
    }

    public static Short2DArrayAssert assumeThat(short[][] actual) {
        return Assumptions.asAssumption(Short2DArrayAssert.class, short[][].class, actual);
    }

    public static AbstractIntegerAssert<?> assumeThat(int actual) {
        return Assumptions.asAssumption(IntegerAssert.class, Integer.class, (Object)actual);
    }

    public static AbstractIntegerAssert<?> assumeThat(Integer actual) {
        return Assumptions.asAssumption(IntegerAssert.class, Integer.class, (Object)actual);
    }

    public static AbstractIntArrayAssert<?> assumeThat(int[] actual) {
        return Assumptions.asAssumption(IntArrayAssert.class, int[].class, (Object)actual);
    }

    public static Int2DArrayAssert assumeThat(int[][] actual) {
        return Assumptions.asAssumption(Int2DArrayAssert.class, int[][].class, actual);
    }

    public static AbstractLongAssert<?> assumeThat(long actual) {
        return Assumptions.asAssumption(LongAssert.class, Long.class, (Object)actual);
    }

    public static AbstractLongAssert<?> assumeThat(Long actual) {
        return Assumptions.asAssumption(LongAssert.class, Long.class, (Object)actual);
    }

    public static AbstractLongArrayAssert<?> assumeThat(long[] actual) {
        return Assumptions.asAssumption(LongArrayAssert.class, long[].class, (Object)actual);
    }

    public static Long2DArrayAssert assumeThat(long[][] actual) {
        return Assumptions.asAssumption(Long2DArrayAssert.class, long[][].class, actual);
    }

    public static AbstractFloatAssert<?> assumeThat(float actual) {
        return Assumptions.asAssumption(FloatAssert.class, Float.class, (Object)Float.valueOf(actual));
    }

    public static AbstractFloatAssert<?> assumeThat(Float actual) {
        return Assumptions.asAssumption(FloatAssert.class, Float.class, (Object)actual);
    }

    public static AbstractFloatArrayAssert<?> assumeThat(float[] actual) {
        return Assumptions.asAssumption(FloatArrayAssert.class, float[].class, (Object)actual);
    }

    public static Float2DArrayAssert assumeThat(float[][] actual) {
        return Assumptions.asAssumption(Float2DArrayAssert.class, float[][].class, actual);
    }

    public static AbstractDoubleAssert<?> assumeThat(double actual) {
        return Assumptions.asAssumption(DoubleAssert.class, Double.class, (Object)actual);
    }

    public static AbstractDoubleAssert<?> assumeThat(Double actual) {
        return Assumptions.asAssumption(DoubleAssert.class, Double.class, (Object)actual);
    }

    public static AbstractDoubleArrayAssert<?> assumeThat(double[] actual) {
        return Assumptions.asAssumption(DoubleArrayAssert.class, double[].class, (Object)actual);
    }

    public static Double2DArrayAssert assumeThat(double[][] actual) {
        return Assumptions.asAssumption(Double2DArrayAssert.class, double[][].class, actual);
    }

    public static AtomicBooleanAssert assumeThat(AtomicBoolean actual) {
        return Assumptions.asAssumption(AtomicBooleanAssert.class, AtomicBoolean.class, (Object)actual);
    }

    public static AtomicIntegerAssert assumeThat(AtomicInteger actual) {
        return Assumptions.asAssumption(AtomicIntegerAssert.class, AtomicInteger.class, (Object)actual);
    }

    public static AtomicIntegerArrayAssert assumeThat(AtomicIntegerArray actual) {
        return Assumptions.asAssumption(AtomicIntegerArrayAssert.class, AtomicIntegerArray.class, (Object)actual);
    }

    public static <OBJECT> AtomicIntegerFieldUpdaterAssert<OBJECT> assumeThat(AtomicIntegerFieldUpdater<OBJECT> actual) {
        return Assumptions.asAssumption(AtomicIntegerFieldUpdaterAssert.class, AtomicIntegerFieldUpdater.class, actual);
    }

    public static LongAdderAssert assumeThat(LongAdder actual) {
        return Assumptions.asAssumption(LongAdderAssert.class, LongAdder.class, (Object)actual);
    }

    public static AtomicLongAssert assumeThat(AtomicLong actual) {
        return Assumptions.asAssumption(AtomicLongAssert.class, AtomicLong.class, (Object)actual);
    }

    public static AtomicLongArrayAssert assumeThat(AtomicLongArray actual) {
        return Assumptions.asAssumption(AtomicLongArrayAssert.class, AtomicLongArray.class, (Object)actual);
    }

    public static <OBJECT> AtomicLongFieldUpdaterAssert<OBJECT> assumeThat(AtomicLongFieldUpdater<OBJECT> actual) {
        return Assumptions.asAssumption(AtomicLongFieldUpdaterAssert.class, AtomicLongFieldUpdater.class, actual);
    }

    public static <VALUE> AtomicReferenceAssert<VALUE> assumeThat(AtomicReference<VALUE> actual) {
        return Assumptions.asAssumption(AtomicReferenceAssert.class, AtomicReference.class, actual);
    }

    public static <ELEMENT> AtomicReferenceArrayAssert<ELEMENT> assumeThat(AtomicReferenceArray<ELEMENT> actual) {
        return Assumptions.asAssumption(AtomicReferenceArrayAssert.class, AtomicReferenceArray.class, actual);
    }

    public static <FIELD, OBJECT> AtomicReferenceFieldUpdaterAssert<FIELD, OBJECT> assumeThat(AtomicReferenceFieldUpdater<OBJECT, FIELD> actual) {
        return Assumptions.asAssumption(AtomicReferenceFieldUpdaterAssert.class, AtomicReferenceFieldUpdater.class, actual);
    }

    public static <VALUE> AtomicMarkableReferenceAssert<VALUE> assumeThat(AtomicMarkableReference<VALUE> actual) {
        return Assumptions.asAssumption(AtomicMarkableReferenceAssert.class, AtomicMarkableReference.class, actual);
    }

    public static <VALUE> AtomicStampedReferenceAssert<VALUE> assumeThat(AtomicStampedReference<VALUE> actual) {
        return Assumptions.asAssumption(AtomicStampedReferenceAssert.class, AtomicStampedReference.class, actual);
    }

    public static ClassAssert assumeThat(Class<?> actual) {
        return Assumptions.asAssumption(ClassAssert.class, Class.class, actual);
    }

    public static AbstractDateAssert<?> assumeThat(Date actual) {
        return Assumptions.asAssumption(DateAssert.class, Date.class, (Object)actual);
    }

    public static AbstractFileAssert<?> assumeThat(File actual) {
        return Assumptions.asAssumption(FileAssert.class, File.class, (Object)actual);
    }

    public static AbstractPathAssert<?> assumeThat(Path actual) {
        return Assumptions.asAssumption(PathAssert.class, Path.class, (Object)actual);
    }

    public static AbstractInputStreamAssert<?, ? extends InputStream> assumeThat(InputStream actual) {
        return Assumptions.asAssumption(InputStreamAssert.class, InputStream.class, (Object)actual);
    }

    public static <RESULT> AbstractFutureAssert<?, ? extends Future<? extends RESULT>, RESULT> assumeThat(Future<RESULT> future2) {
        return Assumptions.asAssumption(FutureAssert.class, Future.class, future2);
    }

    public static <ELEMENT> IterableAssert<ELEMENT> assumeThat(Iterable<? extends ELEMENT> actual) {
        return Assumptions.asAssumption(IterableAssert.class, Iterable.class, actual);
    }

    public static <ELEMENT> IteratorAssert<ELEMENT> assumeThat(Iterator<? extends ELEMENT> actual) {
        return Assumptions.asAssumption(IteratorAssert.class, Iterator.class, actual);
    }

    public static <E> AbstractCollectionAssert<?, Collection<? extends E>, E, ObjectAssert<E>> assumeThat(Collection<? extends E> actual) {
        return Assumptions.asAssumption(CollectionAssert.class, Collection.class, actual);
    }

    public static <ELEMENT> FactoryBasedNavigableListAssert<ListAssert<ELEMENT>, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> assumeThat(List<? extends ELEMENT> actual) {
        return Assumptions.asAssumption(ListAssert.class, List.class, actual);
    }

    public static <T> ObjectArrayAssert<T> assumeThat(T[] actual) {
        return Assumptions.asAssumption(ObjectArrayAssert.class, Object[].class, actual);
    }

    public static <T> Object2DArrayAssert<T> assumeThat(T[][] actual) {
        return Assumptions.asAssumption(Object2DArrayAssert.class, Object[][].class, actual);
    }

    public static <K, V> MapAssert<K, V> assumeThat(Map<K, V> actual) {
        return Assumptions.asAssumption(MapAssert.class, Map.class, actual);
    }

    public static <T extends Comparable<? super T>> AbstractComparableAssert<?, T> assumeThat(T actual) {
        return Assumptions.asAssumption(GenericComparableAssert.class, Comparable.class, actual);
    }

    public static <T extends Throwable> AbstractThrowableAssert<?, T> assumeThat(T actual) {
        return Assumptions.asAssumption(ThrowableAssert.class, Throwable.class, actual);
    }

    public static AbstractThrowableAssert<?, ? extends Throwable> assumeThatThrownBy(ThrowableAssert.ThrowingCallable shouldRaiseThrowable) {
        return Assumptions.asAssumption(ThrowableAssert.class, Throwable.class, (Object)Assertions.catchThrowable(shouldRaiseThrowable));
    }

    public static AbstractThrowableAssert<?, ? extends Throwable> assumeThatCode(ThrowableAssert.ThrowingCallable shouldRaiseOrNotThrowable) {
        return Assumptions.assumeThat(Assertions.catchThrowable(shouldRaiseOrNotThrowable));
    }

    public static <T> ObjectAssert<T> assumeThatObject(T actual) {
        return Assumptions.assumeThat(actual);
    }

    public static <T> PredicateAssert<T> assumeThat(Predicate<T> actual) {
        return Assumptions.asAssumption(PredicateAssert.class, Predicate.class, actual);
    }

    public static IntPredicateAssert assumeThat(IntPredicate actual) {
        return Assumptions.asAssumption(IntPredicateAssert.class, IntPredicate.class, (Object)actual);
    }

    public static LongPredicateAssert assumeThat(LongPredicate actual) {
        return Assumptions.asAssumption(LongPredicateAssert.class, LongPredicate.class, (Object)actual);
    }

    public static DoublePredicateAssert assumeThat(DoublePredicate actual) {
        return Assumptions.asAssumption(DoublePredicateAssert.class, DoublePredicate.class, (Object)actual);
    }

    public static <RESULT> CompletableFutureAssert<RESULT> assumeThat(CompletableFuture<RESULT> actual) {
        return Assumptions.asAssumption(CompletableFutureAssert.class, CompletableFuture.class, actual);
    }

    public static <RESULT> CompletableFutureAssert<RESULT> assumeThat(CompletionStage<RESULT> actual) {
        return Assumptions.asAssumption(CompletableFutureAssert.class, CompletionStage.class, actual);
    }

    public static <VALUE> OptionalAssert<VALUE> assumeThat(Optional<VALUE> actual) {
        return Assumptions.asAssumption(OptionalAssert.class, Optional.class, actual);
    }

    public static OptionalDoubleAssert assumeThat(OptionalDouble actual) {
        return Assumptions.asAssumption(OptionalDoubleAssert.class, OptionalDouble.class, (Object)actual);
    }

    public static OptionalIntAssert assumeThat(OptionalInt actual) {
        return Assumptions.asAssumption(OptionalIntAssert.class, OptionalInt.class, (Object)actual);
    }

    public static OptionalLongAssert assumeThat(OptionalLong actual) {
        return Assumptions.asAssumption(OptionalLongAssert.class, OptionalLong.class, (Object)actual);
    }

    public static AbstractZonedDateTimeAssert<?> assumeThat(ZonedDateTime actual) {
        return Assumptions.asAssumption(ZonedDateTimeAssert.class, ZonedDateTime.class, (Object)actual);
    }

    public static AbstractLocalDateTimeAssert<?> assumeThat(LocalDateTime actual) {
        return Assumptions.asAssumption(LocalDateTimeAssert.class, LocalDateTime.class, (Object)actual);
    }

    public static AbstractOffsetDateTimeAssert<?> assumeThat(OffsetDateTime actual) {
        return Assumptions.asAssumption(OffsetDateTimeAssert.class, OffsetDateTime.class, (Object)actual);
    }

    public static AbstractOffsetTimeAssert<?> assumeThat(OffsetTime actual) {
        return Assumptions.asAssumption(OffsetTimeAssert.class, OffsetTime.class, (Object)actual);
    }

    public static AbstractLocalTimeAssert<?> assumeThat(LocalTime actual) {
        return Assumptions.asAssumption(LocalTimeAssert.class, LocalTime.class, (Object)actual);
    }

    public static AbstractLocalDateAssert<?> assumeThat(LocalDate actual) {
        return Assumptions.asAssumption(LocalDateAssert.class, LocalDate.class, (Object)actual);
    }

    public static AbstractInstantAssert<?> assumeThat(Instant actual) {
        return Assumptions.asAssumption(InstantAssert.class, Instant.class, (Object)actual);
    }

    public static AbstractDurationAssert<?> assumeThat(Duration actual) {
        return Assumptions.asAssumption(DurationAssert.class, Duration.class, (Object)actual);
    }

    public static AbstractPeriodAssert<?> assumeThat(Period actual) {
        return Assumptions.asAssumption(PeriodAssert.class, Period.class, (Object)actual);
    }

    public static <ELEMENT> AbstractListAssert<?, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> assumeThat(Stream<? extends ELEMENT> actual) {
        return Assumptions.asAssumption(ListAssert.class, Stream.class, actual);
    }

    public static AbstractListAssert<?, List<? extends Double>, Double, ObjectAssert<Double>> assumeThat(DoubleStream actual) {
        return Assumptions.asAssumption(ListAssert.class, DoubleStream.class, (Object)actual);
    }

    public static AbstractListAssert<?, List<? extends Long>, Long, ObjectAssert<Long>> assumeThat(LongStream actual) {
        return Assumptions.asAssumption(ListAssert.class, LongStream.class, (Object)actual);
    }

    public static AbstractListAssert<?, List<? extends Integer>, Integer, ObjectAssert<Integer>> assumeThat(IntStream actual) {
        return Assumptions.asAssumption(ListAssert.class, IntStream.class, (Object)actual);
    }

    public static <ELEMENT> AbstractSpliteratorAssert<?, ELEMENT> assumeThat(Spliterator<ELEMENT> actual) {
        return Assumptions.asAssumption(SpliteratorAssert.class, Spliterator.class, actual);
    }

    public static void setPreferredAssumptionException(PreferredAssumptionException preferredAssumptionException) {
        AssumptionExceptionFactory.setPreferredAssumptionException(preferredAssumptionException);
    }

    private static <ASSERTION, ACTUAL> ASSERTION asAssumption(Class<ASSERTION> assertionType, Class<ACTUAL> actualType, Object actual) {
        return Assumptions.asAssumption(assertionType, Arrays.array(actualType), Arrays.array(actual));
    }

    private static <ASSERTION> ASSERTION asAssumption(Class<ASSERTION> assertionType, Class<?>[] constructorTypes, Object ... constructorParams) {
        try {
            Class<ASSERTION> type2 = Assumptions.createAssumptionClass(assertionType);
            Constructor<ASSERTION> constructor = type2.getConstructor(constructorTypes);
            return constructor.newInstance(constructorParams);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <ASSERTION> Class<? extends ASSERTION> createAssumptionClass(Class<ASSERTION> assertClass) {
        TypeCache.SimpleKey cacheKey = new TypeCache.SimpleKey(assertClass, new Class[0]);
        return CACHE.findOrInsert(assertClass.getClassLoader(), cacheKey, () -> Assumptions.generateAssumptionClass(assertClass));
    }

    protected static <ASSERTION> Class<? extends ASSERTION> generateAssumptionClass(Class<ASSERTION> assertionType) {
        ClassLoadingStrategyFactory.ClassLoadingStrategyPair strategy = ClassLoadingStrategyFactory.classLoadingStrategy(assertionType);
        return BYTE_BUDDY.subclass(assertionType).method(ElementMatchers.any().and(ElementMatchers.not(SoftProxies.METHODS_NOT_TO_PROXY))).intercept(ASSUMPTION).make().load(strategy.getClassLoader(), strategy.getClassLoadingStrategy()).getLoaded();
    }

    private static AbstractAssert<?, ?> asAssumption(AbstractAssert<?, ?> assertion) {
        Object actual = assertion.actual;
        if (assertion instanceof AbstractObjectArrayAssert) {
            return Assumptions.asAssumption(ObjectArrayAssert.class, Object[].class, actual);
        }
        if (assertion instanceof AtomicBooleanAssert) {
            return Assumptions.asAssumption(AtomicBooleanAssert.class, AtomicBoolean.class, actual);
        }
        if (assertion instanceof AtomicIntegerAssert) {
            return Assumptions.asAssumption(AtomicIntegerAssert.class, AtomicInteger.class, actual);
        }
        if (assertion instanceof AtomicIntegerArrayAssert) {
            return Assumptions.asAssumption(AtomicIntegerArrayAssert.class, AtomicIntegerArray.class, actual);
        }
        if (assertion instanceof AtomicIntegerFieldUpdaterAssert) {
            return Assumptions.asAssumption(AtomicIntegerFieldUpdaterAssert.class, AtomicIntegerFieldUpdater.class, actual);
        }
        if (assertion instanceof AtomicLongAssert) {
            return Assumptions.asAssumption(AtomicLongAssert.class, AtomicLong.class, actual);
        }
        if (assertion instanceof AtomicLongArrayAssert) {
            return Assumptions.asAssumption(AtomicLongArrayAssert.class, AtomicLongArray.class, actual);
        }
        if (assertion instanceof AtomicLongFieldUpdaterAssert) {
            return Assumptions.asAssumption(AtomicLongFieldUpdaterAssert.class, AtomicLongFieldUpdater.class, actual);
        }
        if (assertion instanceof AtomicMarkableReferenceAssert) {
            return Assumptions.asAssumption(AtomicMarkableReferenceAssert.class, AtomicMarkableReference.class, actual);
        }
        if (assertion instanceof AtomicReferenceAssert) {
            return Assumptions.asAssumption(AtomicReferenceAssert.class, AtomicReference.class, actual);
        }
        if (assertion instanceof AtomicReferenceArrayAssert) {
            return Assumptions.asAssumption(AtomicReferenceArrayAssert.class, AtomicReferenceArray.class, actual);
        }
        if (assertion instanceof AtomicReferenceFieldUpdaterAssert) {
            return Assumptions.asAssumption(AtomicReferenceFieldUpdaterAssert.class, AtomicReferenceFieldUpdater.class, actual);
        }
        if (assertion instanceof AtomicStampedReferenceAssert) {
            return Assumptions.asAssumption(AtomicStampedReferenceAssert.class, AtomicStampedReference.class, actual);
        }
        if (assertion instanceof BigDecimalAssert) {
            return Assumptions.asAssumption(BigDecimalAssert.class, BigDecimal.class, actual);
        }
        if (assertion instanceof BigIntegerAssert) {
            return Assumptions.asAssumption(BigIntegerAssert.class, BigInteger.class, actual);
        }
        if (assertion instanceof BooleanAssert) {
            return Assumptions.asAssumption(BooleanAssert.class, Boolean.class, actual);
        }
        if (assertion instanceof Boolean2DArrayAssert) {
            return Assumptions.asAssumption(Boolean2DArrayAssert.class, boolean[][].class, actual);
        }
        if (assertion instanceof BooleanArrayAssert) {
            return Assumptions.asAssumption(BooleanArrayAssert.class, boolean[].class, actual);
        }
        if (assertion instanceof ByteAssert) {
            return Assumptions.asAssumption(ByteAssert.class, Byte.class, actual);
        }
        if (assertion instanceof Byte2DArrayAssert) {
            return Assumptions.asAssumption(Byte2DArrayAssert.class, byte[][].class, actual);
        }
        if (assertion instanceof ByteArrayAssert) {
            return Assumptions.asAssumption(ByteArrayAssert.class, byte[].class, actual);
        }
        if (assertion instanceof CharacterAssert) {
            return Assumptions.asAssumption(CharacterAssert.class, Character.TYPE, actual);
        }
        if (assertion instanceof Char2DArrayAssert) {
            return Assumptions.asAssumption(Char2DArrayAssert.class, char[][].class, actual);
        }
        if (assertion instanceof CharArrayAssert) {
            return Assumptions.asAssumption(CharArrayAssert.class, char[].class, actual);
        }
        if (assertion instanceof CharSequenceAssert) {
            return Assumptions.asAssumption(CharSequenceAssert.class, CharSequence.class, actual);
        }
        if (assertion instanceof ClassAssert) {
            return Assumptions.asAssumption(ClassAssert.class, Class.class, actual);
        }
        if (assertion instanceof CollectionAssert) {
            return Assumptions.asAssumption(CollectionAssert.class, Collection.class, actual);
        }
        if (assertion instanceof CompletableFutureAssert) {
            return Assumptions.asAssumption(CompletableFutureAssert.class, CompletableFuture.class, actual);
        }
        if (assertion instanceof DateAssert) {
            return Assumptions.asAssumption(DateAssert.class, Date.class, actual);
        }
        if (assertion instanceof DoubleAssert) {
            return Assumptions.asAssumption(DoubleAssert.class, Double.class, actual);
        }
        if (assertion instanceof Double2DArrayAssert) {
            return Assumptions.asAssumption(Double2DArrayAssert.class, double[][].class, actual);
        }
        if (assertion instanceof DoubleArrayAssert) {
            return Assumptions.asAssumption(DoubleArrayAssert.class, double[].class, actual);
        }
        if (assertion instanceof DoublePredicateAssert) {
            return Assumptions.asAssumption(DoublePredicateAssert.class, DoublePredicate.class, actual);
        }
        if (assertion instanceof DurationAssert) {
            return Assumptions.asAssumption(DurationAssert.class, Duration.class, actual);
        }
        if (assertion instanceof FactoryBasedNavigableListAssert) {
            return Assumptions.asAssumption(ListAssert.class, List.class, actual);
        }
        if (assertion instanceof FileAssert) {
            return Assumptions.asAssumption(FileAssert.class, File.class, actual);
        }
        if (assertion instanceof FileSizeAssert) {
            return Assumptions.asFileSizeAssumption(assertion);
        }
        if (assertion instanceof FloatAssert) {
            return Assumptions.asAssumption(FloatAssert.class, Float.class, actual);
        }
        if (assertion instanceof Float2DArrayAssert) {
            return Assumptions.asAssumption(Float2DArrayAssert.class, float[][].class, actual);
        }
        if (assertion instanceof FloatArrayAssert) {
            return Assumptions.asAssumption(FloatArrayAssert.class, float[].class, actual);
        }
        if (assertion instanceof FutureAssert) {
            return Assumptions.asAssumption(FutureAssert.class, Future.class, actual);
        }
        if (assertion instanceof InputStreamAssert) {
            return Assumptions.asAssumption(InputStreamAssert.class, InputStream.class, actual);
        }
        if (assertion instanceof InstantAssert) {
            return Assumptions.asAssumption(InstantAssert.class, Instant.class, actual);
        }
        if (assertion instanceof IntegerAssert) {
            return Assumptions.asAssumption(IntegerAssert.class, Integer.class, actual);
        }
        if (assertion instanceof Int2DArrayAssert) {
            return Assumptions.asAssumption(Int2DArrayAssert.class, int[][].class, actual);
        }
        if (assertion instanceof IntArrayAssert) {
            return Assumptions.asAssumption(IntArrayAssert.class, int[].class, actual);
        }
        if (assertion instanceof IntPredicateAssert) {
            return Assumptions.asAssumption(IntPredicateAssert.class, IntPredicate.class, actual);
        }
        if (assertion instanceof IterableAssert) {
            return Assumptions.asAssumption(IterableAssert.class, Iterable.class, actual);
        }
        if (assertion instanceof IterableSizeAssert) {
            return Assumptions.asIterableSizeAssumption(assertion);
        }
        if (assertion instanceof IteratorAssert) {
            return Assumptions.asAssumption(IteratorAssert.class, Iterator.class, actual);
        }
        if (assertion instanceof LocalDateAssert) {
            return Assumptions.asAssumption(LocalDateAssert.class, LocalDate.class, actual);
        }
        if (assertion instanceof LocalDateTimeAssert) {
            return Assumptions.asAssumption(LocalDateTimeAssert.class, LocalDateTime.class, actual);
        }
        if (assertion instanceof LocalTimeAssert) {
            return Assumptions.asAssumption(LocalTimeAssert.class, LocalTime.class, actual);
        }
        if (assertion instanceof LongAdderAssert) {
            return Assumptions.asAssumption(LongAdderAssert.class, LongAdder.class, actual);
        }
        if (assertion instanceof LongArrayAssert) {
            return Assumptions.asAssumption(LongArrayAssert.class, long[].class, actual);
        }
        if (assertion instanceof Long2DArrayAssert) {
            return Assumptions.asAssumption(Long2DArrayAssert.class, long[][].class, actual);
        }
        if (assertion instanceof LongAssert) {
            return Assumptions.asAssumption(LongAssert.class, Long.class, actual);
        }
        if (assertion instanceof LongPredicateAssert) {
            return Assumptions.asAssumption(LongPredicateAssert.class, LongPredicate.class, actual);
        }
        if (assertion instanceof MapAssert) {
            return Assumptions.asAssumption(MapAssert.class, Map.class, actual);
        }
        if (assertion instanceof MapSizeAssert) {
            return Assumptions.asMapSizeAssumption(assertion);
        }
        if (assertion instanceof OffsetDateTimeAssert) {
            return Assumptions.asAssumption(OffsetDateTimeAssert.class, OffsetDateTime.class, actual);
        }
        if (assertion instanceof OffsetTimeAssert) {
            return Assumptions.asAssumption(OffsetTimeAssert.class, OffsetTime.class, actual);
        }
        if (assertion instanceof ObjectAssert) {
            return Assumptions.asAssumption(ObjectAssert.class, Object.class, actual);
        }
        if (assertion instanceof OptionalAssert) {
            return Assumptions.asAssumption(OptionalAssert.class, Optional.class, actual);
        }
        if (assertion instanceof OptionalDoubleAssert) {
            return Assumptions.asAssumption(OptionalDoubleAssert.class, OptionalDouble.class, actual);
        }
        if (assertion instanceof OptionalIntAssert) {
            return Assumptions.asAssumption(OptionalIntAssert.class, OptionalInt.class, actual);
        }
        if (assertion instanceof OptionalLongAssert) {
            return Assumptions.asAssumption(OptionalLongAssert.class, OptionalLong.class, actual);
        }
        if (assertion instanceof PathAssert) {
            return Assumptions.asAssumption(PathAssert.class, Path.class, actual);
        }
        if (assertion instanceof PeriodAssert) {
            return Assumptions.asAssumption(PeriodAssert.class, Period.class, actual);
        }
        if (assertion instanceof PredicateAssert) {
            return Assumptions.asAssumption(PredicateAssert.class, Predicate.class, actual);
        }
        if (assertion instanceof RecursiveComparisonAssert) {
            return Assumptions.asRecursiveComparisonAssumption(assertion);
        }
        if (assertion instanceof ShortAssert) {
            return Assumptions.asAssumption(ShortAssert.class, Short.class, actual);
        }
        if (assertion instanceof Short2DArrayAssert) {
            return Assumptions.asAssumption(Short2DArrayAssert.class, short[][].class, actual);
        }
        if (assertion instanceof ShortArrayAssert) {
            return Assumptions.asAssumption(ShortArrayAssert.class, short[].class, actual);
        }
        if (assertion instanceof SpliteratorAssert) {
            return Assumptions.asAssumption(SpliteratorAssert.class, Spliterator.class, actual);
        }
        if (assertion instanceof StringAssert) {
            return Assumptions.asAssumption(StringAssert.class, String.class, actual);
        }
        if (assertion instanceof ThrowableAssert) {
            return Assumptions.asAssumption(ThrowableAssert.class, Throwable.class, actual);
        }
        if (assertion instanceof UriAssert) {
            return Assumptions.asAssumption(UriAssert.class, URI.class, actual);
        }
        if (assertion instanceof UrlAssert) {
            return Assumptions.asAssumption(UrlAssert.class, URL.class, actual);
        }
        if (assertion instanceof ZonedDateTimeAssert) {
            return Assumptions.asAssumption(ZonedDateTimeAssert.class, ZonedDateTime.class, actual);
        }
        if (assertion instanceof Abstract2DArrayAssert) {
            return Assumptions.asAssumption(Object2DArrayAssert.class, Object[][].class, actual);
        }
        throw new IllegalArgumentException("Unsupported assumption creation for " + assertion.getClass());
    }

    private static AbstractAssert<?, ?> asRecursiveComparisonAssumption(AbstractAssert<?, ?> assertion) {
        RecursiveComparisonAssert recursiveComparisonAssert = (RecursiveComparisonAssert)assertion;
        RecursiveComparisonConfiguration recursiveComparisonConfiguration = recursiveComparisonAssert.getRecursiveComparisonConfiguration();
        Class[] constructorTypes = Arrays.array(Object.class, RecursiveComparisonConfiguration.class);
        return Assumptions.asAssumption(RecursiveComparisonAssert.class, constructorTypes, assertion.actual, recursiveComparisonConfiguration);
    }

    private static AbstractAssert<?, ?> asMapSizeAssumption(AbstractAssert<?, ?> assertion) {
        MapSizeAssert mapSizeAssert = (MapSizeAssert)assertion;
        Class[] constructorTypes = Arrays.array(AbstractMapAssert.class, Integer.class);
        return Assumptions.asAssumption(MapSizeAssert.class, constructorTypes, mapSizeAssert.returnToMap(), assertion.actual);
    }

    private static AbstractAssert<?, ?> asIterableSizeAssumption(AbstractAssert<?, ?> assertion) {
        IterableSizeAssert iterableSizeAssert = (IterableSizeAssert)assertion;
        Class[] constructorTypes = Arrays.array(AbstractIterableAssert.class, Integer.class);
        return Assumptions.asAssumption(IterableSizeAssert.class, constructorTypes, iterableSizeAssert.returnToIterable(), assertion.actual);
    }

    private static AbstractAssert<?, ?> asFileSizeAssumption(AbstractAssert<?, ?> assertion) {
        FileSizeAssert fileSizeAssert = (FileSizeAssert)assertion;
        Class[] constructorTypes = Arrays.array(AbstractFileAssert.class);
        return Assumptions.asAssumption(FileSizeAssert.class, constructorTypes, fileSizeAssert.returnToFile());
    }

    private static final class AssumptionMethodInterceptor {
        private AssumptionMethodInterceptor() {
        }

        @RuntimeType
        public static Object intercept(@This AbstractAssert<?, ?> assertion, @SuperCall Callable<Object> proxy) throws Exception {
            try {
                Object result2 = proxy.call();
                if (result2 != assertion && result2 instanceof AbstractAssert) {
                    return Assumptions.asAssumption((AbstractAssert)result2).withAssertionState(assertion);
                }
                return result2;
            }
            catch (AssertionError e) {
                throw AssumptionExceptionFactory.assumptionNotMet(e);
            }
        }
    }
}

