/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Objects;
import org.assertj.core.api.Abstract2DArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.SubarraysShouldHaveSameSize;
import org.assertj.core.error.array2d.Array2dElementShouldBeDeepEqual;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Object2DArrays;
import org.assertj.core.util.VisibleForTesting;

public class Object2DArrayAssert<ELEMENT>
extends Abstract2DArrayAssert<Object2DArrayAssert<ELEMENT>, ELEMENT[][], ELEMENT> {
    @VisibleForTesting
    protected Object2DArrays<ELEMENT> object2dArrays = Object2DArrays.instance();
    private final Failures failures = Failures.instance();

    public Object2DArrayAssert(ELEMENT[][] actual) {
        super(actual, Object2DArrayAssert.class);
    }

    @Override
    public Object2DArrayAssert<ELEMENT> isDeepEqualTo(ELEMENT[][] expected) {
        if (this.actual == expected) {
            return (Object2DArrayAssert)this.myself;
        }
        this.isNotNull();
        if (expected.length != ((Object[][])this.actual).length) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(this.actual, expected, ((Object[][])this.actual).length, expected.length));
        }
        for (int i = 0; i < ((Object[][])this.actual).length; ++i) {
            Object[] actualSubArray = ((Object[][])this.actual)[i];
            ELEMENT[] expectedSubArray = expected[i];
            if (actualSubArray == expectedSubArray) continue;
            if (actualSubArray == null) {
                throw this.failures.failure((AssertionInfo)this.info, ShouldNotBeNull.shouldNotBeNull("actual[" + i + "]"));
            }
            if (expectedSubArray.length != actualSubArray.length) {
                throw this.failures.failure(this.info, SubarraysShouldHaveSameSize.subarraysShouldHaveSameSize(this.actual, expected, actualSubArray, actualSubArray.length, expectedSubArray, expectedSubArray.length, i), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
            for (int j = 0; j < actualSubArray.length; ++j) {
                if (Objects.deepEquals(actualSubArray[j], expectedSubArray[j])) continue;
                throw this.failures.failure(this.info, Array2dElementShouldBeDeepEqual.elementShouldBeEqual(actualSubArray[j], expectedSubArray[j], i, j), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
        }
        return (Object2DArrayAssert)this.myself;
    }

    @Override
    public Object2DArrayAssert<ELEMENT> isEqualTo(Object expected) {
        return (Object2DArrayAssert)super.isEqualTo(expected);
    }

    @Override
    public void isNullOrEmpty() {
        this.object2dArrays.assertNullOrEmpty(this.info, (Object[][])this.actual);
    }

    @Override
    public void isEmpty() {
        this.object2dArrays.assertEmpty(this.info, (Object[][])this.actual);
    }

    @Override
    public Object2DArrayAssert<ELEMENT> isNotEmpty() {
        this.object2dArrays.assertNotEmpty(this.info, (Object[][])this.actual);
        return (Object2DArrayAssert)this.myself;
    }

    @Override
    public Object2DArrayAssert<ELEMENT> hasDimensions(int expectedFirstDimension, int expectedSecondDimension) {
        this.object2dArrays.assertHasDimensions(this.info, (Object[][])this.actual, expectedFirstDimension, expectedSecondDimension);
        return (Object2DArrayAssert)this.myself;
    }

    @Override
    public Object2DArrayAssert<ELEMENT> hasSameDimensionsAs(Object array) {
        this.object2dArrays.assertHasSameDimensionsAs(this.info, (Object[][])this.actual, array);
        return (Object2DArrayAssert)this.myself;
    }

    public Object2DArrayAssert<ELEMENT> contains(ELEMENT[] value, Index index) {
        this.object2dArrays.assertContains(this.info, (Object[][])this.actual, value, index);
        return (Object2DArrayAssert)this.myself;
    }

    public Object2DArrayAssert<ELEMENT> doesNotContain(ELEMENT[] value, Index index) {
        this.object2dArrays.assertDoesNotContain(this.info, (Object[][])this.actual, value, index);
        return (Object2DArrayAssert)this.myself;
    }
}

