/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.listeners;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.SuggesterSupport;
import training.featuresSuggester.SuggestingUtils;
import training.featuresSuggester.actions.BeforeChildAddedAction;
import training.featuresSuggester.actions.BeforeChildMovedAction;
import training.featuresSuggester.actions.BeforeChildRemovedAction;
import training.featuresSuggester.actions.BeforeChildReplacedAction;
import training.featuresSuggester.actions.BeforeChildrenChangedAction;
import training.featuresSuggester.actions.BeforePropertyChangedAction;
import training.featuresSuggester.actions.ChildAddedAction;
import training.featuresSuggester.actions.ChildMovedAction;
import training.featuresSuggester.actions.ChildRemovedAction;
import training.featuresSuggester.actions.ChildReplacedAction;
import training.featuresSuggester.actions.ChildrenChangedAction;
import training.featuresSuggester.actions.PropertyChangedAction;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltraining/featuresSuggester/listeners/PsiActionsListener;", "Lcom/intellij/psi/PsiTreeChangeAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "beforeChildAddition", "", "event", "Lcom/intellij/psi/PsiTreeChangeEvent;", "beforeChildMovement", "beforeChildRemoval", "beforeChildReplacement", "beforeChildrenChange", "beforePropertyChange", "childAdded", "childMoved", "childRemoved", "childReplaced", "childrenChanged", "isLoadedSourceFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "propertyChanged", "intellij.featuresTrainer"})
public final class PsiActionsListener
extends PsiTreeChangeAdapter {
    private final Project project;

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforePropertyChangedAction(psiFile2, psiElement, System.currentTimeMillis()));
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"event.child");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforeChildAddedAction(psiFile2, psiElement, psiElement2, System.currentTimeMillis()));
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getNewChild() == null || event.getOldChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        PsiElement psiElement2 = event.getNewChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"event.newChild");
        PsiElement psiElement3 = event.getOldChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"event.oldChild");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforeChildReplacedAction(psiFile2, psiElement, psiElement2, psiElement3, System.currentTimeMillis()));
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforeChildrenChangedAction(psiFile2, psiElement, System.currentTimeMillis()));
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || event.getOldParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"event.child");
        PsiElement psiElement3 = event.getOldParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"event.oldParent");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforeChildMovedAction(psiFile2, psiElement, psiElement2, psiElement3, System.currentTimeMillis()));
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"event.child");
        SuggestingUtils.INSTANCE.handleAction(this.project, new BeforeChildRemovedAction(psiFile2, psiElement, psiElement2, System.currentTimeMillis()));
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        SuggestingUtils.INSTANCE.handleAction(this.project, new PropertyChangedAction(psiFile2, psiElement, System.currentTimeMillis()));
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"event.child");
        SuggestingUtils.INSTANCE.handleAction(this.project, new ChildRemovedAction(psiFile2, psiElement, psiElement2, System.currentTimeMillis()));
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getNewChild() == null || event.getOldChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        PsiElement psiElement2 = event.getNewChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"event.newChild");
        PsiElement psiElement3 = event.getOldChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"event.oldChild");
        SuggestingUtils.INSTANCE.handleAction(this.project, new ChildReplacedAction(psiFile2, psiElement, psiElement2, psiElement3, System.currentTimeMillis()));
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"event.child");
        SuggestingUtils.INSTANCE.handleAction(this.project, new ChildAddedAction(psiFile2, psiElement, psiElement2, System.currentTimeMillis()));
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        SuggestingUtils.INSTANCE.handleAction(this.project, new ChildrenChangedAction(psiFile2, psiElement, System.currentTimeMillis()));
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getParent() == null || event.getChild() == null || event.getOldParent() == null || !this.isLoadedSourceFile(event.getFile())) {
            return;
        }
        PsiFile psiFile2 = event.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"event.file!!");
        PsiElement psiElement = event.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"event.parent");
        PsiElement psiElement2 = event.getChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"event.child");
        PsiElement psiElement3 = event.getOldParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"event.oldParent");
        SuggestingUtils.INSTANCE.handleAction(this.project, new ChildMovedAction(psiFile2, psiElement, psiElement2, psiElement3, System.currentTimeMillis()));
    }

    private final boolean isLoadedSourceFile(PsiFile psiFile2) {
        PsiFile psiFile3 = psiFile2;
        if (psiFile3 == null || (psiFile3 = psiFile3.getLanguage()) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"psiFile?.language ?: return false");
        PsiFile language = psiFile3;
        SuggesterSupport suggesterSupport = SuggesterSupport.Companion.getForLanguage((Language)language);
        return suggesterSupport != null && suggesterSupport.isLoadedSourceFile(psiFile2);
    }

    public PsiActionsListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

