/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.KeywordStringsGenerated;
import org.jetbrains.annotations.NotNull;

public final class RenderingUtilsKt {
    @NotNull
    public static final String render(@NotNull Name $this$render) {
        String string;
        Intrinsics.checkNotNullParameter($this$render, "<this>");
        if (RenderingUtilsKt.shouldBeEscaped($this$render)) {
            char c = '`';
            String string2 = $this$render.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString()");
            string = Intrinsics.stringPlus(c + string2, "`");
        } else {
            String string3 = $this$render.asString();
            Intrinsics.checkNotNullExpressionValue(string3, "asString()");
            string = string3;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(Name $this$shouldBeEscaped) {
        boolean bl;
        if ($this$shouldBeEscaped.isSpecial()) {
            return false;
        }
        String string = $this$shouldBeEscaped.asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString()");
        String string2 = string;
        if (KeywordStringsGenerated.KEYWORDS.contains(string2)) return true;
        CharSequence $this$any$iv = string2;
        boolean $i$f$any = false;
        CharSequence charSequence = $this$any$iv;
        int n = 0;
        do {
            if (n >= charSequence.length()) return false;
            char element$iv = charSequence.charAt(n);
            ++n;
            char it = element$iv;
            boolean bl2 = false;
            if (!Character.isLetterOrDigit(it) && it != '_') {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final String render(@NotNull FqNameUnsafe $this$render) {
        Intrinsics.checkNotNullParameter($this$render, "<this>");
        List<Name> list = $this$render.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, "pathSegments()");
        return RenderingUtilsKt.renderFqName(list);
    }

    @NotNull
    public static final String renderFqName(@NotNull List<Name> pathSegments) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(pathSegments, "pathSegments");
        StringBuilder $this$renderFqName_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Name element : pathSegments) {
            if ($this$renderFqName_u24lambda_u2d1.length() > 0) {
                $this$renderFqName_u24lambda_u2d1.append(".");
            }
            $this$renderFqName_u24lambda_u2d1.append(RenderingUtilsKt.render(element));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

