/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.documentation;

import com.intellij.codeInsight.javadoc.JavaDocHighlightingManager;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;

public class GroovyDocHighlightingManager
implements JavaDocHighlightingManager {
    @NotNull
    private static final GroovyDocHighlightingManager INSTANCE = new GroovyDocHighlightingManager();

    @NotNull
    public static GroovyDocHighlightingManager getInstance() {
        GroovyDocHighlightingManager groovyDocHighlightingManager = INSTANCE;
        if (groovyDocHighlightingManager == null) {
            GroovyDocHighlightingManager.$$$reportNull$$$0(0);
        }
        return groovyDocHighlightingManager;
    }

    @NotNull
    private static TextAttributes resolveAttributes(@NotNull TextAttributesKey attributesKey) {
        if (attributesKey == null) {
            GroovyDocHighlightingManager.$$$reportNull$$$0(1);
        }
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
        if (textAttributes == null) {
            GroovyDocHighlightingManager.$$$reportNull$$$0(2);
        }
        return textAttributes;
    }

    @NotNull
    public TextAttributes getClassDeclarationAttributes(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GroovyDocHighlightingManager.$$$reportNull$$$0(3);
        }
        if (aClass.isInterface()) {
            TextAttributes textAttributes = this.getInterfaceNameAttributes();
            if (textAttributes == null) {
                GroovyDocHighlightingManager.$$$reportNull$$$0(4);
            }
            return textAttributes;
        }
        if (aClass.isEnum()) {
            TextAttributes textAttributes = this.getEnumNameAttributes();
            if (textAttributes == null) {
                GroovyDocHighlightingManager.$$$reportNull$$$0(5);
            }
            return textAttributes;
        }
        if (aClass instanceof PsiAnonymousClass) {
            TextAttributes textAttributes = this.getAnonymousClassNameAttributes();
            if (textAttributes == null) {
                GroovyDocHighlightingManager.$$$reportNull$$$0(6);
            }
            return textAttributes;
        }
        if (aClass.hasModifierProperty("abstract")) {
            TextAttributes textAttributes = this.getAbstractClassNameAttributes();
            if (textAttributes == null) {
                GroovyDocHighlightingManager.$$$reportNull$$$0(7);
            }
            return textAttributes;
        }
        TextAttributes textAttributes = this.getClassNameAttributes();
        if (textAttributes == null) {
            GroovyDocHighlightingManager.$$$reportNull$$$0(8);
        }
        return textAttributes;
    }

    @NotNull
    public TextAttributes getMethodDeclarationAttributes(@NotNull PsiMethod method) {
        if (method == null) {
            GroovyDocHighlightingManager.$$$reportNull$$$0(9);
        }
        TextAttributes textAttributes = method.isConstructor() ? this.getConstructorDeclarationAttributes() : this.getMethodDeclarationAttributes();
        if (textAttributes == null) {
            GroovyDocHighlightingManager.$$$reportNull$$$0(10);
        }
        return textAttributes;
    }

    @NotNull
    public TextAttributes getFieldDeclarationAttributes(@NotNull PsiField field) {
        boolean isStatic;
        if (field == null) {
            GroovyDocHighlightingManager.$$$reportNull$$$0(11);
        }
        TextAttributes textAttributes = (isStatic = field.hasModifierProperty("static")) ? this.getStaticFieldAttributes() : this.getInstanceFieldAttributes();
        if (textAttributes == null) {
            GroovyDocHighlightingManager.$$$reportNull$$$0(12);
        }
        return textAttributes;
    }

    @NotNull
    public TextAttributes getInterfaceNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.INTERFACE_NAME);
    }

    @NotNull
    public TextAttributes getEnumNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.ENUM_NAME);
    }

    @NotNull
    public TextAttributes getAnonymousClassNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.ANONYMOUS_CLASS_NAME);
    }

    @NotNull
    public TextAttributes getAbstractClassNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.ABSTRACT_CLASS_NAME);
    }

    @NotNull
    public TextAttributes getClassNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.CLASS_REFERENCE);
    }

    @NotNull
    public TextAttributes getKeywordAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.KEYWORD);
    }

    @NotNull
    public TextAttributes getCommaAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(JavaHighlightingColors.COMMA);
    }

    @NotNull
    public TextAttributes getParameterAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.PARAMETER);
    }

    @NotNull
    public TextAttributes getTypeParameterNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.TYPE_PARAMETER);
    }

    @NotNull
    public TextAttributes getStaticFieldAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.STATIC_FIELD);
    }

    @NotNull
    public TextAttributes getInstanceFieldAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.INSTANCE_FIELD);
    }

    @NotNull
    public TextAttributes getOperationSignAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.OPERATION_SIGN);
    }

    @NotNull
    public TextAttributes getLocalVariableAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.LOCAL_VARIABLE);
    }

    @NotNull
    public TextAttributes getConstructorDeclarationAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.CONSTRUCTOR_DECLARATION);
    }

    @NotNull
    public TextAttributes getMethodDeclarationAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.METHOD_DECLARATION);
    }

    @NotNull
    public TextAttributes getParenthesesAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.PARENTHESES);
    }

    @NotNull
    public TextAttributes getDotAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(JavaHighlightingColors.DOT);
    }

    @NotNull
    public TextAttributes getBracketsAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.BRACKETS);
    }

    @NotNull
    public TextAttributes getMethodCallAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.METHOD_CALL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/documentation/GroovyDocHighlightingManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/documentation/GroovyDocHighlightingManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAttributes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDeclarationAttributes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodDeclarationAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldDeclarationAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclarationAttributes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclarationAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFieldDeclarationAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

