/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.typing.GrCallTypeCalculator;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0018\u00010\tj\u0004\u0018\u0001`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/ClosureMethodsCallTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrCallTypeCalculator;", "()V", "getType", "Lcom/intellij/psi/PsiType;", "receiver", "method", "Lcom/intellij/psi/PsiMethod;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "context", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.groovy.psi"})
public final class ClosureMethodsCallTypeCalculator
implements GrCallTypeCalculator {
    @NlsSafe
    private static final String CALL = "call";
    @NlsSafe
    private static final String CURRY = "curry";
    @NlsSafe
    private static final String NCURRY = "ncurry";
    @NlsSafe
    private static final String RCURRY = "rcurry";
    @NlsSafe
    private static final String MEMOIZE = "memoize";
    @NlsSafe
    private static final String TRAMPOLINE = "trampoline";
    private static final Set<String> interestingNames;
    @NotNull
    public static final Companion Companion;

    @Override
    @Nullable
    public PsiType getType(@Nullable PsiType receiver, @NotNull PsiMethod method, @Nullable List<? extends Argument> arguments2, @NotNull PsiElement context) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(receiver instanceof GroovyClosureType)) {
            return null;
        }
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String methodName = string;
        if (!interestingNames.contains(methodName)) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"groovy.lang.Closure") ^ true) {
            return null;
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)MEMOIZE)) {
            return receiver;
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)CALL)) {
            return ((GroovyClosureType)receiver).returnType(arguments2);
        }
        if (arguments2 == null) {
            return null;
        }
        switch (methodName) {
            case "rcurry": {
                psiType = ((GroovyClosureType)receiver).curry(-arguments2.size(), arguments2, context);
                break;
            }
            case "trampoline": 
            case "curry": {
                psiType = ((GroovyClosureType)receiver).curry(0, arguments2, context);
                break;
            }
            case "ncurry": {
                Integer value;
                GrLiteral literal;
                Object object = CollectionsKt.firstOrNull(arguments2);
                if (!(object instanceof ExpressionArgument)) {
                    object = null;
                }
                ExpressionArgument expressionArgument = (ExpressionArgument)object;
                GrExpression grExpression = expressionArgument != null ? expressionArgument.getExpression() : null;
                if (!(grExpression instanceof GrLiteral)) {
                    grExpression = null;
                }
                GrLiteral grLiteral = literal = (GrLiteral)grExpression;
                Object object2 = grLiteral != null ? grLiteral.getValue() : null;
                if (!(object2 instanceof Integer)) {
                    object2 = null;
                }
                if ((value = (Integer)object2) != null) {
                    psiType = ((GroovyClosureType)receiver).curry(value, CollectionsKt.drop((Iterable)arguments2, (int)1), context);
                    break;
                }
                psiType = receiver;
                break;
            }
            default: {
                psiType = null;
            }
        }
        return psiType;
    }

    static {
        Companion = new Companion(null);
        interestingNames = SetsKt.setOf((Object[])new String[]{CALL, CURRY, NCURRY, RCURRY, MEMOIZE, TRAMPOLINE});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/ClosureMethodsCallTypeCalculator$Companion;", "", "()V", "CALL", "", "CURRY", "MEMOIZE", "NCURRY", "RCURRY", "TRAMPOLINE", "interestingNames", "", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

