/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class GroovyUtils {
    public static File[] getFilesInDirectoryByPattern(String dirPath, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        return LibrariesUtil.getFilesInDirectoryByPattern(dirPath, pattern);
    }

    @Nullable
    public static GrTypeDefinition getPublicClass(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            GroovyUtils.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GroovyUtils.$$$reportNull$$$0(1);
        }
        return GroovyUtils.getPublicClass(file, PsiManager.getInstance((Project)project));
    }

    @Nullable
    public static GrTypeDefinition getPublicClass(@Nullable VirtualFile virtualFile, @NotNull PsiManager manager) {
        if (manager == null) {
            GroovyUtils.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            return null;
        }
        PsiFile psiFile = manager.findFile(virtualFile);
        if (psiFile instanceof PsiCompiledFile) {
            psiFile = psiFile.getNavigationElement();
        }
        if (psiFile instanceof GroovyFile) {
            return GroovyUtils.getClassDefinition((GroovyFile)psiFile);
        }
        return null;
    }

    @Nullable
    public static GrTypeDefinition getClassDefinition(@NotNull GroovyFile groovyFile) {
        String fileName;
        int idx;
        if (groovyFile == null) {
            GroovyUtils.$$$reportNull$$$0(3);
        }
        if ((idx = (fileName = groovyFile.getName()).lastIndexOf(46)) < 0) {
            return null;
        }
        return GroovyUtils.getClassDefinition(groovyFile, fileName.substring(0, idx));
    }

    @Nullable
    public static GrTypeDefinition getClassDefinition(@NotNull GroovyFile groovyFile, @NotNull String classSimpleName) {
        if (groovyFile == null) {
            GroovyUtils.$$$reportNull$$$0(4);
        }
        if (classSimpleName == null) {
            GroovyUtils.$$$reportNull$$$0(5);
        }
        for (GrTypeDefinition definition : groovyFile.getTypeDefinitions()) {
            if (!classSimpleName.equals(definition.getName())) continue;
            return definition;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groovyFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSimpleName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/util/GroovyUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPublicClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

