/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesUtil {
    private static final Pattern LOCALE_PATTERN = Pattern.compile("(_[a-zA-Z]{2,8}(_[a-zA-Z]{2}|[0-9]{3})?(_[\\w\\-]+)?)\\.[^_]+$");
    public static final Set<Character> BASE_NAME_BORDER_CHAR = Set.of(Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('.'));
    public static final Locale DEFAULT_LOCALE = new Locale("", "", "");
    private static final Supplier<Set<String>> LOCALES_LANGUAGE_CODES = NotNullLazyValue.softLazy(() -> {
        HashSet locales = new HashSet(ContainerUtil.flatten((Iterable)ContainerUtil.map((Object[])Locale.getAvailableLocales(), locale -> {
            ArrayList languages = ContainerUtil.newArrayList((Object[])new String[]{locale.getLanguage()});
            try {
                languages.add(locale.getISO3Language());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return languages;
        })));
        locales.addAll(ContainerUtil.newArrayList((Object[])Locale.getISOLanguages()));
        return locales;
    });

    public static boolean containsProperty(ResourceBundle resourceBundle, String propertyName) {
        for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
            if (propertiesFile.findPropertyByKey(propertyName) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getDefaultBaseName(Collection<? extends PropertiesFile> files) {
        String commonPrefix = null;
        for (PropertiesFile propertiesFile : files) {
            String baseName = propertiesFile.getVirtualFile().getNameWithoutExtension();
            if (commonPrefix == null) {
                commonPrefix = baseName;
                continue;
            }
            if (!(commonPrefix = StringUtil.commonPrefix((String)commonPrefix, (String)baseName)).isEmpty()) continue;
            break;
        }
        assert (commonPrefix != null);
        if (!commonPrefix.isEmpty() && BASE_NAME_BORDER_CHAR.contains(Character.valueOf(commonPrefix.charAt(commonPrefix.length() - 1)))) {
            commonPrefix = commonPrefix.substring(0, commonPrefix.length() - 1);
        }
        String string = commonPrefix;
        if (string == null) {
            PropertiesUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    static String getDefaultBaseName(final @NotNull PsiFile file) {
        if (file == null) {
            PropertiesUtil.$$$reportNull$$$0(1);
        }
        String string = (String)CachedValuesManager.getCachedValue((PsiElement)file, (CachedValueProvider)new CachedValueProvider<String>(){

            @NotNull
            public CachedValueProvider.Result<String> compute() {
                CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)this.computeBaseName(), (Object[])new Object[]{file});
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                return result;
            }

            private String computeBaseName() {
                String name = file.getName();
                if (!StringUtil.containsChar((String)name, (char)'_')) {
                    return FileUtilRt.getNameWithoutExtension((String)name);
                }
                Matcher matcher = LOCALE_PATTERN.matcher(name);
                int matchIndex = 0;
                while (matcher.find(matchIndex)) {
                    MatchResult matchResult = matcher.toMatchResult();
                    String[] splitted = matchResult.group(1).split("_");
                    if (splitted.length <= 1) continue;
                    String langCode = splitted[1];
                    if (!LOCALES_LANGUAGE_CODES.get().contains(langCode)) {
                        matchIndex = matchResult.start(1) + 1;
                        continue;
                    }
                    String baseNameWithExtension = name.substring(0, matchResult.start(1)) + name.substring(matchResult.end(1));
                    return FileUtilRt.getNameWithoutExtension((String)baseNameWithExtension);
                }
                String baseNameWithExtension = name;
                return FileUtilRt.getNameWithoutExtension((String)baseNameWithExtension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil$1", "compute"));
            }
        });
        if (string == null) {
            PropertiesUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static Locale getLocale(@NotNull PropertiesFile propertiesFile) {
        String name;
        if (propertiesFile == null) {
            PropertiesUtil.$$$reportNull$$$0(3);
        }
        if (!StringUtil.containsChar((String)(name = propertiesFile.getName()), (char)'_')) {
            Locale locale = DEFAULT_LOCALE;
            if (locale == null) {
                PropertiesUtil.$$$reportNull$$$0(4);
            }
            return locale;
        }
        String containingResourceBundleBaseName = propertiesFile.getResourceBundle().getBaseName();
        if (!name.startsWith(containingResourceBundleBaseName)) {
            Locale locale = DEFAULT_LOCALE;
            if (locale == null) {
                PropertiesUtil.$$$reportNull$$$0(5);
            }
            return locale;
        }
        return PropertiesUtil.getLocale(name.substring(containingResourceBundleBaseName.length()));
    }

    @NotNull
    public static Locale getLocale(String suffix) {
        Locale locale = (Locale)PropertiesUtil.getLocaleAndTrimmedSuffix(suffix).getFirst();
        if (locale == null) {
            PropertiesUtil.$$$reportNull$$$0(6);
        }
        return locale;
    }

    @NotNull
    public static Pair<Locale, String> getLocaleAndTrimmedSuffix(String suffix) {
        String rawLocale;
        String[] splitRawLocale;
        Matcher matcher = LOCALE_PATTERN.matcher(suffix);
        if (matcher.find() && (splitRawLocale = (rawLocale = matcher.group(1)).split("_")).length > 1 && splitRawLocale[1].length() >= 2) {
            String language = splitRawLocale[1];
            String country = splitRawLocale.length > 2 ? splitRawLocale[2] : "";
            String variant = splitRawLocale.length > 3 ? splitRawLocale[3] : "";
            StringBuilder trimmedSuffix = new StringBuilder(language);
            if (!country.isEmpty()) {
                trimmedSuffix.append("_").append(country);
            }
            if (!variant.isEmpty()) {
                trimmedSuffix.append("_").append(variant);
            }
            Pair pair = Pair.create((Object)new Locale(language, country, variant), (Object)trimmedSuffix.toString());
            if (pair == null) {
                PropertiesUtil.$$$reportNull$$$0(7);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)DEFAULT_LOCALE, (Object)"");
        if (pair == null) {
            PropertiesUtil.$$$reportNull$$$0(8);
        }
        return pair;
    }

    @Nullable
    public static PropertiesFile getParent(@NotNull PropertiesFile file, @NotNull Collection<? extends PropertiesFile> candidates) {
        VirtualFile virtualFile;
        if (file == null) {
            PropertiesUtil.$$$reportNull$$$0(9);
        }
        if (candidates == null) {
            PropertiesUtil.$$$reportNull$$$0(10);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return null;
        }
        String name = virtualFile.getNameWithoutExtension();
        String[] parts = name.split("_");
        if (parts.length == 1) {
            return null;
        }
        List<String> partsList = Arrays.asList(parts);
        for (int i = parts.length - 1; i >= 1; --i) {
            String parentName = StringUtil.join(partsList.subList(0, i), (String)"_") + "." + virtualFile.getExtension();
            for (PropertiesFile propertiesFile : candidates) {
                if (!parentName.equals(propertiesFile.getName())) continue;
                return propertiesFile;
            }
        }
        return null;
    }

    public static List<IProperty> findAllProperties(@NotNull ResourceBundle resourceBundle, String key) {
        if (resourceBundle == null) {
            PropertiesUtil.$$$reportNull$$$0(11);
        }
        SmartList result = new SmartList();
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            result.addAll(propertiesFile.findPropertiesByKey(key));
        }
        return result;
    }

    public static boolean isUnescapedBackSlashAtTheEnd(String text) {
        boolean result = false;
        for (int i = text.length() - 1; i >= 0 && text.charAt(i) == '\\'; --i) {
            result = !result;
        }
        return result;
    }

    @Nullable
    static String getPackageQualifiedName(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PropertiesUtil.$$$reportNull$$$0(12);
        }
        return ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex().getPackageNameByDirectory(directory.getVirtualFile());
    }

    @NotNull
    @Nls
    public static String getPresentableLocale(@NotNull Locale locale) {
        if (locale == null) {
            PropertiesUtil.$$$reportNull$$$0(13);
        }
        ArrayList<String> names = new ArrayList<String>();
        if (locale.getDisplayLanguage() != null) {
            names.add(locale.getDisplayLanguage());
        }
        if (locale.getDisplayCountry() != null) {
            names.add(locale.getDisplayCountry());
        }
        if (locale.getDisplayVariant() != null) {
            names.add(locale.getDisplayVariant());
        }
        Object object = names.isEmpty() ? "" : " (" + StringUtil.join(names, (String)"/") + ")";
        if (object == null) {
            PropertiesUtil.$$$reportNull$$$0(14);
        }
        return object;
    }

    public static boolean hasDefaultLanguage(Locale locale) {
        return LOCALES_LANGUAGE_CODES.get().contains(locale.getLanguage());
    }

    @NotNull
    public static String getSuffix(@NotNull PropertiesFile propertiesFile) {
        String propertiesFileName;
        String baseName;
        if (propertiesFile == null) {
            PropertiesUtil.$$$reportNull$$$0(15);
        }
        if ((baseName = propertiesFile.getResourceBundle().getBaseName()).equals(FileUtilRt.getNameWithoutExtension((String)(propertiesFileName = propertiesFile.getName())))) {
            return "";
        }
        String string = FileUtilRt.getNameWithoutExtension((String)propertiesFileName.substring(baseName.length() + 1));
        if (string == null) {
            PropertiesUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/PropertiesUtil";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBaseName";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/PropertiesUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocaleAndTrimmedSuffix";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableLocale";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBaseName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLocale";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAllProperties";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPackageQualifiedName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableLocale";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSuffix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

