/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\f0\u0004\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0016\u0010\u0013\u001a\u00070\u0004\u00a2\u0006\u0002\b\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/PluginEnvironment;", "", "()V", "PACKAGE_SEARCH_NOTIFICATION_GROUP_ID", "", "PLUGIN_ID", "ideBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "Lorg/jetbrains/annotations/NotNull;", "getIdeBuildNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "ideVersion", "Lcom/intellij/openapi/util/NlsSafe;", "getIdeVersion", "()Ljava/lang/String;", "isNonModalLoadingEnabled", "", "()Z", "isTestEnvironment", "pluginVersion", "getPluginVersion", "Caches", "intellij.packageSearch"})
public final class PluginEnvironment {
    @NotNull
    public static final String PACKAGE_SEARCH_NOTIFICATION_GROUP_ID = "packagesearch.notification";
    @NotNull
    public static final String PLUGIN_ID = "com.jetbrains.packagesearch.intellij-plugin";
    @NotNull
    public static final PluginEnvironment INSTANCE;

    @NotNull
    public final String getPluginVersion() {
        Object object = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)PLUGIN_ID));
        if (object == null || (object = object.getVersion()) == null) {
            object = PackageSearchBundle.INSTANCE.message("packagesearch.version.undefined", new Object[0]);
        }
        return object;
    }

    @NotNull
    public final String getIdeVersion() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        String string = applicationInfo.getStrictVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationInfo.getInstance().strictVersion");
        return string;
    }

    @NotNull
    public final BuildNumber getIdeBuildNumber() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        return buildNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTestEnvironment() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) return true;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        if (!application2.isHeadlessEnvironment()) return false;
        return true;
    }

    public final boolean isNonModalLoadingEnabled() {
        return Intrinsics.areEqual((Object)System.getProperty("idea.pkgs.disableLoading"), (Object)"true") ^ true && !this.isTestEnvironment();
    }

    private PluginEnvironment() {
    }

    static {
        PluginEnvironment pluginEnvironment;
        INSTANCE = pluginEnvironment = new PluginEnvironment();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/PluginEnvironment$Caches;", "", "()V", "maxAttempts", "", "getMaxAttempts", "()I", "version", "getVersion", "intellij.packageSearch"})
    public static final class Caches {
        @NotNull
        public static final Caches INSTANCE;

        public final int getVersion() {
            return 2;
        }

        public final int getMaxAttempts() {
            int n;
            String string = System.getProperty("idea.pkgs.caches.attempts");
            if (string != null) {
                String string2 = string;
                n = Integer.parseInt(string2);
            } else {
                n = 30;
            }
            return n;
        }

        private Caches() {
        }

        static {
            Caches caches;
            INSTANCE = caches = new Caches();
        }
    }
}

