/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.packageversionutils;

import com.jetbrains.packagesearch.packageversionutils.PackageVersionUtils;
import com.jetbrains.packagesearch.packageversionutils.VersionTokenMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u000e\u001a\u00020\u0006*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/packagesearch/packageversionutils/PackageVersionUtils;", "", "()V", "singleLetterUnstableMarkerRegex", "Lkotlin/text/Regex;", "evaluateStability", "", "versionName", "", "loggingCallback", "Lkotlin/Function1;", "", "tokenizeVersionName", "", "isTokenBoundary", "", "previousChar", "package-version-utils"})
public final class PackageVersionUtils {
    private static final Regex singleLetterUnstableMarkerRegex;
    @NotNull
    public static final PackageVersionUtils INSTANCE;

    public final boolean evaluateStability(@NotNull String versionName, @NotNull Function1<? super String, Unit> loggingCallback) {
        boolean bl;
        block14: {
            Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
            Intrinsics.checkNotNullParameter(loggingCallback, (String)"loggingCallback");
            if (StringsKt.isBlank((CharSequence)versionName)) {
                return false;
            }
            if (singleLetterUnstableMarkerRegex.containsMatchIn((CharSequence)versionName)) {
                loggingCallback.invoke((Object)("Version '" + versionName + "' contains a single-letter milestone/alpha/beta -> Unstable"));
                return false;
            }
            List<String> tokens = this.tokenizeVersionName(versionName);
            Iterable $this$none$iv = tokens;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    boolean bl2;
                    block13: {
                        String token = (String)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv = VersionTokenMatcher.Companion.getUnstableTokens();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                VersionTokenMatcher matcher = (VersionTokenMatcher)element$iv2;
                                boolean bl4 = false;
                                boolean matches = matcher.matches(token);
                                if (matches) {
                                    String string;
                                    VersionTokenMatcher versionTokenMatcher = matcher;
                                    if (versionTokenMatcher instanceof VersionTokenMatcher.SubstringMatcher) {
                                        string = "contains '" + ((VersionTokenMatcher.SubstringMatcher)matcher).getToMatch() + '\'';
                                    } else if (versionTokenMatcher instanceof VersionTokenMatcher.RegexMatcher) {
                                        string = "matches '" + ((VersionTokenMatcher.RegexMatcher)matcher).getRegex().getPattern() + '\'';
                                    } else {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                    String detailMessage = string;
                                    loggingCallback.invoke((Object)("Version '" + versionName + "' " + detailMessage + " -> Unstable"));
                                }
                                if (!matches) continue;
                                bl2 = true;
                                break block13;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean evaluateStability$default(PackageVersionUtils packageVersionUtils, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = evaluateStability.1.INSTANCE;
        }
        return packageVersionUtils.evaluateStability(string, (Function1<? super String, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> tokenizeVersionName(String versionName) {
        void $this$filterTo$iv$iv;
        boolean bl = false;
        List tokens = new ArrayList();
        Character previousChar = null;
        StringBuilder tokenBuilder = new StringBuilder(versionName.length());
        Object $this$forEach$iv = versionName;
        boolean $i$f$forEach22 = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char c = element$iv = charSequence.charAt(i);
            boolean bl2 = false;
            if (previousChar != null) {
                Character c2 = previousChar;
                Intrinsics.checkNotNull((Object)c2);
                if (INSTANCE.isTokenBoundary(c, c2.charValue())) {
                    Collection collection = tokens;
                    String string = tokenBuilder.toString();
                    boolean bl3 = false;
                    collection.add(string);
                    StringsKt.clear((StringBuilder)tokenBuilder);
                }
            }
            tokenBuilder.append(c);
            previousChar = Character.valueOf(c);
        }
        $this$forEach$iv = tokens;
        String $i$f$forEach22 = tokenBuilder.toString();
        boolean bl4 = false;
        $this$forEach$iv.add($i$f$forEach22);
        Iterable $this$filter$iv = tokens;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl5;
            block5: {
                String token = (String)element$iv$iv;
                boolean bl6 = false;
                CharSequence $this$any$iv = token;
                boolean $i$f$any = false;
                CharSequence charSequence2 = $this$any$iv;
                for (int i = 0; i < charSequence2.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence2.charAt(i);
                    boolean bl7 = false;
                    char c = it;
                    boolean bl8 = false;
                    if (!Character.isLetterOrDigit(c)) continue;
                    bl5 = true;
                    break block5;
                }
                bl5 = false;
            }
            if (!bl5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTokenBoundary(char $this$isTokenBoundary, char previousChar) {
        char c = $this$isTokenBoundary;
        boolean bl = false;
        if (!Character.isLetterOrDigit(c)) {
            return true;
        }
        c = $this$isTokenBoundary;
        bl = false;
        if (Character.isLetter(c)) {
            c = previousChar;
            bl = false;
            if (!Character.isLetter(c)) {
                return true;
            }
        }
        c = $this$isTokenBoundary;
        bl = false;
        if (!Character.isDigit(c)) return false;
        c = previousChar;
        bl = false;
        if (Character.isDigit(c)) return false;
        return true;
    }

    private PackageVersionUtils() {
    }

    static {
        PackageVersionUtils packageVersionUtils;
        INSTANCE = packageVersionUtils = new PackageVersionUtils();
        String string = "\\b[abmt][.\\-]?\\d{1,3}\\w?\\b";
        RegexOption regexOption = RegexOption.IGNORE_CASE;
        boolean bl = false;
        singleLetterUnstableMarkerRegex = new Regex(string, regexOption);
    }
}

