/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.jdk;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexDownloadService;
import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.java.jdk.JdkAliases;
import com.intellij.indexing.shared.java.jdk.JdkIndexLookupRequest;
import com.intellij.indexing.shared.java.jdk.SharedJdkChunkStore;
import com.intellij.indexing.shared.java.jdk.SharedJdkIndexChunkLocatorKt;
import com.intellij.indexing.shared.java.jdk.SharedJdkIndexSuggestion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerListener;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b*\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/indexing/shared/java/jdk/SharedJdkIndexPreloader;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallerListener;", "()V", "onJdkDownloadFinished", "", "request", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "project", "Lcom/intellij/openapi/project/Project;", "onJdkDownloadStarted", "toSuggestion", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/java/jdk/JdkIndexLookupRequest;", "Lcom/intellij/indexing/shared/java/jdk/SharedJdkIndexSuggestion;", "intellij.indexing.shared.java"})
public final class SharedJdkIndexPreloader
implements JdkInstallerListener {
    private final Pair<JdkIndexLookupRequest, SharedJdkIndexSuggestion> toSuggestion(JdkInstallRequest $this$toSuggestion) {
        JdkInstallRequest request = $this$toSuggestion;
        SharedIndexId sharedIndexId = SharedJdkIndexChunkLocatorKt.access$toSharedIndexId(request);
        if (sharedIndexId == null) {
            return null;
        }
        SharedIndexId id = sharedIndexId;
        JdkItem jdk = request.getItem();
        JdkIndexLookupRequest jdkRequest = new JdkIndexLookupRequest(jdk.getSuggestedSdkName(), null, CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)jdk.getSharedIndexAliases(), (Iterable)JdkAliases.INSTANCE.computeAliasesForJdkVersion(jdk.getVersionString()))), null, 10, null);
        return TuplesKt.to((Object)jdkRequest, (Object)new SharedJdkIndexSuggestion(jdkRequest, id, jdk){
            @NotNull
            private final String sdkName;
            @NotNull
            private final SharedIndexId sharedIndexId;
            final /* synthetic */ JdkIndexLookupRequest $jdkRequest;
            final /* synthetic */ SharedIndexId $id;
            final /* synthetic */ JdkItem $jdk;

            @NotNull
            public String getSdkName() {
                return this.sdkName;
            }

            @NotNull
            public SharedIndexId getSharedIndexId() {
                return this.sharedIndexId;
            }

            @NotNull
            public JdkIndexLookupRequest resolveRequest(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return this.$jdkRequest;
            }

            @NotNull
            public String toString() {
                return "JdkSharedIndexSuggestion(" + this.$id + ", " + this.$jdkRequest + ")";
            }
            {
                this.$jdkRequest = $captured_local_variable$0;
                this.$id = $captured_local_variable$1;
                this.$jdk = $captured_local_variable$2;
                this.sdkName = $captured_local_variable$2.getSuggestedSdkName();
                this.sharedIndexId = $captured_local_variable$1;
            }

            @NotNull
            public String getSharedIndexDownloadedPresentableText() {
                return SharedJdkIndexSuggestion.DefaultImpls.getSharedIndexDownloadedPresentableText(this);
            }

            @NotNull
            public String getSharedIndexConsentNotificationKindPresentableText() {
                return SharedJdkIndexSuggestion.DefaultImpls.getSharedIndexConsentNotificationKindPresentableText(this);
            }
        });
    }

    public void onJdkDownloadStarted(@NotNull JdkInstallRequest request, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!SharedJdkIndexChunkLocatorKt.access$isEnabled()) {
            return;
        }
        Pair<JdkIndexLookupRequest, SharedJdkIndexSuggestion> pair = this.toSuggestion(request);
        if (pair == null) {
            return;
        }
        Pair<JdkIndexLookupRequest, SharedJdkIndexSuggestion> pair2 = pair;
        SharedJdkIndexSuggestion suggestion = (SharedJdkIndexSuggestion)pair2.component2();
        boolean $i$f$service = false;
        Class<SharedIndexDownloadService> serviceClass$iv = SharedIndexDownloadService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        ((SharedIndexDownloadService)object).applySuggestions(project, CollectionsKt.listOf((Object)suggestion));
    }

    public void onJdkDownloadFinished(@NotNull JdkInstallRequest request, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!SharedJdkIndexChunkLocatorKt.access$isEnabled()) {
            return;
        }
        AppExecutorUtil.getAppExecutorService().submit(new Runnable(this, request){
            final /* synthetic */ SharedJdkIndexPreloader this$0;
            final /* synthetic */ JdkInstallRequest $request;

            public final void run() {
                Pair pair = SharedJdkIndexPreloader.access$toSuggestion(this.this$0, this.$request);
                if (pair == null) {
                    return;
                }
                Pair pair2 = pair;
                JdkIndexLookupRequest jdkLookupRequest = (JdkIndexLookupRequest)pair2.component1();
                Path home = this.$request.getJavaHome();
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(home);
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026le(home) ?: return@submit");
                VirtualFile virtualHome = virtualFile;
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualHome});
                boolean $i$f$service = false;
                Class<SharedJdkChunkStore> serviceClass$iv = SharedJdkChunkStore.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                ((SharedJdkChunkStore)((Object)object)).registerDownloadingJdkRequest(this.$request.getItem().getSuggestedSdkName(), virtualHome, jdkLookupRequest);
            }
            {
                this.this$0 = sharedJdkIndexPreloader;
                this.$request = jdkInstallRequest;
            }
        });
    }

    public static final /* synthetic */ Pair access$toSuggestion(SharedJdkIndexPreloader $this, JdkInstallRequest $this$access_u24toSuggestion) {
        return $this.toSuggestion($this$access_u24toSuggestion);
    }
}

