/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.local.SharedIndexLocalFinder;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.ChunkDescriptor;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.ChunkStorageOption;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.indexing.shared.platform.impl.SharedIndexesFusCollector;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystemProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnDiskSharedIndexChunkLocator
implements StartupActivity.RequiredForSmartMode {
    private static final Logger LOG = Logger.getInstance(OnDiskSharedIndexChunkLocator.class);
    private static final String LOCAL_SHARED_INDEX_DIR = "shared-index";
    private static final ExtensionPointName<SharedIndexLocalFinder> LOCAL_FINDER_EP_NAME = ExtensionPointName.create((String)"com.intellij.sharedIndexLocalFinder");
    public static final String ROOT_PROP = "on.disk.shared.index.root";

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(0);
        }
        new MyDumbModeTask(project).queue(project);
    }

    private static void scanAndAttachLocalSharedIndexes(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(2);
        }
        Path root = OnDiskSharedIndexChunkLocator.getSharedIndexRoot();
        LOG.debug("Scanning " + root + " for manually prepared shared indexes...");
        Set<Path> predefinedPaths = OnDiskSharedIndexChunkLocator.listPredefinedIndexFiles(root);
        Set<Path> customPaths = OnDiskSharedIndexChunkLocator.listCustomIndexFiles(project);
        for (Path ijxPath : ContainerUtil.union(predefinedPaths, customPaths)) {
            ChunkDescriptor chunk = OnDiskSharedIndexChunkLocator.tryLoadCompatibleSharedIndex(ijxPath, SharedIndexInfrastructureVersion.getIdeVersion());
            if (chunk == null) continue;
            try {
                SharedIndexChunkConfiguration.getInstance().downloadChunk(chunk, project, indicator);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    ExceptionUtil.rethrow((Throwable)t);
                }
                LOG.error("Failed to preload shared index: " + chunk + ". " + t.getMessage(), t);
            }
        }
    }

    @NotNull
    private static Set<Path> listCustomIndexFiles(@NotNull Project project) {
        if (project == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(3);
        }
        Set<Path> set = LOCAL_FINDER_EP_NAME.extensions().flatMap(finder -> finder.findSharedIndexChunks(project).stream()).collect(Collectors.toSet());
        if (set == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(4);
        }
        return set;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static Set<Path> listPredefinedIndexFiles(@NotNull Path root) {
        if (root == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(5);
        }
        if (Files.isRegularFile(root, new LinkOption[0])) {
            Set<Path> set = Collections.singleton(root);
            if (set == null) {
                OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(6);
            }
            return set;
        }
        if (Files.isDirectory(root, new LinkOption[0])) {
            Set<Path> set;
            Stream<Path> pathStream;
            block14: {
                pathStream = Files.list(root);
                set = pathStream.filter(f -> f.getFileName().toString().endsWith(".ijx")).collect(Collectors.toSet());
                if (pathStream == null) break block14;
                pathStream.close();
            }
            Set<Path> set2 = set;
            if (set2 == null) {
                OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(7);
            }
            return set2;
            {
                catch (Throwable throwable) {
                    try {
                        if (pathStream != null) {
                            try {
                                pathStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to scan share index file home from " + root + ". " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        Set<Path> set = Collections.emptySet();
        if (set == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private static Path getSharedIndexRoot() {
        String indexRoot = System.getProperty(ROOT_PROP, FileUtil.join((String[])new String[]{PathManager.getSystemPath(), LOCAL_SHARED_INDEX_DIR}));
        Path path = Paths.get(indexRoot, new String[0]);
        if (path == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(9);
        }
        return path;
    }

    @Nullable
    private static ChunkDescriptor tryLoadCompatibleSharedIndex(@NotNull Path filePath, @NotNull SharedIndexInfrastructureVersion ideVersion) {
        SharedIndexMetadata version;
        if (filePath == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(10);
        }
        if (ideVersion == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(11);
        }
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            return null;
        }
        LOG.info("Checking local shared index " + filePath);
        try {
            version = Objects.requireNonNull(OnDiskSharedIndexChunkLocator.getVersion(filePath), "Shared index " + filePath + " contains incompatible metadata");
        }
        catch (Throwable e) {
            LOG.error("Can't fetch shared index version for " + filePath + ". " + e.getMessage(), e);
            return null;
        }
        String fileSize = "(no file size)";
        try {
            fileSize = StringUtil.formatFileSize((long)Files.size(filePath));
        }
        catch (Exception e) {
            LOG.warn("Can't get size of shared index file " + filePath + ". " + e.getMessage(), (Throwable)e);
        }
        if (!ideVersion.isSuitableMetadata(version)) {
            LOG.warn("Local shared index " + filePath + " is incompatible with current IDE version:\n IDE Version: " + ideVersion + "\nIndex Version: " + version);
            return null;
        }
        LOG.info("Detected local shared index " + filePath + ", size " + fileSize + ", IDE Version " + ideVersion + ", Index Version " + version);
        return new MyChunkDescriptor(filePath, version);
    }

    @Nullable
    private static SharedIndexMetadata getVersion(@NotNull Path indexZip) throws IOException {
        if (indexZip == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(12);
        }
        try (UncompressedZipFileSystem fs = UncompressedZipFileSystemProvider.INSTANCE.newFileSystem(indexZip);){
            SharedIndexMetadata sharedIndexMetadata = SharedIndexMetadata.readSharedIndexMetadata(fs.getRootDirectory());
            return sharedIndexMetadata;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/OnDiskSharedIndexChunkLocator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideVersion";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexZip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/OnDiskSharedIndexChunkLocator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "listCustomIndexFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "listPredefinedIndexFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedIndexRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scanAndAttachLocalSharedIndexes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "listCustomIndexFiles";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "listPredefinedIndexFiles";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadCompatibleSharedIndex";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDumbModeTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        private MyDumbModeTask(@NotNull Project project) {
            if (project == null) {
                MyDumbModeTask.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyDumbModeTask.$$$reportNull$$$0(1);
            }
            OnDiskSharedIndexChunkLocator.scanAndAttachLocalSharedIndexes(this.myProject, indicator);
        }

        @Nullable
        public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
            if (taskFromQueue == null) {
                MyDumbModeTask.$$$reportNull$$$0(2);
            }
            if (taskFromQueue instanceof MyDumbModeTask && ((MyDumbModeTask)taskFromQueue).myProject.equals(this.myProject)) {
                return this;
            }
            return null;
        }

        public String toString() {
            return "OnDiskSharedIndexChunkLocator";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskFromQueue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/platform/impl/OnDiskSharedIndexChunkLocator$MyDumbModeTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryMergeWith";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyChunkDescriptor
    implements ChunkDescriptor {
        private final Path myIndexZip;
        @NotNull
        private final SharedIndexMetadata myVersion;

        private MyChunkDescriptor(@NotNull Path indexZip, @NotNull SharedIndexMetadata version) {
            if (indexZip == null) {
                MyChunkDescriptor.$$$reportNull$$$0(0);
            }
            if (version == null) {
                MyChunkDescriptor.$$$reportNull$$$0(1);
            }
            this.myIndexZip = indexZip;
            this.myVersion = version;
        }

        @Override
        @NotNull
        public String getChunkUniqueId() {
            String string = "local-" + this.myIndexZip.getFileName().toString();
            if (string == null) {
                MyChunkDescriptor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getKind() {
            String string = this.myVersion.getIndexKind();
            if (string == null) {
                MyChunkDescriptor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean downloadChunk(@NotNull Path targetFile, @Nullable Project project, @NotNull ProgressIndicator indicator) {
            if (targetFile == null) {
                MyChunkDescriptor.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                MyChunkDescriptor.$$$reportNull$$$0(5);
            }
            indicator.setText(SharedIndexesBundle.message("configuring.shared.indexes", new Object[0]));
            indicator.setIndeterminate(true);
            LOG.warn("Shared Index " + this.myIndexZip + " is requested by the IDE");
            try {
                PathKt.copy((Path)this.myIndexZip, (Path)targetFile);
                long size = Files.size(targetFile);
                SharedIndexesFusCollector.INSTANCE.reportLocalIndexLoaded(project, "project", this.getChunkUniqueId(), size);
                return true;
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    ExceptionUtil.rethrow((Throwable)t);
                }
                LOG.warn("Failed to copy shared index from " + this.myIndexZip + " to " + targetFile);
                return false;
            }
        }

        public String toString() {
            return "Shared Index (" + this.myVersion + ") from " + this.myIndexZip;
        }

        @Override
        @NotNull
        public ChunkStorageOption getChunkStorageOption() {
            ChunkStorageOption chunkStorageOption = ChunkStorageOption.APPENDABLE;
            if (chunkStorageOption == null) {
                MyChunkDescriptor.$$$reportNull$$$0(6);
            }
            return chunkStorageOption;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexZip";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/indexing/shared/platform/impl/OnDiskSharedIndexChunkLocator$MyChunkDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/indexing/shared/platform/impl/OnDiskSharedIndexChunkLocator$MyChunkDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunkUniqueId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunkStorageOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadChunk";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

