/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.MutableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.impl.SharedIndexMainZipStorage;
import com.intellij.indexing.shared.platform.impl.SharedIndexMainZipStorageKt;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.indexing.shared.util.zipFs.Zip64Util;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexMainZipStorage;", "Lcom/intellij/indexing/shared/platform/api/MutableSharedIndexStorage;", "oldStoragePath", "Ljava/nio/file/Path;", "storagePath", "storageId", "", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;)V", "fileSystemModificationLock", "Ljava/util/concurrent/locks/ReentrantLock;", "myCompatibleChunksCache", "", "", "myStats", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStats;", "readSystem", "Lcom/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystem;", "getStorageId", "()Ljava/lang/String;", "appendChunk", "", "chunkSourcePath", "chunkId", "close", "getChunkRoot", "getSharedIndexStats", "isCompatibleChunk", "listChunks", "", "toString", "updateStats", "intellij.indexing.shared"})
public final class SharedIndexMainZipStorage
implements MutableSharedIndexStorage {
    private final UncompressedZipFileSystem readSystem;
    private final ReentrantLock fileSystemModificationLock;
    private final AtomicReference<SharedIndexStats> myStats;
    private final Map<String, Boolean> myCompatibleChunksCache;
    private final Path storagePath;
    @NotNull
    private final String storageId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized SharedIndexStats updateStats() {
        SharedIndexStats sharedIndexStats;
        try {
            int n;
            long size = UtilKt.getFileOrDirectorySize(this.storagePath);
            AutoCloseable autoCloseable = Files.list(this.readSystem.getRootDirectory());
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl = false;
                n = (int)stream.filter(updateStats.result.chunks.1.1.INSTANCE).count();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            int chunks2 = n;
            sharedIndexStats = new SharedIndexStats(size, chunks2);
        }
        catch (Throwable t) {
            SharedIndexMainZipStorageKt.access$getLOG$p().info("Failed to compute shared indexes stats. " + t.getMessage(), t);
            sharedIndexStats = new SharedIndexStats(0L, 0);
        }
        SharedIndexStats result2 = sharedIndexStats;
        this.myStats.set(result2);
        return result2;
    }

    @Override
    @NotNull
    public SharedIndexStats getSharedIndexStats() {
        SharedIndexStats sharedIndexStats = this.myStats.get();
        if (sharedIndexStats == null) {
            sharedIndexStats = this.updateStats();
        }
        return sharedIndexStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        Lock lock = this.fileSystemModificationLock;
        lock.lock();
        try {
            boolean bl = false;
            this.readSystem.close();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public synchronized boolean isCompatibleChunk(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Boolean bl = this.myCompatibleChunksCache.computeIfAbsent(chunkId, new Function(this, chunkId){
            final /* synthetic */ SharedIndexMainZipStorage this$0;
            final /* synthetic */ String $chunkId;

            @NotNull
            public final Boolean apply(@NotNull String it) {
                Boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    Path path = this.this$0.getChunkRoot(this.$chunkId);
                    if (path == null) {
                        return false;
                    }
                    Path chunkRoot = path;
                    SharedIndexMetadata sharedIndexMetadata = SharedIndexMetadata.Companion.readSharedIndexMetadata(chunkRoot);
                    if (sharedIndexMetadata == null) {
                        return false;
                    }
                    SharedIndexMetadata chunkVersion = sharedIndexMetadata;
                    bl = SharedIndexInfrastructureVersion.getIdeVersion().isSuitableMetadata(chunkVersion);
                }
                catch (Throwable t) {
                    SharedIndexMainZipStorageKt.access$getLOG$p().info("Failed to check compatibility of " + this.$chunkId + " in " + SharedIndexMainZipStorage.access$getStoragePath$p(this.this$0));
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = sharedIndexMainZipStorage;
                this.$chunkId = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"myCompatibleChunksCache.\u2026h\")\n      false\n    }\n  }");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<String> listChunks() {
        SortedSet sortedSet;
        AutoCloseable autoCloseable = Files.list(this.readSystem.getRootDirectory());
        Throwable throwable = null;
        try {
            Stream list = (Stream)autoCloseable;
            boolean bl = false;
            Stream stream = list.filter(listChunks.1.1.INSTANCE).map(listChunks.1.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(stream, (String)"list.filter { it.isDirec\u2026 it.fileName.toString() }");
            sortedSet = CollectionsKt.toSortedSet((Iterable)StreamsKt.toList(stream));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return sortedSet;
    }

    @Override
    @Nullable
    public synchronized Path getChunkRoot(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Path path = this.readSystem.getPath(chunkId, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"readSystem.getPath(chunkId)");
        Path chunkRoot = path;
        return Files.isDirectory(chunkRoot, new LinkOption[0]) ? chunkRoot : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void appendChunk(@NotNull Path chunkSourcePath, @NotNull String chunkId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chunkSourcePath, (String)"chunkSourcePath");
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Lock lock = this.fileSystemModificationLock;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.readSystem.isOpen()) {
                return;
            }
            if (!Files.exists(chunkSourcePath, new LinkOption[0])) {
                throw (Throwable)new NoSuchFileException(((Object)chunkSourcePath).toString());
            }
            if (this.containsChunk(chunkId)) {
                return;
            }
            Map sourceSnapshot = SharedIndexMainZipStorageKt.access$takeSourceChunkSnapshot(chunkSourcePath);
            try {
                long timestamp = System.currentTimeMillis();
                Object object = FileUtilRt.doIOOperation((FileUtilRt.RepeatableIOOperation)new FileUtilRt.RepeatableIOOperation(this, chunkSourcePath, chunkId){
                    final /* synthetic */ SharedIndexMainZipStorage this$0;
                    final /* synthetic */ Path $chunkSourcePath$inlined;
                    final /* synthetic */ String $chunkId$inlined;
                    {
                        this.this$0 = sharedIndexMainZipStorage;
                        this.$chunkSourcePath$inlined = path;
                        this.$chunkId$inlined = string;
                    }

                    @Nullable
                    public final JBZipFile execute(boolean lastAttempt) {
                        JBZipFile jBZipFile;
                        try {
                            jBZipFile = Zip64Util.openZip64File(SharedIndexMainZipStorage.access$getStoragePath$p(this.this$0), false);
                        }
                        catch (IOException e) {
                            if (lastAttempt) {
                                throw (Throwable)e;
                            }
                            return null;
                        }
                        return jBZipFile;
                    }
                });
                Intrinsics.checkNotNull((Object)object);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"FileUtilRt.doIOOperation\u2026 null\n        }\n      }!!");
                JBZipFile storageZipFile = (JBZipFile)object;
                Closeable closeable = (Closeable)storageZipFile;
                Throwable throwable = null;
                try {
                    Path path;
                    JBZipFile it = (JBZipFile)closeable;
                    boolean bl2 = false;
                    Closeable closeable2 = UncompressedZipFileSystem.create(chunkSourcePath);
                    Throwable throwable2 = null;
                    try {
                        UncompressedZipFileSystem sourceFs = (UncompressedZipFileSystem)closeable2;
                        boolean bl3 = false;
                        UncompressedZipFileSystem uncompressedZipFileSystem = sourceFs;
                        Intrinsics.checkNotNullExpressionValue((Object)uncompressedZipFileSystem, (String)"sourceFs");
                        path = Files.walkFileTree(uncompressedZipFileSystem.getRootDirectory(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(it, timestamp, this, chunkSourcePath, chunkId){
                            final /* synthetic */ JBZipFile $it$inlined;
                            final /* synthetic */ long $timestamp$inlined;
                            final /* synthetic */ SharedIndexMainZipStorage this$0;
                            final /* synthetic */ Path $chunkSourcePath$inlined;
                            final /* synthetic */ String $chunkId$inlined;
                            {
                                this.$it$inlined = jBZipFile;
                                this.$timestamp$inlined = l;
                                this.this$0 = sharedIndexMainZipStorage;
                                this.$chunkSourcePath$inlined = path;
                                this.$chunkId$inlined = string;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @NotNull
                            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                                if (!Files.isDirectory(file, new LinkOption[0])) {
                                    JBZipEntry createdEntry;
                                    JBZipEntry jBZipEntry = createdEntry = this.$it$inlined.getOrCreateEntry(this.$chunkId$inlined + "/" + file);
                                    Intrinsics.checkNotNullExpressionValue((Object)jBZipEntry, (String)"createdEntry");
                                    jBZipEntry.setMethod(0);
                                    createdEntry.setTime(this.$timestamp$inlined);
                                    Closeable closeable = Files.newInputStream(file, new OpenOption[0]);
                                    Throwable throwable = null;
                                    try {
                                        InputStream it = (InputStream)closeable;
                                        boolean bl = false;
                                        createdEntry.setDataFromStream(it);
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Path path2 = path;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (ProcessCanceledException e) {
                SharedIndexMainZipStorageKt.access$getLOG$p().error("ProcessCanceledException should not be thrown there", new Attachment[]{new Attachment("pce", (Throwable)e)});
            }
            catch (Throwable e) {
                SharedIndexMainZipStorageKt.access$getLOG$p().error("Failed to append chunk", e);
                throw e;
            }
            finally {
                try {
                    this.readSystem.sync();
                }
                catch (Exception e) {
                    SharedIndexMainZipStorageKt.access$getLOG$p().error("Failed to sync shared index storage", (Throwable)e);
                    throw (Throwable)e;
                }
                Path path = this.getChunkRoot(chunkId);
                if (path == null) {
                    throw (Throwable)new IOException("Can't find root for added chunk " + chunkId + "; available roots: " + this.listChunks());
                }
                Path chunkRoot = path;
                Map storedSnapshot = SharedIndexMainZipStorageKt.access$takeStoredChunkSnapshot(chunkRoot);
                SharedIndexMainZipStorageKt.access$ensureSnapshotsEqual(sourceSnapshot, storedSnapshot);
                SharedIndexStats stats = this.updateStats();
                SharedIndexMainZipStorageKt.access$getLOG$p().info("Shared Indexes Storage is updated with " + chunkId + ". Total: " + stats.toLogMessage());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public String toString() {
        return this.getStorageId();
    }

    @Override
    @NotNull
    public String getStorageId() {
        return this.storageId;
    }

    @VisibleForTesting
    public SharedIndexMainZipStorage(@NotNull Path oldStoragePath, @NotNull Path storagePath, @NotNull String storageId2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)oldStoragePath, (String)"oldStoragePath");
        Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
        Intrinsics.checkNotNullParameter((Object)storageId2, (String)"storageId");
        this.storagePath = storagePath;
        this.storageId = storageId2;
        this.fileSystemModificationLock = new ReentrantLock();
        this.myStats = new AtomicReference<Object>(null);
        this.myCompatibleChunksCache = new LinkedHashMap();
        if (Files.exists(oldStoragePath, new LinkOption[0])) {
            if (Files.exists(this.storagePath, new LinkOption[0])) {
                throw (Throwable)new IOException();
            }
            FileUtil.rename((File)oldStoragePath.toFile(), (String)((Object)this.storagePath.getFileName()).toString());
        }
        if (!Files.exists(this.storagePath, new LinkOption[0])) {
            Zip64Util.openZip64File(this.storagePath, false).close();
        }
        UncompressedZipFileSystem uncompressedZipFileSystem = UncompressedZipFileSystem.create(this.storagePath);
        Intrinsics.checkNotNullExpressionValue((Object)uncompressedZipFileSystem, (String)"UncompressedZipFileSystem.create(storagePath)");
        this.readSystem = uncompressedZipFileSystem;
        SharedIndexStats stats = this.updateStats();
        if (this.listChunks().isEmpty()) {
            SharedIndexMainZipStorageKt.access$getLOG$p().info("Shared Indexes Storage is opened and empty");
        } else {
            SharedIndexMainZipStorageKt.access$getLOG$p().info("Shared Indexes Storage is opened: " + stats.toLogMessage() + ", chunks: " + CollectionsKt.sorted((Iterable)this.listChunks()));
        }
    }

    @Override
    public boolean containsChunk(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return MutableSharedIndexStorage.DefaultImpls.containsChunk(this, chunkId);
    }

    public static final /* synthetic */ Path access$getStoragePath$p(SharedIndexMainZipStorage $this) {
        return $this.storagePath;
    }
}

