/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tracing.Tracer;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.impl.BuildOutputConsumerImpl;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.BuildOperations;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.ChainedTargetsBuildListener;
import org.jetbrains.jps.incremental.ChunkBuildOutputConsumerImpl;
import org.jetbrains.jps.incremental.CleanupTempDirectoryExtension;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileContextImpl;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.RebuildRequestedException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.fs.FilesDelta;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.BuildProgress;
import org.jetbrains.jps.incremental.messages.BuilderStatisticsMessage;
import org.jetbrains.jps.incremental.messages.BuildingTargetProgressMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.DoneSomethingNotification;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.messages.UnprocessedFSChangesNotification;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.BuildTargetSourcesState;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.incremental.storage.OutputToTargetRegistry;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingImpl;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.JavacMain;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.service.SharedThreadPool;
import org.jetbrains.jps.util.JpsPathUtil;

public final class IncProjectBuilder {
    private static final Logger LOG = Logger.getInstance(IncProjectBuilder.class);
    private static final String CLASSPATH_INDEX_FILE_NAME = "classpath.index";
    private static final String UNMODIFIED_MARK_FILE_NAME = ".unmodified";
    private static final int FLUSH_INVOCATIONS_TO_SKIP = 10;
    private static final boolean SYNC_DELETE = Boolean.parseBoolean(System.getProperty("jps.sync.delete", "false"));
    private static final GlobalContextKey<Set<BuildTarget<?>>> TARGET_WITH_CLEARED_OUTPUT = GlobalContextKey.create("_targets_with_cleared_output_");
    public static final int MAX_BUILDER_THREADS;
    private final ProjectDescriptor myProjectDescriptor;
    private final BuilderRegistry myBuilderRegistry;
    private final Map<String, String> myBuilderParams;
    private final CanceledStatus myCancelStatus;
    private final List<MessageHandler> myMessageHandlers = new ArrayList<MessageHandler>();
    private final MessageHandler myMessageDispatcher = new MessageHandler(){

        @Override
        public void processMessage(BuildMessage msg) {
            for (MessageHandler h : IncProjectBuilder.this.myMessageHandlers) {
                h.processMessage(msg);
            }
        }
    };
    private final boolean myIsTestMode;
    private final int myTotalModuleLevelBuilderCount;
    private final List<Future> myAsyncTasks = Collections.synchronizedList(new ArrayList());
    private final ConcurrentMap<Builder, AtomicLong> myElapsedTimeNanosByBuilder = new ConcurrentHashMap<Builder, AtomicLong>();
    private final ConcurrentMap<Builder, AtomicInteger> myNumberOfSourcesProcessedByBuilder = new ConcurrentHashMap<Builder, AtomicInteger>();

    public IncProjectBuilder(ProjectDescriptor pd, BuilderRegistry builderRegistry, Map<String, String> builderParams, CanceledStatus cs, boolean isTestMode) {
        this.myProjectDescriptor = pd;
        this.myBuilderRegistry = builderRegistry;
        this.myBuilderParams = builderParams;
        this.myCancelStatus = cs;
        this.myTotalModuleLevelBuilderCount = builderRegistry.getModuleLevelBuilderCount();
        this.myIsTestMode = isTestMode;
    }

    public void addMessageHandler(MessageHandler handler) {
        this.myMessageHandlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUpToDate(CompileScope scope) {
        CompileContextImpl context = null;
        try {
            context = this.createContext(scope);
            BuildFSState fsState = this.myProjectDescriptor.fsState;
            for (BuildTarget<?> target : this.myProjectDescriptor.getBuildTargetIndex().getAllTargets()) {
                if (!scope.isAffected(target)) continue;
                BuildOperations.ensureFSStateInitialized(context, target, true);
                FilesDelta delta = fsState.getEffectiveFilesDelta(context, target);
                delta.lockData();
                try {
                    for (Set<File> files : delta.getSourcesToRecompile().values()) {
                        for (File file : files) {
                            if (!scope.isAffected(target, file)) continue;
                            this.myMessageDispatcher.processMessage(DoneSomethingNotification.INSTANCE);
                            return;
                        }
                    }
                }
                finally {
                    delta.unlockData();
                }
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            this.myMessageDispatcher.processMessage(DoneSomethingNotification.INSTANCE);
        }
        finally {
            if (context != null) {
                IncProjectBuilder.flushContext(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(CompileScope scope, boolean forceCleanCaches) throws RebuildRequestedException {
        rebuildRequiredSpan = Tracer.start((String)"IncProjectBuilder.checkRebuildRequired");
        this.checkRebuildRequired(scope);
        rebuildRequiredSpan.complete();
        memWatcher = LowMemoryWatcher.register((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$build$0(), ()V)((IncProjectBuilder)this));
        cleaner = CleanupTempDirectoryExtension.getInstance();
        v0 = cleanupTask = cleaner != null && cleaner.getCleanupTask() != null ? cleaner.getCleanupTask() : IncProjectBuilder.startTempDirectoryCleanupTask(this.myProjectDescriptor);
        if (cleanupTask != null) {
            this.myAsyncTasks.add(cleanupTask);
        }
        context = null;
        sourcesState = null;
        try {
            context = this.createContext(scope);
            sourcesState = new BuildTargetSourcesState(context);
            if (forceCleanCaches || context.isProjectRebuild()) {
                sourcesState.clearSourcesState();
            }
            buildSpan = Tracer.start((String)"IncProjectBuilder.runBuild");
            this.runBuild(context, forceCleanCaches);
            buildSpan.complete();
            this.myProjectDescriptor.dataManager.saveVersion();
            this.myProjectDescriptor.dataManager.reportUnhandledRelativizerPaths();
            sourcesState.reportSourcesState();
            IncProjectBuilder.reportRebuiltModules(context);
            IncProjectBuilder.reportUnprocessedChanges(context);
        }
        catch (StopBuildException e) {
            block28: {
                IncProjectBuilder.reportRebuiltModules(context);
                IncProjectBuilder.reportUnprocessedChanges(context);
                sourcesState.reportSourcesState();
                msg = e.getMessage();
                if (StringUtil.isEmptyOrSpaces((String)msg)) break block28;
                this.myMessageDispatcher.processMessage(new ProgressMessage(msg));
            }
            finishingCompilationSpan = Tracer.start((String)"finishing compilation");
            memWatcher.stop();
            IncProjectBuilder.flushContext(context);
            status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
            var11_21 = this.myAsyncTasks;
            synchronized (var11_21) {
                for (Future task : this.myAsyncTasks) {
                    if (status.isCanceled()) break;
                    IncProjectBuilder.waitForTask(status, task);
                }
            }
            finishingCompilationSpan.complete();
            return;
            catch (BuildDataCorruptedException e) {
                IncProjectBuilder.LOG.info((Throwable)e);
                this.requestRebuild(e, e);
                finishingCompilationSpan = Tracer.start((String)"finishing compilation");
                memWatcher.stop();
                IncProjectBuilder.flushContext(context);
                status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                var11_22 = this.myAsyncTasks;
                synchronized (var11_22) {
                    for (Future task : this.myAsyncTasks) {
                        if (status.isCanceled()) break;
                        IncProjectBuilder.waitForTask(status, task);
                    }
                }
                finishingCompilationSpan.complete();
                return;
                catch (ProjectBuildException e) {
                    block29: {
                        try {
                            IncProjectBuilder.LOG.info((Throwable)e);
                            cause = e.getCause();
                            if (cause instanceof IOException || cause instanceof BuildDataCorruptedException || cause instanceof RuntimeException && cause.getCause() instanceof IOException) {
                                this.requestRebuild(e, cause);
                                break block29;
                            }
                            errMessage = e.getMessage();
                            if (StringUtil.isEmptyOrSpaces((String)errMessage)) {
                                msg = new CompilerMessage("", cause != null ? cause : e);
                            } else {
                                causeMessage = cause != null ? cause.getMessage() : "";
                                msg = new CompilerMessage("", BuildMessage.Kind.ERROR, StringUtil.isEmptyOrSpaces((String)causeMessage) != false || errMessage.trim().endsWith(causeMessage) != false ? errMessage : errMessage + ": " + causeMessage);
                            }
                            this.myMessageDispatcher.processMessage(msg);
                        }
                        catch (Throwable var18_32) {
                            finishingCompilationSpan = Tracer.start((String)"finishing compilation");
                            memWatcher.stop();
                            IncProjectBuilder.flushContext(context);
                            status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                            var21_35 = this.myAsyncTasks;
                            synchronized (var21_35) {
                                var22_36 = this.myAsyncTasks.iterator();
                                ** break block30
                            }
lbl-1000:
                            // 2 sources

                            {
                                while (var12_24.hasNext()) {
                                    task = var12_24.next();
                                    if (status.isCanceled()) break;
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                                // MONITOREXIT @DISABLED, blocks:[16, 17, 13, 14, 15] lbl111 : MonitorExitStatement: MONITOREXIT : var11_20
                                finishingCompilationSpan.complete();
                                return;
                            }
lbl-1000:
                            // 2 sources

                            {
                                while (var12_27.hasNext()) {
                                    task = var12_27.next();
                                    if (status.isCanceled()) break;
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                                // MONITOREXIT @DISABLED, blocks:[16, 17, 12, 14, 15] lbl119 : MonitorExitStatement: MONITOREXIT : var11_23
                                finishingCompilationSpan.complete();
                                return;
                            }
lbl-1000:
                            // 1 sources

                            {
                                while (var22_36.hasNext()) {
                                    task = var22_36.next();
                                    if (status.isCanceled()) break;
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                            }
                            finishingCompilationSpan.complete();
                            throw var18_32;
                        }
                    }
                    finishingCompilationSpan = Tracer.start((String)"finishing compilation");
                    memWatcher.stop();
                    IncProjectBuilder.flushContext(context);
                    status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                    var11_23 = this.myAsyncTasks;
                    synchronized (var11_23) {
                        var12_27 = this.myAsyncTasks.iterator();
                        ** GOTO lbl-1000
                    }
                }
            }
        }
        finishingCompilationSpan = Tracer.start((String)"finishing compilation");
        memWatcher.stop();
        IncProjectBuilder.flushContext(context);
        status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
        var11_20 = this.myAsyncTasks;
        synchronized (var11_20) {
            var12_24 = this.myAsyncTasks.iterator();
            ** GOTO lbl-1000
        }
    }

    private void checkRebuildRequired(CompileScope scope) throws RebuildRequestedException {
        if (this.myIsTestMode || this.isAutoBuild()) {
            return;
        }
        BuildTargetsState targetsState = this.myProjectDescriptor.getTargetsState();
        long timeThreshold = targetsState.getLastSuccessfulRebuildDuration() * 95L / 100L;
        if (timeThreshold <= 0L) {
            return;
        }
        for (BuildTargetType buildTargetType : JavaModuleBuildTargetType.ALL_TYPES) {
            if (scope.isBuildIncrementally(buildTargetType) && scope.isAllTargetsOfTypeAffected(buildTargetType)) continue;
            return;
        }
        long estimatedWorkTime = IncProjectBuilder.calculateEstimatedBuildTime(this.myProjectDescriptor, targetsState, scope);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rebuild heuristic: estimated build time / timeThreshold : " + estimatedWorkTime + " / " + timeThreshold);
        }
        if (estimatedWorkTime >= timeThreshold) {
            String message = JpsBuildBundle.message("build.message.too.many.modules.require.recompilation.forcing.full.project.rebuild", new Object[0]);
            LOG.info(message);
            LOG.info("Estimated build duration (linear): " + StringUtil.formatDuration((long)estimatedWorkTime));
            LOG.info("Last successful rebuild duration (linear): " + StringUtil.formatDuration((long)targetsState.getLastSuccessfulRebuildDuration()));
            LOG.info("Rebuild heuristic time threshold: " + StringUtil.formatDuration((long)timeThreshold));
            this.myMessageDispatcher.processMessage(new CompilerMessage("", BuildMessage.Kind.INFO, message));
            throw new RebuildRequestedException(null);
        }
    }

    public static long calculateEstimatedBuildTime(ProjectDescriptor projectDescriptor, BuildTargetsState targetsState, final CompileScope scope) {
        long estimatedBuildTime = 0L;
        Predicate isAffected = new Predicate<BuildTarget<?>>(){
            private final Set<BuildTargetType<?>> allTargetsAffected = new HashSet<JavaModuleBuildTargetType>(JavaModuleBuildTargetType.ALL_TYPES);

            @Override
            public boolean test(BuildTarget<?> target) {
                return this.allTargetsAffected.contains(target.getTargetType()) || scope.isAffected(target);
            }
        };
        BuildTargetIndex targetIndex = projectDescriptor.getBuildTargetIndex();
        ArrayList affectedTarget = new ArrayList();
        for (BuildTarget<?> target : targetIndex.getAllTargets()) {
            long avgTimeToBuild;
            if (targetIndex.isDummy(target) || (avgTimeToBuild = targetsState.getAverageBuildTime(target.getTargetType())) <= 0L || !targetsState.getTargetConfiguration(target).isTargetDirty(projectDescriptor) || !isAffected.test(target)) continue;
            estimatedBuildTime += avgTimeToBuild;
            affectedTarget.add(target);
        }
        LOG.info("Affected build targets count: " + affectedTarget.size());
        return estimatedBuildTime;
    }

    private void requestRebuild(Exception e, Throwable cause) throws RebuildRequestedException {
        this.myMessageDispatcher.processMessage(new CompilerMessage("", BuildMessage.Kind.INFO, JpsBuildBundle.message("build.message.internal.caches.are.corrupted", e.getMessage())));
        throw new RebuildRequestedException(cause);
    }

    private static void waitForTask(@NotNull CanceledStatus status, Future task) {
        if (status == null) {
            IncProjectBuilder.$$$reportNull$$$0(0);
        }
        try {
            while (true) {
                try {
                    task.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignored) {
                    if (!status.isCanceled()) continue;
                }
                break;
            }
        }
        catch (Throwable th) {
            LOG.info(th);
        }
    }

    private static void reportRebuiltModules(CompileContextImpl context) {
        Set modules = (Set)BuildTargetConfiguration.MODULES_WITH_TARGET_CONFIG_CHANGED_KEY.get((UserDataHolder)context);
        if (modules == null || modules.isEmpty()) {
            return;
        }
        int shown = modules.size() == 6 ? 6 : Math.min(5, modules.size());
        String modulesText = modules.stream().limit(shown).map(m -> "'" + m.getName() + "'").collect(Collectors.joining(", "));
        String text = JpsBuildBundle.message("build.messages.modules.were.fully.rebuilt", modulesText, modules.size(), modules.size() - shown, ModuleBuildTarget.REBUILD_ON_DEPENDENCY_CHANGE != false ? 1 : 0);
        context.processMessage(new CompilerMessage("", BuildMessage.Kind.INFO, text));
    }

    private static void reportUnprocessedChanges(CompileContextImpl context) {
        ProjectDescriptor pd = context.getProjectDescriptor();
        BuildFSState fsState = pd.fsState;
        for (BuildTarget<?> target : pd.getBuildTargetIndex().getAllTargets()) {
            if (!fsState.hasUnprocessedChanges(context, target)) continue;
            context.processMessage(new UnprocessedFSChangesNotification());
            break;
        }
    }

    private static void flushContext(CompileContext context) {
        ExternalJavacManager server;
        if (context != null) {
            ProjectDescriptor pd = context.getProjectDescriptor();
            pd.getProjectStamps().getStampStorage().force();
            pd.dataManager.flush(false);
        }
        if ((server = (ExternalJavacManager)((Object)ExternalJavacManager.KEY.get(context))) != null) {
            server.stop();
            ExternalJavacManager.KEY.set(context, null);
        }
    }

    private boolean isAutoBuild() {
        return Boolean.parseBoolean(this.myBuilderParams.get("is_automake"));
    }

    private boolean isParallelBuild() {
        return this.isAutoBuild() ? BuildRunner.isParallelBuildAutomakeEnabled() : BuildRunner.isParallelBuildEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(CompileContextImpl context, boolean forceCleanCaches) throws ProjectBuildException {
        block11: {
            BuildProgress buildProgress;
            context.setDone(0.0f);
            LOG.info("Building project; isRebuild:" + context.isProjectRebuild() + "; isMake:" + context.isMake() + " parallel compilation:" + this.isParallelBuild());
            context.addBuildListener(new ChainedTargetsBuildListener(context));
            context.addBuildListener(new BuildListener(){

                @Override
                public void filesGenerated(@NotNull FileGeneratedEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    Collection<Pair<String, String>> paths = event.getPaths();
                    FileSystem fs = FileSystems.getDefault();
                    if (paths.size() == 1) {
                        this.deleteFiles((String)paths.iterator().next().first, fs);
                        return;
                    }
                    HashSet<String> outputs = new HashSet<String>();
                    for (Pair<String, String> pair : paths) {
                        String root = (String)pair.getFirst();
                        if (!outputs.add(root)) continue;
                        this.deleteFiles(root, fs);
                    }
                }

                private void deleteFiles(String rootPath, FileSystem fs) {
                    Path root = fs.getPath(rootPath, new String[0]);
                    try {
                        Files.deleteIfExists(root.resolve(IncProjectBuilder.CLASSPATH_INDEX_FILE_NAME));
                        Files.deleteIfExists(root.resolve(IncProjectBuilder.UNMODIFIED_MARK_FILE_NAME));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/jps/incremental/IncProjectBuilder$3", "filesGenerated"));
                }
            });
            Tracer.Span allTargetBuilderBuildStartedSpan = Tracer.start((String)"All TargetBuilder.buildStarted");
            for (TargetBuilder<?, ?> targetBuilder : this.myBuilderRegistry.getTargetBuilders()) {
                targetBuilder.buildStarted(context);
            }
            allTargetBuilderBuildStartedSpan.complete();
            Tracer.Span allModuleLevelBuildersBuildStartedSpan = Tracer.start((String)"All ModuleLevelBuilder.buildStarted");
            for (ModuleLevelBuilder builder : this.myBuilderRegistry.getModuleLevelBuilders()) {
                builder.buildStarted(context);
            }
            allModuleLevelBuildersBuildStartedSpan.complete();
            BuildProgress buildProgress2 = null;
            try {
                buildProgress = new BuildProgress(this.myProjectDescriptor.dataManager, this.myProjectDescriptor.getBuildTargetIndex(), this.myProjectDescriptor.getBuildTargetIndex().getSortedTargetChunks(context), chunk -> IncProjectBuilder.isAffected(context.getScope(), chunk));
                Tracer.Span cleanOutputSourcesSpan = Tracer.start((String)"Clean output sources");
                this.cleanOutputRoots(context, context.isProjectRebuild() || forceCleanCaches);
                cleanOutputSourcesSpan.complete();
                Tracer.Span span = Tracer.start((String)"'before' tasks");
                context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.running.before.tasks", new Object[0])));
                IncProjectBuilder.runTasks(context, this.myBuilderRegistry.getBeforeTasks());
                TimingLog.LOG.debug("'before' tasks finished");
                span.complete();
                Tracer.Span checkingSourcesSpan = Tracer.start((String)"Building targets");
                context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.checking.sources", new Object[0])));
                this.buildChunks(context, buildProgress);
                TimingLog.LOG.debug("Building targets finished");
                checkingSourcesSpan.complete();
                Tracer.Span afterTasksSpan = Tracer.start((String)"'after' span");
                context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.running.after.tasks", new Object[0])));
                IncProjectBuilder.runTasks(context, this.myBuilderRegistry.getAfterTasks());
                TimingLog.LOG.debug("'after' tasks finished");
                this.sendElapsedTimeMessages(context);
                afterTasksSpan.complete();
                if (buildProgress == null) break block11;
                buildProgress.updateExpectedAverageTime();
            }
            catch (Throwable throwable) {
                if (buildProgress2 != null) {
                    buildProgress2.updateExpectedAverageTime();
                    if (context.isProjectRebuild() && !Utils.errorsDetected(context) && !context.getCancelStatus().isCanceled()) {
                        this.myProjectDescriptor.getTargetsState().setLastSuccessfulRebuildDuration(buildProgress2.getAbsoluteBuildTime());
                    }
                }
                for (Builder builder : this.myBuilderRegistry.getTargetBuilders()) {
                    builder.buildFinished(context);
                }
                for (Builder builder : this.myBuilderRegistry.getModuleLevelBuilders()) {
                    builder.buildFinished(context);
                }
                context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.finished.saving.caches", new Object[0])));
                throw throwable;
            }
            if (context.isProjectRebuild() && !Utils.errorsDetected(context) && !context.getCancelStatus().isCanceled()) {
                this.myProjectDescriptor.getTargetsState().setLastSuccessfulRebuildDuration(buildProgress.getAbsoluteBuildTime());
            }
        }
        for (TargetBuilder<?, ?> targetBuilder : this.myBuilderRegistry.getTargetBuilders()) {
            targetBuilder.buildFinished(context);
        }
        for (ModuleLevelBuilder moduleLevelBuilder : this.myBuilderRegistry.getModuleLevelBuilders()) {
            moduleLevelBuilder.buildFinished(context);
        }
        context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.finished.saving.caches", new Object[0])));
    }

    private void sendElapsedTimeMessages(CompileContext context) {
        this.myElapsedTimeNanosByBuilder.entrySet().stream().map(entry -> {
            AtomicInteger processedSourcesRef = (AtomicInteger)this.myNumberOfSourcesProcessedByBuilder.get(entry.getKey());
            int processedSources = processedSourcesRef != null ? processedSourcesRef.get() : 0;
            return new BuilderStatisticsMessage(((Builder)entry.getKey()).getPresentableName(), processedSources, ((AtomicLong)entry.getValue()).get() / 1000000L);
        }).sorted(Comparator.comparing(BuilderStatisticsMessage::getBuilderName)).forEach(context::processMessage);
    }

    @Nullable
    static Future<Void> startTempDirectoryCleanupTask(ProjectDescriptor pd) {
        String tempPath = System.getProperty("java.io.tmpdir", null);
        if (StringUtil.isEmptyOrSpaces((String)tempPath)) {
            return null;
        }
        File tempDir = new File(tempPath);
        File dataRoot = pd.dataManager.getDataPaths().getDataStorageRoot();
        if (!FileUtil.isAncestor((File)dataRoot, (File)tempDir, (boolean)true)) {
            return null;
        }
        File[] files = tempDir.listFiles();
        if (files == null) {
            tempDir.mkdirs();
        } else if (files.length > 0) {
            FutureTask<Object> task = new FutureTask<Object>(() -> {
                for (File tempFile : files) {
                    FileUtil.delete((File)tempFile);
                }
            }, null);
            Thread thread = new Thread(task, "Temp directory cleanup");
            thread.setPriority(1);
            thread.setDaemon(true);
            thread.start();
            return task;
        }
        return null;
    }

    private CompileContextImpl createContext(CompileScope scope) {
        return new CompileContextImpl(scope, this.myProjectDescriptor, this.myMessageDispatcher, this.myBuilderParams, this.myCancelStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanOutputRoots(CompileContext context, boolean cleanCaches) throws ProjectBuildException {
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        ProjectBuildException ex = null;
        try {
            JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getCompilerConfiguration(projectDescriptor.getProject());
            boolean shouldClear = configuration.isClearOutputDirectoryOnRebuild();
            if (shouldClear) {
                this.clearOutputs(context);
            } else {
                for (BuildTarget buildTarget : projectDescriptor.getBuildTargetIndex().getAllTargets()) {
                    context.checkCanceled();
                    if (!context.getScope().isBuildForced(buildTarget)) continue;
                    IncProjectBuilder.clearOutputFilesUninterruptibly(context, buildTarget);
                }
            }
            for (BuildTargetType buildTargetType : TargetTypeRegistry.getInstance().getTargetTypes()) {
                if (!context.getScope().isAllTargetsOfTypeAffected(buildTargetType)) continue;
                this.cleanOutputOfStaleTargets(buildTargetType, context);
            }
            return;
        }
        catch (ProjectBuildException e) {
            ex = e;
        }
        finally {
            if (cleanCaches) {
                try {
                    projectDescriptor.getProjectStamps().getStampStorage().clean();
                }
                catch (IOException e) {
                    if (ex == null) {
                        ex = new ProjectBuildException(JpsBuildBundle.message("build.message.error.cleaning.timestamps.storage", new Object[0]), e);
                    }
                    LOG.info("Error cleaning timestamps storage", (Throwable)e);
                }
                finally {
                    try {
                        projectDescriptor.dataManager.clean();
                    }
                    catch (IOException e) {
                        if (ex == null) {
                            ex = new ProjectBuildException(JpsBuildBundle.message("build.message.error.cleaning.compiler.storages", new Object[0]), e);
                        }
                        LOG.info("Error cleaning compiler storages", (Throwable)e);
                    }
                    finally {
                        projectDescriptor.fsState.clearAll();
                        if (ex == null) return;
                        throw ex;
                    }
                }
            }
            BuildTargetsState targetsState = projectDescriptor.getTargetsState();
            for (BuildTarget<?> target : IncProjectBuilder.getTargetsWithClearedOutput(context)) {
                targetsState.getTargetConfiguration(target).invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOutputOfStaleTargets(BuildTargetType<?> type, CompileContext context) {
        List<Pair<String, Integer>> targetIds = this.myProjectDescriptor.dataManager.getTargetsState().getStaleTargetIds(type);
        if (targetIds.isEmpty()) {
            return;
        }
        context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.cleaning.old.output.directories", new Object[0])));
        for (Pair<String, Integer> ids : targetIds) {
            String stringId = (String)ids.first;
            try {
                try (SourceToOutputMappingImpl mapping = null;){
                    mapping = this.myProjectDescriptor.dataManager.createSourceToOutputMapForStaleTarget(type, stringId);
                    IncProjectBuilder.clearOutputFiles(context, mapping, type, (Integer)ids.second);
                }
                FileUtil.delete((File)this.myProjectDescriptor.dataManager.getDataPaths().getTargetDataRoot(type, stringId));
                this.myProjectDescriptor.dataManager.getTargetsState().cleanStaleTarget(type, stringId);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                this.myMessageDispatcher.processMessage(new CompilerMessage("", BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.failed.to.delete.output.files.from.obsolete.0.target.1", stringId, e.toString())));
            }
        }
    }

    public static void clearOutputFiles(CompileContext context, BuildTarget<?> target) throws IOException {
        SourceToOutputMapping map = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
        BuildTargetType<BuildTarget<?>> targetType = target.getTargetType();
        IncProjectBuilder.clearOutputFiles(context, map, targetType, context.getProjectDescriptor().dataManager.getTargetsState().getBuildTargetId(target));
        IncProjectBuilder.registerTargetsWithClearedOutput(context, Collections.singletonList(target));
    }

    private static void clearOutputFiles(CompileContext context, SourceToOutputMapping mapping, BuildTargetType<?> targetType, int targetId) throws IOException {
        Set dirsToDelete = targetType instanceof ModuleBasedBuildTargetType ? FileCollectionFactory.createCanonicalFileSet() : null;
        OutputToTargetRegistry outputToTargetRegistry = context.getProjectDescriptor().dataManager.getOutputToTargetRegistry();
        for (String srcPath : mapping.getSources()) {
            Collection<String> outs = mapping.getOutputs(srcPath);
            if (outs == null || outs.isEmpty()) continue;
            ArrayList<String> deletedPaths = new ArrayList<String>();
            for (String out : outs) {
                BuildOperations.deleteRecursively(out, deletedPaths, dirsToDelete);
            }
            outputToTargetRegistry.removeMapping(outs, targetId);
            if (deletedPaths.isEmpty()) continue;
            context.processMessage(new FileDeletedEvent(deletedPaths));
        }
        if (dirsToDelete != null) {
            FSOperations.pruneEmptyDirs(context, dirsToDelete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerTargetsWithClearedOutput(CompileContext context, Collection<? extends BuildTarget<?>> targets) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGET_WITH_CLEARED_OUTPUT;
        synchronized (globalContextKey) {
            HashSet data = (HashSet)context.getUserData(TARGET_WITH_CLEARED_OUTPUT);
            if (data == null) {
                data = new HashSet();
                context.putUserData(TARGET_WITH_CLEARED_OUTPUT, data);
            }
            data.addAll(targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTargetOutputCleared(CompileContext context, BuildTarget<?> target) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGET_WITH_CLEARED_OUTPUT;
        synchronized (globalContextKey) {
            Set data = (Set)context.getUserData(TARGET_WITH_CLEARED_OUTPUT);
            return data != null && data.contains(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<BuildTarget<?>> getTargetsWithClearedOutput(CompileContext context) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGET_WITH_CLEARED_OUTPUT;
        synchronized (globalContextKey) {
            Set data = (Set)context.getUserData(TARGET_WITH_CLEARED_OUTPUT);
            return data != null ? Collections.unmodifiableSet(new HashSet(data)) : Collections.emptySet();
        }
    }

    private void clearOutputs(CompileContext context) throws ProjectBuildException {
        long cleanStart = System.nanoTime();
        MultiMap rootsToDelete = MultiMap.createSet();
        Set allSourceRoots = FileCollectionFactory.createCanonicalFileSet();
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        List<BuildTarget<?>> allTargets = projectDescriptor.getBuildTargetIndex().getAllTargets();
        for (BuildTarget<?> target : allTargets) {
            if (target instanceof ModuleBasedTarget) {
                for (File file : target.getOutputRoots(context)) {
                    rootsToDelete.putValue((Object)file, (Object)target);
                }
                continue;
            }
            if (!context.getScope().isBuildForced(target)) continue;
            IncProjectBuilder.clearOutputFilesUninterruptibly(context, target);
        }
        ModuleExcludeIndex moduleIndex = projectDescriptor.getModuleExcludeIndex();
        for (BuildTarget buildTarget : allTargets) {
            for (BuildRootDescriptor descriptor : projectDescriptor.getBuildRootIndex().getTargetRoots(buildTarget, context)) {
                File file;
                if (descriptor.isGenerated() || !moduleIndex.isInContent(file = descriptor.getRootFile())) continue;
                allSourceRoots.add(file);
            }
        }
        CompileScope compileScope = context.getScope();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Predicate<BuildTarget> predicate = input -> compileScope.isBuildForced((BuildTarget<?>)input);
        for (Map.Entry entry : rootsToDelete.entrySet()) {
            boolean okToDelete;
            context.checkCanceled();
            File outputRoot = (File)entry.getKey();
            Collection rootTargets = (Collection)entry.getValue();
            Applicability applicability = Applicability.calculate(predicate, rootTargets);
            if (applicability == Applicability.NONE) continue;
            boolean bl = okToDelete = applicability == Applicability.ALL && !IncProjectBuilder.isEmpty(outputRoot);
            if (okToDelete && !moduleIndex.isExcluded(outputRoot)) {
                if (JpsPathUtil.isUnder((Set)allSourceRoots, (File)outputRoot)) {
                    okToDelete = false;
                } else {
                    Set _outRoot = FileCollectionFactory.createCanonicalFileSet(Collections.singletonList(outputRoot));
                    for (File srcRoot : allSourceRoots) {
                        if (!JpsPathUtil.isUnder((Set)_outRoot, (File)srcRoot)) continue;
                        okToDelete = false;
                        break;
                    }
                }
                if (!okToDelete) {
                    context.processMessage(new CompilerMessage("", BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.output.path.0.intersects.with.a.source.root", outputRoot.getPath())));
                }
            }
            if (okToDelete) {
                File[] children = outputRoot.listFiles();
                if (children != null) {
                    for (File child : children) {
                        if (child.delete()) continue;
                        arrayList.add(child);
                    }
                } else if (!outputRoot.delete()) {
                    arrayList.add(outputRoot);
                }
                IncProjectBuilder.registerTargetsWithClearedOutput(context, rootTargets);
                continue;
            }
            context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.cleaning.output.directories", new Object[0])));
            for (BuildTarget target : rootTargets) {
                if (!compileScope.isBuildForced(target)) continue;
                IncProjectBuilder.clearOutputFilesUninterruptibly(context, target);
            }
        }
        if (!arrayList.isEmpty()) {
            context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.cleaning.output.directories", new Object[0])));
            if (SYNC_DELETE) {
                for (File file : arrayList) {
                    context.checkCanceled();
                    FileUtil.delete((File)file);
                }
            } else {
                this.myAsyncTasks.add(FileUtil.asyncDelete(arrayList));
            }
        }
        LOG.info("Cleaned output directories in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - cleanStart) + " ms");
    }

    private static boolean isEmpty(File outputRoot) {
        String[] files = outputRoot.list();
        return files == null || files.length == 0;
    }

    private static void clearOutputFilesUninterruptibly(CompileContext context, BuildTarget<?> target) {
        try {
            IncProjectBuilder.clearOutputFiles(context, target);
        }
        catch (Throwable e) {
            LOG.info(e);
            String reason = e.getMessage();
            if (reason == null) {
                reason = e.getClass().getName();
            }
            context.processMessage(new CompilerMessage("", BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.problems.clearing.output.files.for.target.0.1", target.getPresentableName(), reason)));
        }
    }

    private static void runTasks(CompileContext context, List<? extends BuildTask> tasks) throws ProjectBuildException {
        for (BuildTask buildTask : tasks) {
            buildTask.build(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildChunks(CompileContextImpl context, BuildProgress buildProgress) throws ProjectBuildException {
        try {
            boolean compileInParallel = this.isParallelBuild();
            if (compileInParallel && MAX_BUILDER_THREADS <= 1) {
                LOG.info("Switched off parallel compilation because maximum number of builder threads is less than 2. Set 'compile.parallel.max.threads' system property to a value greater than 1 to really enable parallel compilation.");
                compileInParallel = false;
            }
            Tracer.Span buildSpan = Tracer.start((String)(compileInParallel ? "Parallel build" : "Non-parallel build"));
            if (compileInParallel) {
                new BuildParallelizer(context, buildProgress).buildInParallel();
            } else {
                ProjectDescriptor pd = context.getProjectDescriptor();
                Runnable flushCommand = Utils.asCountedRunnable(10, () -> pd.dataManager.flush(true));
                for (BuildTargetChunk chunk : pd.getBuildTargetIndex().getSortedTargetChunks(context)) {
                    try {
                        this.buildChunkIfAffected(context, context.getScope(), chunk, buildProgress);
                    }
                    finally {
                        pd.dataManager.closeSourceToOutputStorages(Collections.singleton(chunk));
                        flushCommand.run();
                    }
                }
            }
            buildSpan.complete();
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
    }

    private void buildChunkIfAffected(CompileContext context, CompileScope scope, BuildTargetChunk chunk, BuildProgress buildProgress) throws ProjectBuildException {
        Tracer.Span isAffectedSpan = Tracer.start((String)"isAffected");
        boolean affected = IncProjectBuilder.isAffected(scope, chunk);
        isAffectedSpan.complete();
        if (affected) {
            this.buildTargetsChunk(context, chunk, buildProgress);
        }
    }

    private static boolean isAffected(CompileScope scope, BuildTargetChunk chunk) {
        for (BuildTarget<?> target : chunk.getTargets()) {
            if (!scope.isAffected(target)) continue;
            return true;
        }
        return false;
    }

    private boolean runBuildersForChunk(CompileContext context, BuildTargetChunk chunk, BuildProgress buildProgress) throws ProjectBuildException, IOException {
        Set<BuildTarget<?>> targets = chunk.getTargets();
        if (targets.size() > 1) {
            LinkedHashSet<ModuleBuildTarget> moduleTargets = new LinkedHashSet<ModuleBuildTarget>();
            for (BuildTarget<?> target : targets) {
                if (target instanceof ModuleBuildTarget) {
                    moduleTargets.add((ModuleBuildTarget)target);
                    continue;
                }
                String targetsString = StringUtil.join(targets, target1 -> StringUtil.decapitalize((String)target1.getPresentableName()), (String)", ");
                String message = JpsBuildBundle.message("build.message.cannot.build.0.because.it.is.included.into.a.circular.dependency.1", StringUtil.decapitalize((String)target.getPresentableName()), targetsString);
                context.processMessage(new CompilerMessage("", BuildMessage.Kind.ERROR, message));
                return false;
            }
            return this.runModuleLevelBuilders(IncProjectBuilder.wrapWithModuleInfoAppender(context, moduleTargets), new ModuleChunk(moduleTargets), buildProgress);
        }
        BuildTarget<?> target = targets.iterator().next();
        if (target instanceof ModuleBuildTarget) {
            Set<ModuleBuildTarget> mbt = Collections.singleton((ModuleBuildTarget)target);
            return this.runModuleLevelBuilders(IncProjectBuilder.wrapWithModuleInfoAppender(context, mbt), new ModuleChunk(mbt), buildProgress);
        }
        IncProjectBuilder.completeRecompiledSourcesSet(context, targets);
        IncProjectBuilder.cleanOldOutputs(context, target);
        List<TargetBuilder<?, ?>> builders = BuilderRegistry.getInstance().getTargetBuilders();
        int builderCount = 0;
        for (TargetBuilder<?, ?> builder : builders) {
            this.buildTarget(target, context, builder);
            buildProgress.updateProgress(target, (double)(++builderCount) / (double)builders.size(), context);
        }
        return true;
    }

    private static CompileContext wrapWithModuleInfoAppender(final CompileContext context, final Collection<ModuleBuildTarget> moduleTargets) {
        final Class<MessageHandler> messageHandlerInterface = MessageHandler.class;
        return (CompileContext)Proxy.newProxyInstance(context.getClass().getClassLoader(), new Class[]{CompileContext.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (args != null && args.length > 0 && messageHandlerInterface.equals(method.getDeclaringClass())) {
                    for (Object arg : args) {
                        if (!(arg instanceof CompilerMessage)) continue;
                        CompilerMessage compilerMessage = (CompilerMessage)arg;
                        for (ModuleBuildTarget target : moduleTargets) {
                            compilerMessage.addModuleName(target.getModule().getName());
                        }
                        break;
                    }
                }
                MethodHandle mh = MethodHandles.lookup().unreflect(method);
                return args == null ? mh.invoke(context) : mh.bindTo(context).asSpreader(Object[].class, args.length).invoke(args);
            }
        });
    }

    private static <T extends BuildTarget<R>, R extends BuildRootDescriptor> void completeRecompiledSourcesSet(CompileContext context, Collection<T> targets) throws IOException {
        CompileScope scope = context.getScope();
        for (BuildTarget target : targets) {
            if (!scope.isBuildForced(target)) continue;
            return;
        }
        final ProjectDescriptor pd = context.getProjectDescriptor();
        final Set affectedOutputs = CollectionFactory.createFilePathSet();
        final Set affectedSources = CollectionFactory.createFilePathSet();
        final ArrayList mappings = new ArrayList();
        for (BuildTarget target : targets) {
            pd.fsState.processFilesToRecompile(context, target, new FileProcessor<R, T>(){
                private SourceToOutputMapping srcToOut;

                @Override
                public boolean apply(T target, File file, R root) throws IOException {
                    String src = FileUtil.toSystemIndependentName((String)file.getPath());
                    if (affectedSources.add(src)) {
                        Collection<String> outs;
                        if (this.srcToOut == null) {
                            this.srcToOut = pd.dataManager.getSourceToOutputMap((BuildTarget<?>)target);
                            mappings.add(this.srcToOut);
                        }
                        if ((outs = this.srcToOut.getOutputs(src)) != null) {
                            List filteredOuts = ContainerUtil.filter(outs, out -> !"kotlin_module".equals(StringUtil.substringAfterLast((String)out, (String)".")));
                            affectedOutputs.addAll(filteredOuts);
                        }
                    }
                    return true;
                }
            });
        }
        if (!affectedOutputs.isEmpty()) {
            for (SourceToOutputMapping srcToOut : mappings) {
                block3: for (String src : srcToOut.getSources()) {
                    if (affectedSources.contains(src)) continue;
                    Iterator<String> it = srcToOut.getOutputsIterator(src);
                    while (it.hasNext()) {
                        if (!affectedOutputs.contains(it.next())) continue;
                        FSOperations.markDirtyIfNotDeleted(context, CompilationRound.CURRENT, new File(src));
                        continue block3;
                    }
                }
            }
        }
    }

    private <R extends BuildRootDescriptor, T extends BuildTarget<R>> void buildTarget(final T target, final CompileContext context, TargetBuilder<?, ?> builder) throws ProjectBuildException, IOException {
        if (builder.getTargetTypes().contains(target.getTargetType())) {
            DirtyFilesHolderBase holder = new DirtyFilesHolderBase<R, T>(context){

                @Override
                public void processDirtyFiles(@NotNull FileProcessor<R, T> processor) throws IOException {
                    if (processor == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    context.getProjectDescriptor().fsState.processFilesToRecompile(context, target, processor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/IncProjectBuilder$6", "processDirtyFiles"));
                }
            };
            BuildOutputConsumerImpl outputConsumer = new BuildOutputConsumerImpl(target, context);
            long start = System.nanoTime();
            builder.build(target, holder, outputConsumer, context);
            this.storeBuilderStatistics(builder, System.nanoTime() - start, outputConsumer.getNumberOfProcessedSources());
            outputConsumer.fireFileGeneratedEvent();
            context.checkCanceled();
        }
    }

    private static <T extends BuildRootDescriptor> void cleanOldOutputs(final CompileContext context, final BuildTarget<T> target) throws ProjectBuildException {
        if (!context.getScope().isBuildForced(target)) {
            BuildOperations.cleanOutputsCorrespondingToChangedFiles(context, new DirtyFilesHolderBase<T, BuildTarget<T>>(context){

                @Override
                public void processDirtyFiles(@NotNull FileProcessor<T, BuildTarget<T>> processor) throws IOException {
                    if (processor == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    context.getProjectDescriptor().fsState.processFilesToRecompile(context, target, processor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/IncProjectBuilder$7", "processDirtyFiles"));
                }
            });
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildTargetsChunk(CompileContext context, BuildTargetChunk chunk, BuildProgress buildProgress) throws ProjectBuildException {
        Tracer.DelayedSpan buildSpan = Tracer.start(() -> "Building " + chunk.getPresentableName());
        BuildFSState fsState = this.myProjectDescriptor.fsState;
        try {
            context.setCompilationStartStamp(chunk.getTargets(), System.currentTimeMillis());
            this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.STARTED);
            Utils.ERRORS_DETECTED_KEY.set((UserDataHolder)context, (Object)Boolean.FALSE);
            for (BuildTarget<?> buildTarget : chunk.getTargets()) {
                BuildOperations.ensureFSStateInitialized(context, buildTarget, false);
            }
            boolean doneSomething = this.processDeletedPaths(context, chunk.getTargets());
            fsState.beforeChunkBuildStart(context, chunk);
            Tracer.DelayedSpan runBuildersSpan = Tracer.start(() -> "runBuilders " + chunk.getPresentableName());
            runBuildersSpan.complete();
            fsState.clearContextRoundData(context);
            fsState.clearContextChunk(context);
            if (doneSomething |= this.runBuildersForChunk(context, chunk, buildProgress)) {
                BuildOperations.markTargetsUpToDate(context, chunk);
            }
        }
        catch (BuildDataCorruptedException | ProjectBuildException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    @NlsSafe StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(chunk.getPresentableName()).append(": ").append(e2.getClass().getName());
                    String string = e2.getMessage();
                    if (string == null) throw new ProjectBuildException(stringBuilder.toString(), e2);
                    stringBuilder.append(": ").append(string);
                    throw new ProjectBuildException(stringBuilder.toString(), e2);
                }
            }
            catch (Throwable throwable) {
                buildProgress.onTargetChunkFinished(chunk, context);
                for (BuildRootDescriptor buildRootDescriptor : context.getProjectDescriptor().getBuildRootIndex().clearTempRoots(context)) {
                    context.getProjectDescriptor().fsState.clearRecompile(buildRootDescriptor);
                }
                try {
                    Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
                    if (map == null) throw throwable;
                    for (Map.Entry entry : map.entrySet()) {
                        BuildTarget target = (BuildTarget)entry.getKey();
                        Collection paths = (Collection)entry.getValue();
                        if (paths == null) continue;
                        for (String path : paths) {
                            fsState.registerDeleted(context, target, new File(path), null);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new ProjectBuildException(e3);
                }
                finally {
                    Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, null);
                    this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.FINISHED);
                    buildSpan.complete();
                }
            }
        }
        buildProgress.onTargetChunkFinished(chunk, context);
        for (BuildRootDescriptor buildRootDescriptor : context.getProjectDescriptor().getBuildRootIndex().clearTempRoots(context)) {
            context.getProjectDescriptor().fsState.clearRecompile(buildRootDescriptor);
        }
        try {
            Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
            if (map == null) return;
            for (Map.Entry entry : map.entrySet()) {
                BuildTarget target = (BuildTarget)entry.getKey();
                Collection paths = (Collection)entry.getValue();
                if (paths == null) continue;
                for (String path : paths) {
                    fsState.registerDeleted(context, target, new File(path), null);
                }
            }
            return;
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
        finally {
            Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, null);
            this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.FINISHED);
            buildSpan.complete();
        }
    }

    private void sendBuildingTargetMessages(@NotNull Set<? extends BuildTarget<?>> targets, @NotNull BuildingTargetProgressMessage.Event event) {
        if (targets == null) {
            IncProjectBuilder.$$$reportNull$$$0(1);
        }
        if (event == null) {
            IncProjectBuilder.$$$reportNull$$$0(2);
        }
        this.myMessageDispatcher.processMessage(new BuildingTargetProgressMessage(targets, event));
    }

    private boolean processDeletedPaths(CompileContext context, Set<? extends BuildTarget<?>> targets) throws ProjectBuildException {
        boolean doneSomething = false;
        try {
            HashMap<BuildTarget, Collection> targetToRemovedSources = new HashMap<BuildTarget, Collection>();
            Set dirsToDelete = FileCollectionFactory.createCanonicalFileSet();
            for (BuildTarget<?> target : targets) {
                Collection<String> pathsForIteration;
                Collection<String> deletedPaths = this.myProjectDescriptor.fsState.getAndClearDeletedPaths(target);
                if (deletedPaths.isEmpty()) continue;
                targetToRemovedSources.put(target, deletedPaths);
                if (IncProjectBuilder.isTargetOutputCleared(context, target)) continue;
                int buildTargetId = context.getProjectDescriptor().getTargetsState().getBuildTargetId(target);
                boolean shouldPruneEmptyDirs = target instanceof ModuleBasedTarget;
                SourceToOutputMapping sourceToOutputStorage = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
                ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
                if (this.myIsTestMode) {
                    pathsForIteration = new ArrayList<String>(deletedPaths);
                    Collections.sort((List)pathsForIteration);
                } else {
                    pathsForIteration = deletedPaths;
                }
                for (String deletedSource : pathsForIteration) {
                    OneToManyPathsMapping sourceToFormMap;
                    Collection<String> boundForms;
                    Collection<String> outputs = sourceToOutputStorage.getOutputs(deletedSource);
                    if (outputs != null && !outputs.isEmpty()) {
                        ArrayList<String> deletedOutputPaths = new ArrayList<String>();
                        OutputToTargetRegistry outputToSourceRegistry = context.getProjectDescriptor().dataManager.getOutputToTargetRegistry();
                        for (String output : outputToSourceRegistry.getSafeToDeleteOutputs(outputs, buildTargetId)) {
                            boolean deleted = BuildOperations.deleteRecursively(output, deletedOutputPaths, shouldPruneEmptyDirs ? dirsToDelete : null);
                            if (!deleted) continue;
                            doneSomething = true;
                        }
                        for (String outputPath : outputs) {
                            outputToSourceRegistry.removeMapping(outputPath, buildTargetId);
                        }
                        if (!deletedOutputPaths.isEmpty()) {
                            if (logger.isEnabled()) {
                                logger.logDeletedFiles(deletedOutputPaths);
                            }
                            context.processMessage(new FileDeletedEvent(deletedOutputPaths));
                        }
                    }
                    if (!(target instanceof ModuleBuildTarget) || (boundForms = (sourceToFormMap = context.getProjectDescriptor().dataManager.getSourceToFormMap()).getState(deletedSource)) == null) continue;
                    for (String formPath : boundForms) {
                        File formFile = new File(formPath);
                        if (!formFile.exists()) continue;
                        FSOperations.markDirty(context, CompilationRound.CURRENT, formFile);
                    }
                    sourceToFormMap.remove(deletedSource);
                }
            }
            if (!targetToRemovedSources.isEmpty()) {
                Map existing = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
                if (existing != null) {
                    for (Map.Entry entry : existing.entrySet()) {
                        Collection paths = (Collection)targetToRemovedSources.get(entry.getKey());
                        if (paths != null) {
                            paths.addAll((Collection)entry.getValue());
                            continue;
                        }
                        targetToRemovedSources.put((BuildTarget)entry.getKey(), (Collection)entry.getValue());
                    }
                }
                Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, targetToRemovedSources);
            }
            FSOperations.pruneEmptyDirs(context, dirsToDelete);
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
        return doneSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runModuleLevelBuilders(final CompileContext context, final ModuleChunk chunk, BuildProgress buildProgress) throws ProjectBuildException, IOException {
        for (BuilderCategory category : BuilderCategory.values()) {
            for (ModuleLevelBuilder builder : this.myBuilderRegistry.getBuilders(category)) {
                builder.chunkBuildStarted(context, chunk);
            }
        }
        IncProjectBuilder.completeRecompiledSourcesSet(context, chunk.getTargets());
        boolean doneSomething = false;
        boolean rebuildFromScratchRequested = false;
        ChunkBuildOutputConsumerImpl outputConsumer = new ChunkBuildOutputConsumerImpl(context);
        try {
            boolean nextPassRequired;
            block13: do {
                nextPassRequired = false;
                this.myProjectDescriptor.fsState.beforeNextRoundStart(context, chunk);
                DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder = new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context){

                    @Override
                    public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) throws IOException {
                        if (processor == null) {
                            8.$$$reportNull$$$0(0);
                        }
                        FSOperations.processFilesToRecompile(context, chunk, processor);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/IncProjectBuilder$8", "processDirtyFiles"));
                    }
                };
                if (!JavaBuilderUtil.isForcedRecompilationAllJavaModules(context)) {
                    Map<ModuleBuildTarget, Set<File>> cleanedSources = BuildOperations.cleanOutputsCorrespondingToChangedFiles(context, dirtyFilesHolder);
                    for (Map.Entry entry : cleanedSources.entrySet()) {
                        ModuleBuildTarget target = (ModuleBuildTarget)entry.getKey();
                        Set files = (Set)entry.getValue();
                        if (files.isEmpty()) continue;
                        SourceToOutputMapping mapping = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
                        for (File srcFile : files) {
                            mapping.setOutputs(srcFile.getPath(), Collections.emptyList());
                        }
                    }
                }
                try {
                    int buildersPassed = 0;
                    for (BuilderCategory category : BuilderCategory.values()) {
                        List<ModuleLevelBuilder> builders = this.myBuilderRegistry.getBuilders(category);
                        if (category == BuilderCategory.CLASS_POST_PROCESSOR) {
                            IncProjectBuilder.saveInstrumentedClasses(outputConsumer);
                        }
                        if (builders.isEmpty()) continue;
                        for (ModuleLevelBuilder builder : builders) {
                            outputConsumer.setCurrentBuilderName(builder.getPresentableName());
                            this.processDeletedPaths(context, chunk.getTargets());
                            long start = System.nanoTime();
                            int processedSourcesBefore = outputConsumer.getNumberOfProcessedSources();
                            ModuleLevelBuilder.ExitCode buildResult = builder.build(context, chunk, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder, outputConsumer);
                            this.storeBuilderStatistics(builder, System.nanoTime() - start, outputConsumer.getNumberOfProcessedSources() - processedSourcesBefore);
                            doneSomething |= buildResult != ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                            if (buildResult == ModuleLevelBuilder.ExitCode.ABORT) {
                                throw new StopBuildException(JpsBuildBundle.message("build.message.builder.0.requested.build.stop", builder.getPresentableName()));
                            }
                            context.checkCanceled();
                            if (buildResult == ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED) {
                                nextPassRequired = true;
                            } else if (buildResult == ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED) {
                                if (!rebuildFromScratchRequested && !JavaBuilderUtil.isForcedRecompilationAllJavaModules(context)) {
                                    IncProjectBuilder.notifyChunkRebuildRequested(context, chunk, builder);
                                    rebuildFromScratchRequested = true;
                                    try {
                                        context.getProjectDescriptor().fsState.clearContextRoundData(context);
                                        FSOperations.markDirty(context, CompilationRound.NEXT, chunk, null);
                                        nextPassRequired = true;
                                        outputConsumer.clear();
                                        continue block13;
                                    }
                                    catch (Exception e) {
                                        throw new ProjectBuildException(e);
                                    }
                                }
                                LOG.debug("Builder " + builder.getPresentableName() + " requested second chunk rebuild");
                            }
                            ++buildersPassed;
                        }
                        continue;
                        {
                            for (ModuleBuildTarget target : chunk.getTargets()) {
                                buildProgress.updateProgress(target, (double)buildersPassed / (double)this.myTotalModuleLevelBuilderCount, context);
                            }
                            continue;
                            break;
                        }
                        finally {
                            outputConsumer.setCurrentBuilderName(null);
                            boolean moreToCompile = JavaBuilderUtil.updateMappingsOnRoundCompletion(context, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder, chunk);
                            if (moreToCompile) {
                                nextPassRequired = true;
                            }
                        }
                    }
                }
                finally {
                    JavaBuilderUtil.clearDataOnRoundCompletion(context);
                }
            } while (nextPassRequired);
        }
        catch (Throwable throwable) {
            IncProjectBuilder.saveInstrumentedClasses(outputConsumer);
            outputConsumer.fireFileGeneratedEvents();
            outputConsumer.clear();
            for (BuilderCategory category : BuilderCategory.values()) {
                for (ModuleLevelBuilder builder : this.myBuilderRegistry.getBuilders(category)) {
                    builder.chunkBuildFinished(context, chunk);
                }
            }
            if (Utils.errorsDetected(context)) {
                context.processMessage(new CompilerMessage("", BuildMessage.Kind.JPS_INFO, JpsBuildBundle.message("build.message.errors.occurred.while.compiling.module.0", chunk.getPresentableShortName())));
            }
            throw throwable;
        }
        IncProjectBuilder.saveInstrumentedClasses(outputConsumer);
        outputConsumer.fireFileGeneratedEvents();
        outputConsumer.clear();
        for (BuilderCategory builderCategory : BuilderCategory.values()) {
            for (ModuleLevelBuilder builder : this.myBuilderRegistry.getBuilders(builderCategory)) {
                builder.chunkBuildFinished(context, chunk);
            }
        }
        if (Utils.errorsDetected(context)) {
            context.processMessage(new CompilerMessage("", BuildMessage.Kind.JPS_INFO, JpsBuildBundle.message("build.message.errors.occurred.while.compiling.module.0", chunk.getPresentableShortName())));
        }
        return doneSomething;
    }

    private static void notifyChunkRebuildRequested(CompileContext context, ModuleChunk chunk, ModuleLevelBuilder builder) {
        String infoMessage = JpsBuildBundle.message("builder.0.requested.rebuild.of.module.chunk.1", builder.getPresentableName(), chunk.getName());
        LOG.info(infoMessage);
        BuildMessage.Kind kind = BuildMessage.Kind.JPS_INFO;
        CompileScope scope = context.getScope();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            if (scope.isWholeTargetAffected(target)) continue;
            infoMessage = infoMessage + ".\n";
            infoMessage = infoMessage + JpsBuildBundle.message("build.message.consider.building.whole.project.or.rebuilding.the.module", new Object[0]);
            kind = BuildMessage.Kind.INFO;
            break;
        }
        context.processMessage(new CompilerMessage("", kind, infoMessage));
    }

    private void storeBuilderStatistics(Builder builder, long elapsedTime, int processedFiles) {
        this.myElapsedTimeNanosByBuilder.computeIfAbsent(builder, b -> new AtomicLong()).addAndGet(elapsedTime);
        this.myNumberOfSourcesProcessedByBuilder.computeIfAbsent(builder, b -> new AtomicInteger()).addAndGet(processedFiles);
    }

    private static void saveInstrumentedClasses(ChunkBuildOutputConsumerImpl outputConsumer) throws IOException {
        for (CompiledClass compiledClass : outputConsumer.getCompiledClasses().values()) {
            if (!compiledClass.isDirty()) continue;
            compiledClass.save();
        }
    }

    private static CompileContext createContextWrapper(final CompileContext delegate) {
        final UserDataHolderBase localDataHolder = new UserDataHolderBase();
        final Set deletedKeysSet = ContainerUtil.newConcurrentSet();
        final Class<UserDataHolder> dataHolderInterface = UserDataHolder.class;
        final Class<MessageHandler> messageHandlerInterface = MessageHandler.class;
        return (CompileContext)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{CompileContext.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (args != null) {
                    BuildMessage msg;
                    Class<?> declaringClass = method.getDeclaringClass();
                    if (dataHolderInterface.equals(declaringClass)) {
                        Object firstArgument = args[0];
                        if (!(firstArgument instanceof GlobalContextKey)) {
                            boolean isWriteOperation;
                            boolean bl = isWriteOperation = args.length == 2;
                            if (isWriteOperation) {
                                if (args[1] == null) {
                                    deletedKeysSet.add(firstArgument);
                                } else {
                                    deletedKeysSet.remove(firstArgument);
                                }
                            } else if (deletedKeysSet.contains(firstArgument)) {
                                return null;
                            }
                            Object result = method.invoke((Object)localDataHolder, args);
                            if (isWriteOperation || result != null) {
                                return result;
                            }
                        }
                    } else if (messageHandlerInterface.equals(declaringClass) && (msg = (BuildMessage)args[0]).getKind() == BuildMessage.Kind.ERROR) {
                        Utils.ERRORS_DETECTED_KEY.set((UserDataHolder)localDataHolder, (Object)Boolean.TRUE);
                    }
                    return MethodHandles.lookup().unreflect(method).bindTo(delegate).asSpreader(Object[].class, args.length).invoke(args);
                }
                return MethodHandles.lookup().unreflect(method).invoke(delegate);
            }
        });
    }

    private /* synthetic */ void lambda$build$0() {
        JavacMain.clearCompilerZipFileCache();
        this.myProjectDescriptor.dataManager.flush(false);
        this.myProjectDescriptor.getProjectStamps().getStampStorage().force();
    }

    static {
        int maxThreads = Math.min(10, 75 * Runtime.getRuntime().availableProcessors() / 100);
        try {
            maxThreads = Math.max(1, Integer.parseInt(System.getProperty("compile.parallel.max.threads", Integer.toString(maxThreads))));
        }
        catch (NumberFormatException ignored) {
            maxThreads = Math.max(1, maxThreads);
        }
        MAX_BUILDER_THREADS = maxThreads;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/IncProjectBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForTask";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sendBuildingTargetMessages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class BuildParallelizer {
        private final ExecutorService myParallelBuildExecutor = AppExecutorUtil.createCustomPriorityQueueBoundedApplicationPoolExecutor((String)"IncProjectBuilder Executor Pool", (Executor)SharedThreadPool.getInstance(), (int)MAX_BUILDER_THREADS, (o1, o2) -> {
            int p1 = o1 instanceof RunnableWithPriority ? ((RunnableWithPriority)o1).priority : 1;
            int p2 = o1 instanceof RunnableWithPriority ? ((RunnableWithPriority)o2).priority : 1;
            return Integer.compare(p2, p1);
        });
        private final CompileContext myContext;
        private final BuildProgress myBuildProgress;
        private final AtomicReference<Throwable> myException = new AtomicReference();
        private final CountDownLatch myTasksCountDown;
        private final List<BuildChunkTask> myTasks;
        private final Runnable myFlushCommand;

        private BuildParallelizer(CompileContext context, BuildProgress buildProgress) {
            Tracer.Span span = Tracer.start((String)"BuildParallelizer constructor");
            this.myContext = context;
            this.myBuildProgress = buildProgress;
            ProjectDescriptor pd = this.myContext.getProjectDescriptor();
            BuildTargetIndex targetIndex = pd.getBuildTargetIndex();
            this.myFlushCommand = Utils.asCountedRunnable(10, () -> pd.dataManager.flush(true));
            List<BuildTargetChunk> chunks = targetIndex.getSortedTargetChunks(this.myContext);
            this.myTasks = new ArrayList<BuildChunkTask>(chunks.size());
            HashMap targetToTask = new HashMap(chunks.size());
            for (BuildTargetChunk chunk : chunks) {
                BuildChunkTask task = new BuildChunkTask(chunk);
                this.myTasks.add(task);
                for (BuildTarget<?> target : chunk.getTargets()) {
                    targetToTask.put(target, task);
                }
                task.mySelfScore = chunk.getTargets().size();
            }
            Tracer.Span collectTaskDependantsSpan = Tracer.start((String)"IncProjectBuilder.collectTaskDependants");
            int taskCounter = 0;
            for (BuildChunkTask task : this.myTasks) {
                task.myIndex = taskCounter;
                ++taskCounter;
                for (BuildTarget<Object> buildTarget : task.getChunk().getTargets()) {
                    for (BuildTarget<?> dependency : targetIndex.getDependencies(buildTarget, this.myContext)) {
                        BuildChunkTask depTask = (BuildChunkTask)targetToTask.get(dependency);
                        if (depTask == null || depTask == task) continue;
                        task.addDependency(depTask);
                    }
                }
            }
            collectTaskDependantsSpan.complete();
            Tracer.Span prioritisationSpan = Tracer.start((String)"IncProjectBuilder.prioritisation");
            HashMap<BuildChunkTask, BitSet> chunkToTransitive = new HashMap<BuildChunkTask, BitSet>();
            for (BuildChunkTask buildChunkTask : Lists.reverse(this.myTasks)) {
                List dependantTasks = buildChunkTask.myTasksDependsOnThis;
                HashSet directDependants = new HashSet(dependantTasks);
                BitSet transitiveDependants = new BitSet();
                for (BuildChunkTask directDependant : directDependants) {
                    BitSet dependantChunkTransitiveDependants = (BitSet)chunkToTransitive.get(directDependant);
                    transitiveDependants.or(dependantChunkTransitiveDependants);
                    transitiveDependants.set(directDependant.myIndex);
                }
                chunkToTransitive.put(buildChunkTask, transitiveDependants);
                buildChunkTask.myDepsScore = transitiveDependants.cardinality();
            }
            prioritisationSpan.complete();
            this.myTasksCountDown = new CountDownLatch(this.myTasks.size());
            span.complete();
        }

        public void buildInParallel() throws IOException, ProjectBuildException {
            ArrayList<BuildChunkTask> initialTasks = new ArrayList<BuildChunkTask>();
            for (BuildChunkTask task : this.myTasks) {
                if (!task.isReady()) continue;
                initialTasks.add(task);
            }
            this.queueTasks(initialTasks);
            try {
                this.myTasksCountDown.await();
            }
            catch (InterruptedException e) {
                LOG.info((Throwable)e);
            }
            Throwable throwable = this.myException.get();
            if (throwable instanceof ProjectBuildException) {
                throw (ProjectBuildException)throwable;
            }
            if (throwable != null) {
                throw new ProjectBuildException(throwable);
            }
        }

        private void queueTasks(List<? extends BuildChunkTask> tasks) {
            if (tasks.isEmpty()) {
                return;
            }
            ArrayList<? extends BuildChunkTask> sorted = new ArrayList<BuildChunkTask>(tasks);
            sorted.sort(Comparator.comparingLong(rec$ -> ((BuildChunkTask)rec$).getScore()).reversed());
            if (LOG.isDebugEnabled()) {
                ArrayList<BuildTargetChunk> chunksToLog = new ArrayList<BuildTargetChunk>();
                for (BuildChunkTask buildChunkTask : sorted) {
                    chunksToLog.add(buildChunkTask.getChunk());
                }
                StringBuilder stringBuilder = new StringBuilder("Queuing " + chunksToLog.size() + " chunks in parallel: ");
                chunksToLog.sort(Comparator.comparing(BuildTargetChunk::toString));
                for (BuildTargetChunk chunk : chunksToLog) {
                    stringBuilder.append(chunk.toString()).append("; ");
                }
                LOG.debug(stringBuilder.toString());
            }
            for (BuildChunkTask buildChunkTask : sorted) {
                this.queueTask(buildChunkTask);
            }
        }

        private void queueTask(final BuildChunkTask task) {
            final CompileContext chunkLocalContext = IncProjectBuilder.createContextWrapper(this.myContext);
            this.myParallelBuildExecutor.execute(new RunnableWithPriority(task.getScore()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            if (BuildParallelizer.this.myException.get() == null) {
                                IncProjectBuilder.this.buildChunkIfAffected(chunkLocalContext, BuildParallelizer.this.myContext.getScope(), task.getChunk(), BuildParallelizer.this.myBuildProgress);
                            }
                        }
                        finally {
                            Tracer.Span flush = Tracer.start((String)"flushing");
                            ((IncProjectBuilder)IncProjectBuilder.this).myProjectDescriptor.dataManager.closeSourceToOutputStorages(Collections.singletonList(task.getChunk()));
                            BuildParallelizer.this.myFlushCommand.run();
                            flush.complete();
                        }
                    }
                    catch (Throwable e) {
                        BuildParallelizer.this.myException.compareAndSet(null, e);
                        LOG.info(e);
                    }
                    finally {
                        LOG.debug("Finished compilation of " + task.getChunk().toString());
                        BuildParallelizer.this.myTasksCountDown.countDown();
                        List<BuildChunkTask> nextTasks = task.markAsFinishedAndGetNextReadyTasks();
                        if (!nextTasks.isEmpty()) {
                            BuildParallelizer.this.queueTasks(nextTasks);
                        }
                    }
                }
            });
        }

        private abstract class RunnableWithPriority
        implements Runnable {
            public final int priority;

            RunnableWithPriority(int priority) {
                this.priority = priority;
            }
        }
    }

    private static final class BuildChunkTask {
        private final BuildTargetChunk myChunk;
        private final AtomicInteger myNotBuildDependenciesCount = new AtomicInteger(0);
        private final Set<BuildChunkTask> myNotBuiltDependencies = new HashSet<BuildChunkTask>();
        private final List<BuildChunkTask> myTasksDependsOnThis = new ArrayList<BuildChunkTask>();
        private int mySelfScore = 0;
        private int myDepsScore = 0;
        private int myIndex = 0;

        private BuildChunkTask(BuildTargetChunk chunk) {
            this.myChunk = chunk;
        }

        private int getScore() {
            return this.myDepsScore + this.mySelfScore;
        }

        public BuildTargetChunk getChunk() {
            return this.myChunk;
        }

        public boolean isReady() {
            return this.myNotBuildDependenciesCount.get() == 0;
        }

        public void addDependency(BuildChunkTask dependency) {
            if (this.myNotBuiltDependencies.add(dependency)) {
                this.myNotBuildDependenciesCount.incrementAndGet();
                dependency.myTasksDependsOnThis.add(this);
            }
        }

        public List<BuildChunkTask> markAsFinishedAndGetNextReadyTasks() {
            SmartList nextTasks = new SmartList();
            for (BuildChunkTask task : this.myTasksDependsOnThis) {
                int dependenciesCount = task.myNotBuildDependenciesCount.decrementAndGet();
                if (dependenciesCount != 0) continue;
                nextTasks.add(task);
            }
            return nextTasks;
        }
    }

    private static enum Applicability {
        NONE,
        PARTIAL,
        ALL;


        static <T> Applicability calculate(Predicate<? super T> p, Collection<? extends T> collection) {
            int count = 0;
            int item = 0;
            for (T elem : collection) {
                ++item;
                if (!(p.test(elem) ? item > ++count : count > 0)) continue;
                return PARTIAL;
            }
            return count == 0 ? NONE : ALL;
        }
    }
}

