/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.util.FileUtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\b2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\r\u0010\u0012\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0013J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007J\u0015\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u0018J*\u0010\u001b\u001a\u00020\u000f*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J2\u0010\u001c\u001a\u00020\u001d*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J*\u0010\u001f\u001a\u00020\u000f*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J*\u0010 \u001a\u00020\u000f*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u001aH\u0002R0\u0010\u0005\u001a$\u0012\u0004\u0012\u00020\u0007\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "implicitPackageCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/idea/caches/ImplicitPackageData;", "analyzeImplicitPackagePrefixes", "sourceRoot", "checkDeletedFileInSourceRoot", "", "file", "checkNewFileInSourceRoot", "clear", "clear$kotlin_core", "getPrefix", "update", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "update$kotlin_core", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "addFile", "addPsiFile", "", "psiFile", "removeFile", "updateFile", "kotlin.core"})
public final class ImplicitPackagePrefixCache {
    private final ConcurrentHashMap<VirtualFile, Map<FqName, List<VirtualFile>>> implicitPackageCache;
    private final Project project;

    @NotNull
    public final FqName getPrefix(@NotNull VirtualFile sourceRoot) {
        Map implicitPackageMap;
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)sourceRoot, (String)"sourceRoot");
        ConcurrentMap $this$getOrPut$iv = this.implicitPackageCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(sourceRoot);
        if (object == null) {
            Map<FqName, List<VirtualFile>> map2;
            boolean bl = false;
            Map<FqName, List<VirtualFile>> default$iv = map2 = this.analyzeImplicitPackagePrefixes(sourceRoot);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(sourceRoot, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        if ((fqName2 = (FqName)CollectionsKt.singleOrNull((Iterable)(implicitPackageMap = (Map)object).keySet())) == null) {
            FqName fqName3 = FqName.ROOT;
            fqName2 = fqName3;
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"FqName.ROOT");
        }
        return fqName2;
    }

    public final void clear$kotlin_core() {
        this.implicitPackageCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<FqName, List<VirtualFile>> analyzeImplicitPackagePrefixes(VirtualFile sourceRoot) {
        void $this$filterTo$iv$iv;
        Map result2 = new LinkedHashMap();
        VirtualFile[] virtualFileArray = sourceRoot.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"sourceRoot.children");
        VirtualFile[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void p1 = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!FileUtilsKt.isKotlinFileType((VirtualFile)p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ktFiles2 = (List)destination$iv$iv;
        Iterator iterator = ktFiles2.iterator();
        while (iterator.hasNext()) {
            VirtualFile ktFile;
            VirtualFile virtualFile2 = ktFile = (VirtualFile)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"ktFile");
            this.addFile(result2, virtualFile2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFile(Map<FqName, List<VirtualFile>> $this$addFile, VirtualFile ktFile) {
        Map<FqName, List<VirtualFile>> map2 = $this$addFile;
        synchronized (map2) {
            boolean bl = false;
            PsiFile psiFile2 = PsiManager.getInstance((Project)this.project).findFile(ktFile);
            if (!(psiFile2 instanceof KtFile)) {
                psiFile2 = null;
            }
            KtFile ktFile2 = (KtFile)psiFile2;
            if (ktFile2 == null) {
                return;
            }
            KtFile psiFile3 = ktFile2;
            boolean bl2 = this.addPsiFile($this$addFile, psiFile3, ktFile);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addPsiFile(Map<FqName, List<VirtualFile>> $this$addPsiFile, KtFile psiFile2, VirtualFile ktFile) {
        Object object;
        void $this$getOrPut$iv;
        Map<FqName, List<VirtualFile>> map2 = $this$addPsiFile;
        FqName key$iv = psiFile2.getPackageFqName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((List)object).add(ktFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void removeFile(Map<FqName, List<VirtualFile>> $this$removeFile, VirtualFile file2) {
        FqName fqName2 = $this$removeFile;
        synchronized (fqName2) {
            boolean bl = false;
            FqName fqName3 = $this$removeFile;
            Iterator<Map.Entry<FqName, List<VirtualFile>>> iterator = fqName3.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<FqName, List<VirtualFile>> entry;
                Map.Entry<FqName, List<VirtualFile>> entry2 = entry = iterator.next();
                fqName3 = entry2.getKey();
                entry2 = entry;
                List<VirtualFile> value2 = entry2.getValue();
                if (!value2.remove(file2)) continue;
                if (!value2.isEmpty()) break;
                $this$removeFile.remove(key);
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateFile(Map<FqName, List<VirtualFile>> $this$updateFile, KtFile file2) {
        Map<FqName, List<VirtualFile>> map2 = $this$updateFile;
        synchronized (map2) {
            boolean bl = false;
            VirtualFile virtualFile2 = file2.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.virtualFile");
            this.removeFile($this$updateFile, virtualFile2);
            VirtualFile virtualFile3 = file2.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"file.virtualFile");
            boolean bl2 = this.addPsiFile($this$updateFile, file2, virtualFile3);
        }
    }

    public final void update$kotlin_core(@NotNull VFileEvent event) {
        block3: {
            VFileEvent vFileEvent;
            block5: {
                block4: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        vFileEvent = event;
                        if (!(vFileEvent instanceof VFileCreateEvent)) break block2;
                        this.checkNewFileInSourceRoot(((VFileCreateEvent)event).getFile());
                        break block3;
                    }
                    if (!(vFileEvent instanceof VFileDeleteEvent)) break block4;
                    this.checkDeletedFileInSourceRoot(((VFileDeleteEvent)event).getFile());
                    break block3;
                }
                if (!(vFileEvent instanceof VFileCopyEvent)) break block5;
                VirtualFile virtualFile2 = ((VFileCopyEvent)event).getNewParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.newParent");
                VirtualFile newParent = virtualFile2;
                if (!newParent.isValid()) break block3;
                this.checkNewFileInSourceRoot(newParent.findChild(((VFileCopyEvent)event).getNewChildName()));
                break block3;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) break block3;
            this.checkNewFileInSourceRoot(((VFileMoveEvent)event).getFile());
            VirtualFile virtualFile3 = ((VFileMoveEvent)event).getOldParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"event.oldParent");
            if (Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(virtualFile3, this.project), (Object)((VFileMoveEvent)event).getOldParent())) {
                Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(((VFileMoveEvent)event).getOldParent());
                if (map2 != null) {
                    VirtualFile virtualFile4 = ((VFileMoveEvent)event).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"event.file");
                    this.removeFile(map2, virtualFile4);
                }
            }
        }
    }

    private final void checkNewFileInSourceRoot(VirtualFile file2) {
        block2: {
            if (file2 == null) {
                return;
            }
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(file2, this.project), (Object)file2.getParent())) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(file2.getParent());
            if (map2 != null) {
                this.addFile(map2, file2);
            }
        }
    }

    private final void checkDeletedFileInSourceRoot(VirtualFile file2) {
        block2: {
            VirtualFile directory;
            VirtualFile virtualFile2 = file2;
            Object object = directory = virtualFile2 != null ? virtualFile2.getParent() : null;
            if (directory == null || !directory.isValid()) {
                return;
            }
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(directory, this.project), (Object)directory)) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(directory);
            if (map2 != null) {
                this.removeFile(map2, file2);
            }
        }
    }

    public final void update$kotlin_core(@NotNull KtFile ktFile) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            VirtualFile virtualFile2 = ktFile.getVirtualFile();
            if (virtualFile2 == null || (virtualFile2 = virtualFile2.getParent()) == null) {
                return;
            }
            VirtualFile parent2 = virtualFile2;
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)ktFile), (Object)parent2)) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(parent2);
            if (map2 != null) {
                this.updateFile(map2, ktFile);
            }
        }
    }

    public ImplicitPackagePrefixCache(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.implicitPackageCache = new ConcurrentHashMap();
    }
}

