/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.project.CacheUtilsKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModelInfosCache;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryWrapper;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.PlatformModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.util.IjPlatformUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0011\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u001a$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0013H\u0000\u00a8\u0006\u0016"}, d2={"collectModuleInfosFromIdeaModel", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModelInfosCache;", "project", "Lcom/intellij/openapi/project/Project;", "getAllProjectSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "()[Lcom/intellij/openapi/projectRoots/Sdk;", "getIdeaModelInfosCache", "getModuleInfosFromIdeaModel", "", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "mergePlatformModules", "allModules", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "asLibraryEx", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "Lcom/intellij/openapi/roots/libraries/Library;", "wrap", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryWrapper;", "kotlin.core"})
public final class ModuleInfosFromIdeaModelKt {
    @NotNull
    public static final List<IdeaModuleInfo> getModuleInfosFromIdeaModel(@NotNull Project project2, @Nullable TargetPlatform platform2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        IdeaModelInfosCache ideaModelInfosCache = ModuleInfosFromIdeaModelKt.getIdeaModelInfosCache(project2);
        return platform2 != null ? ideaModelInfosCache.forPlatform(platform2) : ideaModelInfosCache.allModules();
    }

    public static /* synthetic */ List getModuleInfosFromIdeaModel$default(Project project2, TargetPlatform targetPlatform, int n, Object object) {
        if ((n & 2) != 0) {
            targetPlatform = null;
        }
        return ModuleInfosFromIdeaModelKt.getModuleInfosFromIdeaModel(project2, targetPlatform);
    }

    @NotNull
    public static final IdeaModelInfosCache getIdeaModelInfosCache(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return (IdeaModelInfosCache)CacheUtilsKt.cacheInvalidatingOnRootModifications(project2, (Function0)new Function0<IdeaModelInfosCache>(project2){
            final /* synthetic */ Project $project;

            @NotNull
            public final IdeaModelInfosCache invoke() {
                return ModuleInfosFromIdeaModelKt.access$collectModuleInfosFromIdeaModel(this.$project);
            }
            {
                this.$project = project2;
                super(0);
            }
        });
    }

    @NotNull
    public static final LibraryEx asLibraryEx(@NotNull Library $this$asLibraryEx) {
        Intrinsics.checkNotNullParameter((Object)$this$asLibraryEx, (String)"$this$asLibraryEx");
        boolean bl = $this$asLibraryEx instanceof LibraryEx;
        if (!bl) {
            boolean bl2 = false;
            String string = "Library '" + $this$asLibraryEx.getName() + "' does not implement LibraryEx which is not expected";
            throw new IllegalArgumentException(string.toString());
        }
        return (LibraryEx)$this$asLibraryEx;
    }

    @NotNull
    public static final LibraryWrapper wrap(@NotNull Library $this$wrap) {
        Intrinsics.checkNotNullParameter((Object)$this$wrap, (String)"$this$wrap");
        return new LibraryWrapper(ModuleInfosFromIdeaModelKt.asLibraryEx($this$wrap));
    }

    /*
     * WARNING - void declaration
     */
    private static final IdeaModelInfosCache collectModuleInfosFromIdeaModel(Project project2) {
        Map map2;
        void $this$associateWith$iv;
        void $this$flatMapTo$iv$iv;
        Object destination$iv$iv;
        void $this$flatMapTo$iv$iv2;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Object[] objectArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleManager.getInstance(project).modules");
        List ideaModules = ArraysKt.toList((Object[])objectArray);
        Iterable $this$flatMap$iv = ideaModules;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Module module2 = (Module)element$iv$iv;
            boolean bl = false;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            OrderEntry[] orderEntryArray = moduleRootManager.getOrderEntries();
            Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"ModuleRootManager.getInstance(module).orderEntries");
            Object $this$filterIsInstance$iv = orderEntryArray;
            boolean $i$f$filterIsInstance = false;
            OrderEntry[] orderEntryArray2 = $this$filterIsInstance$iv;
            destination$iv$iv = (OrderEntry[])new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (LibraryOrderEntry element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LibraryOrderEntry element$iv$iv2;
                element$iv$iv2 = (LibraryOrderEntry)item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl2 = false;
                Library library2 = it.getLibrary();
                LibraryWrapper libraryWrapper = library2 != null ? ModuleInfosFromIdeaModelKt.wrap(library2) : null;
                object.add(libraryWrapper);
            }
            Iterable list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set ideaLibraries = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv2)));
        Iterable $this$flatMap$iv2 = ideaModules;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv2 = $this$flatMap$iv2;
        Iterator destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Module module3 = (Module)element$iv$iv;
            boolean bl = false;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module3);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            OrderEntry[] orderEntryArray = moduleRootManager.getOrderEntries();
            Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"ModuleRootManager.getInstance(module).orderEntries");
            Object $this$filterIsInstance$iv = orderEntryArray;
            boolean $i$f$filterIsInstance = false;
            destination$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (JdkOrderEntry element$iv$iv3 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv3 instanceof JdkOrderEntry)) continue;
                destination$iv$iv4.add(element$iv$iv3);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv4;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JdkOrderEntry element$iv$iv3;
                element$iv$iv3 = (JdkOrderEntry)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl3 = false;
                Sdk sdk2 = it.getJdk();
                collection.add(sdk2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv4;
            CollectionsKt.addAll(destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List sdksFromModulesDependencies = (List)((Object)destination$iv$iv3);
        Iterable moduleInfosByModules = $this$flatMap$iv2 = MultiMap.create();
        boolean bl = false;
        for (Module module4 : ideaModules) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            Module module5 = module4;
            Intrinsics.checkNotNullExpressionValue((Object)module5, (String)"module");
            moduleInfosByModules.putValues(module4, IdeaModuleInfosKt.correspondingModuleInfos(module5));
        }
        Object object = Unit.INSTANCE;
        Iterable iterable2 = $this$flatMap$iv2;
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"MultiMap.create<Module, \u2026)\n            }\n        }");
        moduleInfosByModules = $this$flatMap$iv2 = MultiMap.create();
        object = iterable2;
        boolean bl4 = false;
        for (LibraryWrapper libraryWrapper : ideaLibraries) {
            void libraryInfosByLibraries;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            libraryInfosByLibraries.putValues((Object)libraryWrapper.getLibrary(), (Collection)IdeaModuleInfosKt.createLibraryInfo(project2, (Library)libraryWrapper.getLibrary()));
        }
        Object object2 = Unit.INSTANCE;
        Iterable iterable3 = $this$flatMap$iv2;
        Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"MultiMap.create<Library,\u2026)\n            }\n        }");
        $this$flatMap$iv2 = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)sdksFromModulesDependencies, (Object[])ModuleInfosFromIdeaModelKt.getAllProjectSdks())));
        object2 = iterable3;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Sdk list$iv$iv = (Sdk)element$iv$iv;
            Object t = element$iv$iv;
            map2 = result$iv;
            boolean bl5 = false;
            SdkInfo sdkInfo = new SdkInfo(project2, (Sdk)it);
            map2.put(t, sdkInfo);
        }
        Map map3 = map2 = (Map)result$iv;
        Object object3 = object2;
        Object object4 = object;
        return new IdeaModelInfosCache((MultiMap<Module, ModuleSourceInfo>)object4, (MultiMap<Library, LibraryInfo>)object3, map3);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IdeaModuleInfo> mergePlatformModules(List<? extends ModuleSourceInfo> allModules2, TargetPlatform platform2) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Collection $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        if (TargetPlatformKt.isCommon((TargetPlatform)platform2)) {
            return allModules2;
        }
        Set knownCommonModules = new LinkedHashSet();
        Iterable $this$mapNotNull$iv = allModules2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PlatformModuleInfo platformModuleInfo;
            PlatformModuleInfo platformModuleInfo2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ModuleSourceInfo module2 = (ModuleSourceInfo)element$iv$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)module2.getPlatform(), (Object)platform2) ^ true || module2.getExpectedBy().isEmpty() || knownCommonModules.contains(module2)) {
                platformModuleInfo2 = null;
            } else {
                void $this$onEach$iv;
                void var19_25;
                Iterable iterable2 = module2.getExpectedBy();
                boolean $i$f$onEach = false;
                void $this$onEach_u24lambda_u2d16$iv = var19_25 = $this$onEach$iv;
                boolean bl3 = false;
                for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
                    ModuleSourceInfo commonModule = (ModuleSourceInfo)element$iv;
                    boolean bl4 = false;
                    knownCommonModules.add(commonModule);
                }
                List commonModules = CollectionsKt.toList((Iterable)TypeUtilsKt.closure$default((Collection)((Collection)var19_25), (boolean)false, (Function1)((Function1)new Function1<ModuleSourceInfo, Collection<? extends ModuleSourceInfo>>(platform2, knownCommonModules){
                    final /* synthetic */ TargetPlatform $platform$inlined;
                    final /* synthetic */ Set $knownCommonModules$inlined;
                    {
                        this.$platform$inlined = targetPlatform;
                        this.$knownCommonModules$inlined = set2;
                        super(1);
                    }

                    @NotNull
                    public final Collection<ModuleSourceInfo> invoke(@NotNull ModuleSourceInfo it) {
                        Iterable iterable;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Iterable $this$onEach$iv = it.getExpectedBy();
                        boolean $i$f$onEach = false;
                        Iterable $this$onEach_u24lambda_u2d16$iv = iterable = $this$onEach$iv;
                        boolean bl = false;
                        for (T element$iv : $this$onEach_u24lambda_u2d16$iv) {
                            ModuleSourceInfo commonModule = (ModuleSourceInfo)element$iv;
                            boolean bl2 = false;
                            this.$knownCommonModules$inlined.add(commonModule);
                        }
                        return (Collection)iterable;
                    }
                }), (int)1, null));
                platformModuleInfo2 = new PlatformModuleInfo(module2, commonModules);
            }
            if (platformModuleInfo2 == null) continue;
            PlatformModuleInfo it$iv$iv = platformModuleInfo = platformModuleInfo2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter22 = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlatformModuleInfo it = (PlatformModuleInfo)element$iv$iv;
            boolean bl = false;
            if (!(!knownCommonModules.contains(it.getPlatformModule()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List platformModules = (List)destination$iv$iv;
        Iterable $i$f$filter22 = platformModules;
        $this$filterTo$iv$iv = new LinkedHashSet();
        Iterable iterable3 = allModules2;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PlatformModuleInfo it = (PlatformModuleInfo)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getContainedModules();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        void var31_38 = destination$iv;
        List rest = CollectionsKt.minus((Iterable)iterable3, (Iterable)((Iterable)var31_38));
        return CollectionsKt.plus((Collection)rest, (Iterable)platformModules);
    }

    @NotNull
    public static final Sdk[] getAllProjectSdks() {
        Sdk[] sdkArray = IjPlatformUtil.getProjectJdkTableSafe().getAllJdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getProjectJdkTableSafe().allJdks");
        return sdkArray;
    }

    public static final /* synthetic */ List access$mergePlatformModules(List allModules2, TargetPlatform platform2) {
        return ModuleInfosFromIdeaModelKt.mergePlatformModules(allModules2, platform2);
    }

    public static final /* synthetic */ IdeaModelInfosCache access$collectModuleInfosFromIdeaModel(Project project2) {
        return ModuleInfosFromIdeaModelKt.collectModuleInfosFromIdeaModel(project2);
    }
}

