/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00000\u0001:\u000201B9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0000J\u0011\u0010+\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010,\u001a\u00020\u00172\b\u0010*\u001a\u0004\u0018\u00010-H\u0096\u0002J\b\u0010.\u001a\u00020(H\u0016J\b\u0010/\u001a\u00020\u0003H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0015\u0010\b\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0012\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "", "rawVersion", "", "kotlinVersion", "Lkotlin/KotlinVersion;", "kind", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "buildNumber", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "(Ljava/lang/String;Lkotlin/KotlinVersion;Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;Ljava/lang/String;Lorg/jetbrains/kotlin/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;)V", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "artifactVersion", "getArtifactVersion", "()Ljava/lang/String;", "baseVersion", "getBaseVersion", "getBuildNumber", "isDev", "", "()Z", "isPreRelease", "isRelease", "isSnapshot", "getKind", "()Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "getKotlinVersion", "()Lkotlin/KotlinVersion;", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getRawVersion", "compare", "", "otherRawVersion", "other", "compareTo", "equals", "", "hashCode", "toString", "Companion", "Kind", "kotlin.base.plugin"})
public final class IdeKotlinVersion
implements Comparable<IdeKotlinVersion> {
    @NotNull
    private final String rawVersion;
    @NotNull
    private final KotlinVersion kotlinVersion;
    @NotNull
    private final Kind kind;
    @Nullable
    private final String buildNumber;
    @NotNull
    private final LanguageVersion languageVersion;
    @NotNull
    private final ApiVersion apiVersion;
    private static final Regex KOTLIN_COMPILER_VERSION_PATTERN;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getBaseVersion() {
        return this.kotlinVersion.toString();
    }

    @NotNull
    public final String getArtifactVersion() {
        StringBuilder stringBuilder;
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildString.append(this.getBaseVersion());
        if (this.kind.getArtifactSuffix() != null) {
            $this$buildString.append('-').append(this.kind.getArtifactSuffix());
            if (this.kind.getRequireBuildNumber() && this.buildNumber != null) {
                $this$buildString.append('-').append(this.buildNumber);
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public final boolean isRelease() {
        return Intrinsics.areEqual((Object)this.kind, (Object)Kind.Release.INSTANCE);
    }

    public final boolean isPreRelease() {
        return !this.isRelease();
    }

    public final boolean isDev() {
        return Intrinsics.areEqual((Object)this.kind, (Object)Kind.Dev.INSTANCE);
    }

    public final boolean isSnapshot() {
        return Intrinsics.areEqual((Object)this.kind, (Object)Kind.Snapshot.INSTANCE);
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return (LanguageVersionSettings)new LanguageVersionSettingsImpl(this.languageVersion, this.apiVersion, null, null, 12, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!(object instanceof IdeKotlinVersion)) {
            object = null;
        }
        IdeKotlinVersion ideKotlinVersion = (IdeKotlinVersion)object;
        if (ideKotlinVersion == null) {
            return false;
        }
        IdeKotlinVersion otherVersion = ideKotlinVersion;
        return Intrinsics.areEqual((Object)this.rawVersion, (Object)otherVersion.rawVersion);
    }

    public int hashCode() {
        return this.rawVersion.hashCode();
    }

    @NotNull
    public String toString() {
        return this.rawVersion;
    }

    @Override
    public int compareTo(@NotNull IdeKotlinVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return VersionComparatorUtil.compare((String)this.rawVersion, (String)other.rawVersion);
    }

    public final int compare(@NotNull String otherRawVersion) {
        Intrinsics.checkNotNullParameter((Object)otherRawVersion, (String)"otherRawVersion");
        return VersionComparatorUtil.compare((String)this.rawVersion, (String)otherRawVersion);
    }

    public final int compare(@NotNull IdeKotlinVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return VersionComparatorUtil.compare((String)this.rawVersion, (String)other.rawVersion);
    }

    @NlsSafe
    @NotNull
    public final String getRawVersion() {
        return this.rawVersion;
    }

    @NotNull
    public final KotlinVersion getKotlinVersion() {
        return this.kotlinVersion;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NlsSafe
    @Nullable
    public final String getBuildNumber() {
        return this.buildNumber;
    }

    @NotNull
    public final LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @NotNull
    public final ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    private IdeKotlinVersion(String rawVersion, KotlinVersion kotlinVersion2, Kind kind2, String buildNumber, LanguageVersion languageVersion2, ApiVersion apiVersion2) {
        this.rawVersion = rawVersion;
        this.kotlinVersion = kotlinVersion2;
        this.kind = kind2;
        this.buildNumber = buildNumber;
        this.languageVersion = languageVersion2;
        this.apiVersion = apiVersion2;
    }

    static {
        Companion = new Companion(null);
        String string = "^(\\d+)\\.(\\d+)\\.(\\d+)(?:-([A-Za-z]\\w+(?:-release)?))?(?:-(\\d+)?)?$";
        RegexOption regexOption = RegexOption.IGNORE_CASE;
        KOTLIN_COMPILER_VERSION_PATTERN = new Regex(string, regexOption);
    }

    public /* synthetic */ IdeKotlinVersion(String rawVersion, KotlinVersion kotlinVersion2, Kind kind2, String buildNumber, LanguageVersion languageVersion2, ApiVersion apiVersion2, DefaultConstructorMarker $constructor_marker) {
        this(rawVersion, kotlinVersion2, kind2, buildNumber, languageVersion2, apiVersion2);
    }

    @JvmStatic
    @NotNull
    public static final IdeKotlinVersion get(@NlsSafe @NotNull String rawVersion) {
        return Companion.get(rawVersion);
    }

    @JvmStatic
    @Nullable
    public static final IdeKotlinVersion opt(@NlsSafe @NotNull String rawVersion) {
        return Companion.opt(rawVersion);
    }

    @JvmStatic
    @NotNull
    public static final IdeKotlinVersion fromKotlinVersion(@NotNull KotlinVersion version2) {
        return Companion.fromKotlinVersion(version2);
    }

    @JvmStatic
    @NotNull
    public static final IdeKotlinVersion fromLanguageVersion(@NotNull LanguageVersion languageVersion2) {
        return Companion.fromLanguageVersion(languageVersion2);
    }

    @JvmStatic
    @Nullable
    public static final IdeKotlinVersion fromManifest(@NotNull VirtualFile jarFile) {
        return Companion.fromManifest(jarFile);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0007\f\r\u000e\u000f\u0010\u0011\u0012B\u001b\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0001\u0007\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "", "artifactSuffix", "", "requireBuildNumber", "", "(Ljava/lang/String;Z)V", "getArtifactSuffix", "()Ljava/lang/String;", "getRequireBuildNumber", "()Z", "toString", "Beta", "Dev", "Eap", "Milestone", "Release", "ReleaseCandidate", "Snapshot", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Release;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$ReleaseCandidate;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Beta;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Milestone;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Eap;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Dev;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Snapshot;", "kotlin.base.plugin"})
    public static abstract class Kind {
        @Nullable
        private final String artifactSuffix;
        private final boolean requireBuildNumber;

        @NotNull
        public String toString() {
            String string = this.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
            return string;
        }

        @Nullable
        public final String getArtifactSuffix() {
            return this.artifactSuffix;
        }

        public final boolean getRequireBuildNumber() {
            return this.requireBuildNumber;
        }

        private Kind(String artifactSuffix, boolean requireBuildNumber) {
            this.artifactSuffix = artifactSuffix;
            this.requireBuildNumber = requireBuildNumber;
        }

        public /* synthetic */ Kind(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(string, bl);
        }

        public /* synthetic */ Kind(String artifactSuffix, boolean requireBuildNumber, DefaultConstructorMarker $constructor_marker) {
            this(artifactSuffix, requireBuildNumber);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Release;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "()V", "kotlin.base.plugin"})
        public static final class Release
        extends Kind {
            @NotNull
            public static final Release INSTANCE;

            private Release() {
                super(null, false, 2, null);
            }

            static {
                Release release;
                INSTANCE = release = new Release();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$ReleaseCandidate;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "(I)V", "getNumber", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class ReleaseCandidate
        extends Kind {
            private final int number;

            public final int getNumber() {
                return this.number;
            }

            public ReleaseCandidate(int number) {
                super((String)(number == 1 ? "RC" : "RC" + number), false, 2, null);
                this.number = number;
            }

            public final int component1() {
                return this.number;
            }

            @NotNull
            public final ReleaseCandidate copy(int number) {
                return new ReleaseCandidate(number);
            }

            public static /* synthetic */ ReleaseCandidate copy$default(ReleaseCandidate releaseCandidate, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = releaseCandidate.number;
                }
                return releaseCandidate.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "ReleaseCandidate(number=" + this.number + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.number);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ReleaseCandidate)) break block3;
                        ReleaseCandidate releaseCandidate = (ReleaseCandidate)object;
                        if (this.number != releaseCandidate.number) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Beta;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "(I)V", "getNumber", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class Beta
        extends Kind {
            private final int number;

            public final int getNumber() {
                return this.number;
            }

            public Beta(int number) {
                super("Beta" + number, false, 2, null);
                this.number = number;
            }

            public final int component1() {
                return this.number;
            }

            @NotNull
            public final Beta copy(int number) {
                return new Beta(number);
            }

            public static /* synthetic */ Beta copy$default(Beta beta, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = beta.number;
                }
                return beta.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "Beta(number=" + this.number + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.number);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Beta)) break block3;
                        Beta beta = (Beta)object;
                        if (this.number != beta.number) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Milestone;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "(I)V", "getNumber", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class Milestone
        extends Kind {
            private final int number;

            public final int getNumber() {
                return this.number;
            }

            public Milestone(int number) {
                super("M" + number, false, 2, null);
                this.number = number;
            }

            public final int component1() {
                return this.number;
            }

            @NotNull
            public final Milestone copy(int number) {
                return new Milestone(number);
            }

            public static /* synthetic */ Milestone copy$default(Milestone milestone, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = milestone.number;
                }
                return milestone.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "Milestone(number=" + this.number + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.number);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Milestone)) break block3;
                        Milestone milestone = (Milestone)object;
                        if (this.number != milestone.number) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Eap;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "(I)V", "getNumber", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class Eap
        extends Kind {
            private final int number;

            public final int getNumber() {
                return this.number;
            }

            public Eap(int number) {
                super((String)(number == 1 ? "eap" : "eap" + number), false, 2, null);
                this.number = number;
            }

            public final int component1() {
                return this.number;
            }

            @NotNull
            public final Eap copy(int number) {
                return new Eap(number);
            }

            public static /* synthetic */ Eap copy$default(Eap eap, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = eap.number;
                }
                return eap.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "Eap(number=" + this.number + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.number);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Eap)) break block3;
                        Eap eap = (Eap)object;
                        if (this.number != eap.number) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Dev;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "()V", "kotlin.base.plugin"})
        public static final class Dev
        extends Kind {
            @NotNull
            public static final Dev INSTANCE;

            private Dev() {
                super("dev", true, null);
            }

            static {
                Dev dev;
                INSTANCE = dev = new Dev();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Snapshot;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "()V", "kotlin.base.plugin"})
        public static final class Snapshot
        extends Kind {
            @NotNull
            public static final Snapshot INSTANCE;

            private Snapshot() {
                super("SNAPSHOT", true, null);
            }

            static {
                Snapshot snapshot;
                INSTANCE = snapshot = new Snapshot();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u000f\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0007J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0007J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0010\u001a\u00020\u0011\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J.\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00180\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Companion;", "", "()V", "KOTLIN_COMPILER_VERSION_PATTERN", "Lkotlin/text/Regex;", "fromKotlinVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "version", "Lkotlin/KotlinVersion;", "fromLanguageVersion", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "fromManifest", "jarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "get", "rawVersion", "", "opt", "parse", "Lkotlin/Result;", "parse-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "parseKind", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "kindSuffix", "prefix", "factory", "Lkotlin/Function1;", "", "kotlin.base.plugin"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IdeKotlinVersion get(@NlsSafe @NotNull String rawVersion) {
            Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
            Object object = this.parse-IoAF18A(rawVersion);
            ResultKt.throwOnFailure((Object)object);
            return (IdeKotlinVersion)object;
        }

        @JvmStatic
        @Nullable
        public final IdeKotlinVersion opt(@NlsSafe @NotNull String rawVersion) {
            Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
            Object object = this.parse-IoAF18A(rawVersion);
            return (IdeKotlinVersion)(Result.isFailure-impl((Object)object) ? null : object);
        }

        @JvmStatic
        @NotNull
        public final IdeKotlinVersion fromKotlinVersion(@NotNull KotlinVersion version2) {
            LanguageVersion element$iv;
            block2: {
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                LanguageVersion[] $this$first$iv = LanguageVersion.values();
                boolean $i$f$first = false;
                int n = $this$first$iv.length;
                for (int i = 0; i < n; ++i) {
                    LanguageVersion it = element$iv = $this$first$iv[i];
                    boolean bl = false;
                    if (!(it.getMajor() == version2.getMajor() && it.getMinor() == version2.getMinor())) {
                        continue;
                    }
                    break block2;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            LanguageVersion languageVersion2 = element$iv;
            return new IdeKotlinVersion(version2.toString(), version2, Kind.Release.INSTANCE, null, languageVersion2, ApiVersion.Companion.createByLanguageVersion(languageVersion2), null);
        }

        @JvmStatic
        @NotNull
        public final IdeKotlinVersion fromLanguageVersion(@NotNull LanguageVersion languageVersion2) {
            Intrinsics.checkNotNullParameter((Object)languageVersion2, (String)"languageVersion");
            return new IdeKotlinVersion(languageVersion2.getMajor() + "." + languageVersion2.getMinor() + ".0", new KotlinVersion(languageVersion2.getMajor(), languageVersion2.getMinor(), 0), Kind.Release.INSTANCE, null, languageVersion2, ApiVersion.Companion.createByLanguageVersion(languageVersion2), null);
        }

        @JvmStatic
        @Nullable
        public final IdeKotlinVersion fromManifest(@NotNull VirtualFile jarFile) {
            Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)jarFile);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"VfsUtilCore.virtualToIoFile(jarFile)");
            File ioFile = file2;
            String string = JarUtil.getJarAttribute((File)ioFile, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JarUtil.getJarAttribute(\u2026N_VERSION) ?: return null");
            String unprocessedVersion = string;
            String string2 = StringsKt.substringBefore$default((String)unprocessedVersion, (char)'(', null, (int)2, null);
            String rawVersion = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            return this.opt(rawVersion);
        }

        private final Kind parseKind(String kindSuffix, String prefix2, Function1<? super Integer, ? extends Kind> factory2) {
            boolean bl = StringsKt.startsWith$default((String)kindSuffix, (String)prefix2, (boolean)false, (int)2, null);
            if (!bl) {
                boolean $i$a$-check-IdeKotlinVersion$Companion$parseKind$22 = false;
                String $i$a$-check-IdeKotlinVersion$Companion$parseKind$22 = "Prefix \"" + prefix2 + "\" not found in kind suffix \"" + kindSuffix + "\"";
                throw new IllegalStateException($i$a$-check-IdeKotlinVersion$Companion$parseKind$22.toString());
            }
            String numberString = StringsKt.removeSuffix((String)StringsKt.drop((String)kindSuffix, (int)prefix2.length()), (CharSequence)"-release");
            CharSequence $i$a$-check-IdeKotlinVersion$Companion$parseKind$22 = numberString;
            if ($i$a$-check-IdeKotlinVersion$Companion$parseKind$22.length() == 0) {
                return (Kind)factory2.invoke((Object)1);
            }
            Integer n = StringsKt.toIntOrNull((String)numberString);
            if (n == null) {
                return null;
            }
            int number = n;
            return (Kind)factory2.invoke((Object)number);
        }

        @NotNull
        public final Object parse-IoAF18A(@NotNull String rawVersion) {
            LanguageVersion languageVersion2;
            LanguageVersion languageVersion3;
            String buildNumber;
            Kind kind2;
            KotlinVersion kotlinVersion2;
            block7: {
                Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
                MatchResult matchResult2 = KOTLIN_COMPILER_VERSION_PATTERN.matchEntire((CharSequence)rawVersion);
                if (matchResult2 == null) {
                    Result.Companion companion = Result.Companion;
                    Throwable throwable = new IllegalArgumentException("Unsupported compiler version: " + rawVersion);
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                MatchResult matchResult3 = matchResult2;
                Integer n = StringsKt.toIntOrNull((String)((String)matchResult3.getGroupValues().get(1)));
                if (n == null) {
                    Result.Companion companion = Result.Companion;
                    Throwable throwable = new IllegalArgumentException("Invalid major version component: " + rawVersion);
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                int majorValue = n;
                Integer n2 = StringsKt.toIntOrNull((String)((String)matchResult3.getGroupValues().get(2)));
                if (n2 == null) {
                    Result.Companion companion = Result.Companion;
                    Throwable throwable = new IllegalArgumentException("Invalid minor version component: " + rawVersion);
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                int minorValue = n2;
                Integer n3 = StringsKt.toIntOrNull((String)((String)matchResult3.getGroupValues().get(3)));
                if (n3 == null) {
                    Result.Companion companion = Result.Companion;
                    Throwable throwable = new IllegalArgumentException("Invalid patch version component: " + rawVersion);
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                int patchValue = n3;
                kotlinVersion2 = new KotlinVersion(majorValue, minorValue, patchValue);
                String kindSuffix = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)((String)matchResult3.getGroupValues().get(4)));
                Kind kind3 = Intrinsics.areEqual((Object)kindSuffix, (Object)"release") || Intrinsics.areEqual((Object)kindSuffix, (Object)"") ? (Kind)Kind.Release.INSTANCE : (Intrinsics.areEqual((Object)kindSuffix, (Object)"dev") ? (Kind)Kind.Dev.INSTANCE : (Intrinsics.areEqual((Object)kindSuffix, (Object)"snapshot") || Intrinsics.areEqual((Object)kindSuffix, (Object)"local") ? (Kind)Kind.Snapshot.INSTANCE : (StringsKt.startsWith$default((String)kindSuffix, (String)"rc", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "rc", (Function1<? super Integer, ? extends Kind>)((Function1)parse.kind.1.INSTANCE)) : (StringsKt.startsWith$default((String)kindSuffix, (String)"beta", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "beta", (Function1<? super Integer, ? extends Kind>)((Function1)parse.kind.2.INSTANCE)) : (StringsKt.startsWith$default((String)kindSuffix, (String)"m", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "m", (Function1<? super Integer, ? extends Kind>)((Function1)parse.kind.3.INSTANCE)) : (StringsKt.startsWith$default((String)kindSuffix, (String)"eap", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "eap", (Function1<? super Integer, ? extends Kind>)((Function1)parse.kind.4.INSTANCE)) : null))))));
                if (kind3 == null) {
                    Result.Companion companion = Result.Companion;
                    Throwable throwable = new IllegalArgumentException("Unsupported version kind suffix: \"" + kindSuffix + "\" (" + rawVersion + ")");
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                kind2 = kind3;
                Object e = matchResult3.getGroupValues().get(5);
                String it = (String)e;
                boolean bl = false;
                CharSequence charSequence = it;
                buildNumber = (String)(charSequence.length() > 0 ? e : null);
                LanguageVersion[] $this$firstOrNull$iv = LanguageVersion.values();
                boolean $i$f$firstOrNull = false;
                int n4 = $this$firstOrNull$iv.length;
                for (int i = 0; i < n4; ++i) {
                    LanguageVersion element$iv;
                    LanguageVersion it2 = element$iv = $this$firstOrNull$iv[i];
                    boolean bl2 = false;
                    if (!(it2.getMajor() == majorValue && it2.getMinor() == minorValue)) continue;
                    languageVersion3 = element$iv;
                    break block7;
                }
                languageVersion3 = languageVersion2 = null;
            }
            if (languageVersion3 == null) {
                languageVersion2 = LanguageVersion.FIRST_SUPPORTED;
            }
            LanguageVersion languageVersion4 = languageVersion2;
            ApiVersion apiVersion2 = ApiVersion.Companion.createByLanguageVersion(languageVersion4);
            IdeKotlinVersion ideKotlinVersion = new IdeKotlinVersion(rawVersion, kotlinVersion2, kind2, buildNumber, languageVersion4, apiVersion2, null);
            Result.Companion companion = Result.Companion;
            return Result.constructor-impl((Object)ideKotlinVersion);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

