/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0014JF\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinEnterAfterUnmatchedBraceHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler;", "()V", "getRBraceForLambda", "", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "(Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;)Ljava/lang/Integer;", "getRBraceOffset", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffset", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "isDeclarationInitializer", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
public final class KotlinEnterAfterUnmatchedBraceHandler
extends EnterAfterUnmatchedBraceHandler {
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        int caretOffset = ((Number)caretOffsetRef.get()).intValue() - 1;
        PsiElement element3 = file2.findElementAt(caretOffset);
        PsiElement psiElement2 = element3;
        if (Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)KtTokens.LBRACE)) {
            EnterHandlerDelegate.Result result2 = super.preprocessEnter(file2, editor2, caretOffsetRef, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
            return result2;
        }
        if (!(element3 instanceof PsiWhiteSpace)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement prevElement = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file2, caretOffset);
        if (prevElement != null) {
            ASTNode aSTNode = prevElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"prevElement.node");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtTokens.LBRACE)) {
                EnterHandlerDelegate.Result result3 = super.preprocessEnter(file2, editor2, new Ref((Object)(PsiUtilsKt.getStartOffset((PsiElement)prevElement) + 1)), caretAdvance, dataContext, originalHandler);
                Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
                return result3;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected int getRBraceOffset(@NotNull PsiFile file2, @NotNull Editor editor2, int caretOffset) {
        Integer endOffset2;
        Integer n;
        PsiElement parent2;
        PsiElement nextSibling;
        PsiElement element3;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiElement psiElement2 = element3 = file2.findElementAt(caretOffset - 1);
        Object object = nextSibling = psiElement2 != null ? psiElement2.getNextSibling() : null;
        if (nextSibling instanceof PsiWhiteSpace && nextSibling.textContains('\n')) {
            return super.getRBraceOffset(file2, editor2, caretOffset);
        }
        PsiElement psiElement3 = element3;
        Object object2 = parent2 = psiElement3 != null ? psiElement3.getParent() : null;
        if (parent2 instanceof KtFunctionLiteral) {
            n = this.getRBraceForLambda((KtFunctionLiteral)parent2);
        } else if (parent2 instanceof KtWhenExpression) {
            if (this.isDeclarationInitializer((KtExpression)parent2)) {
                KtWhenCondition ktWhenCondition;
                List list2 = ((KtWhenExpression)parent2).getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parent.entries");
                Object[] objectArray = (Object[])CollectionsKt.firstOrNull((List)list2);
                if (!((objectArray != null && (objectArray = objectArray.getConditions()) != null ? (KtWhenCondition)ArraysKt.firstOrNull((Object[])objectArray) : (ktWhenCondition = null)) instanceof KtWhenConditionWithExpression)) {
                    ktWhenCondition = null;
                }
                KtWhenConditionWithExpression ktWhenConditionWithExpression = (KtWhenConditionWithExpression)ktWhenCondition;
                n = ktWhenConditionWithExpression != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktWhenConditionWithExpression))) : null;
            } else {
                n = null;
            }
        } else {
            n = null;
        }
        Integer n2 = endOffset2 = n;
        return n2 != null ? n2.intValue() : super.getRBraceOffset(file2, editor2, caretOffset);
    }

    private final Integer getRBraceForLambda(KtFunctionLiteral functionLiteral) {
        PsiElement firstVisibleChild;
        KtLambdaExpression ktLambdaExpression2;
        PsiElement psiElement2 = functionLiteral.getParent();
        if (!(psiElement2 instanceof KtLambdaExpression)) {
            psiElement2 = null;
        }
        if ((ktLambdaExpression2 = (KtLambdaExpression)psiElement2) == null || (ktLambdaExpression2 = ktLambdaExpression2.getBodyExpression()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktLambdaExpression2, (String)"(functionLiteral.parent \u2026Expression ?: return null");
        KtLambdaExpression bodyExpression = ktLambdaExpression2;
        PsiElement psiElement3 = bodyExpression.getFirstChild();
        PsiElement psiElement4 = firstVisibleChild = psiElement3 != null ? PsiUtilsKt.getNextSiblingIgnoringWhitespace((PsiElement)psiElement3, (boolean)true) : null;
        return psiElement4 != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)psiElement4)) : null;
    }

    private final boolean isDeclarationInitializer(KtExpression $this$isDeclarationInitializer) {
        PsiElement psiElement2 = $this$isDeclarationInitializer.getParent();
        if (!(psiElement2 instanceof KtDeclarationWithInitializer)) {
            psiElement2 = null;
        }
        KtDeclarationWithInitializer ktDeclarationWithInitializer = (KtDeclarationWithInitializer)psiElement2;
        return Intrinsics.areEqual((Object)(ktDeclarationWithInitializer != null ? ktDeclarationWithInitializer.getInitializer() : null), (Object)$this$isDeclarationInitializer);
    }
}

