/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinObsoleteCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinPredefinedCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0016\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/ProjectCodeStyleImporter;", "", "()V", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "codeStyleStr", "", "", "predefinedCodeStyle", "Lorg/jetbrains/kotlin/idea/formatter/KotlinPredefinedCodeStyle;", "kotlin.formatter"})
public final class ProjectCodeStyleImporter {
    @NotNull
    public static final ProjectCodeStyleImporter INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean apply(@NotNull Project project2, @Nullable String codeStyleStr) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string = codeStyleStr;
        if (string == null) return false;
        switch (string) {
            case "obsolete": {
                this.apply(project2, KotlinObsoleteCodeStyle.Companion.getINSTANCE());
                return true;
            }
            case "official": {
                this.apply(project2, KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
                return true;
            }
            default: {
                return false;
            }
        }
    }

    public final void apply(@NotNull Project project2, @NotNull KotlinPredefinedCodeStyle predefinedCodeStyle) {
        CodeStyleSettings codeStyleSettings;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)predefinedCodeStyle), (String)"predefinedCodeStyle");
        CodeStyleSettings codeStyleSettings2 = CodeStyle.getSettings((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings2, (String)"CodeStyle.getSettings(project)");
        CodeStyleSettings customSettings = codeStyleSettings2;
        if (Intrinsics.areEqual((Object)predefinedCodeStyle.getCodeStyleId(), (Object)CodeStyleUtilsKt.kotlinCodeStyleDefaults(customSettings))) {
            return;
        }
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)project2);
        if (CodeStyle.usesOwnSettings((Project)project2)) {
            CodeStyleSettings codeStyleSettings3 = settingsManager.cloneSettings(customSettings);
            codeStyleSettings = codeStyleSettings3;
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings3, (String)"settingsManager.cloneSettings(customSettings)");
        } else {
            CodeStyleSettings codeStyleSettings4 = CodeStyle.getDefaultSettings();
            codeStyleSettings = codeStyleSettings4;
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings4, (String)"CodeStyle.getDefaultSettings()");
        }
        CodeStyleSettings projectSettingsUpdated = codeStyleSettings;
        predefinedCodeStyle.apply(projectSettingsUpdated);
        CodeStyle.setMainProjectSettings((Project)project2, (CodeStyleSettings)projectSettingsUpdated);
        settingsManager.notifyCodeStyleSettingsChanged();
    }

    private ProjectCodeStyleImporter() {
    }

    static {
        ProjectCodeStyleImporter projectCodeStyleImporter;
        INSTANCE = projectCodeStyleImporter = new ProjectCodeStyleImporter();
    }
}

