/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.highlighter.KotlinSuppressableWarningProblemGroupKt;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantSuppression;
import org.jetbrains.kotlin.idea.util.PsiUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J%\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinInspectionSuppressor;", "Lcom/intellij/codeInspection/InspectionSuppressor;", "Lcom/intellij/codeInspection/RedundantSuppressionDetector;", "()V", "createRemoveRedundantSuppressionFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "toolId", "", "getSuppressActions", "", "Lcom/intellij/codeInspection/SuppressQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "getSuppressionIds", "isSuppressedFor", "", "isSuppressionFor", "elementWithSuppression", "place", "suppressionIds", "", "kotlin.core"})
public final class KotlinInspectionSuppressor
implements InspectionSuppressor,
RedundantSuppressionDetector {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element3, @NotNull String toolId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        if (element3 == null) {
            return new SuppressQuickFix[0];
        }
        Iterable $this$map$iv = KotlinSuppressableWarningProblemGroupKt.createSuppressWarningActions(element3, Severity.WARNING, toolId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SuppressIntentionAction suppressIntentionAction = (SuppressIntentionAction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SuppressQuickFix suppressQuickFix = new SuppressQuickFix((SuppressIntentionAction)it){
                final /* synthetic */ SuppressIntentionAction $it;

                @NotNull
                public String getFamilyName() {
                    String string = this.$it.getFamilyName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.familyName");
                    return string;
                }

                @NotNull
                public String getName() {
                    String string = this.$it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                    return string;
                }

                public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    this.$it.invoke(project2, null, descriptor2.getPsiElement());
                }

                public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    return this.$it.isAvailable(project2, null, context2);
                }

                public boolean isSuppressAll() {
                    return this.$it.isSuppressAll();
                }
                {
                    this.$it = $captured_local_variable$0;
                }
            };
            collection.add(suppressQuickFix);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SuppressQuickFix[] suppressQuickFixArray = thisCollection$iv.toArray(new SuppressQuickFix[0]);
        Intrinsics.checkNotNull((Object)suppressQuickFixArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return suppressQuickFixArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element3, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        KotlinSuppressCache kotlinSuppressCache2 = KotlinCacheService.Companion.getInstance(project2).getSuppressionCache();
        PsiFile psiFile2 = element3.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile");
        return kotlinSuppressCache2.isSuppressed((Object)element3, (Object)psiFile2, toolId, Severity.WARNING);
    }

    @Nullable
    public String getSuppressionIds(@NotNull PsiElement element3) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Collection $this$ifNotEmpty$iv = this.suppressionIds(element3);
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$ifNotEmpty = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            string = CollectionsKt.joinToString$default((Iterable)$this$ifNotEmpty, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final List<String> suppressionIds(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement $this$safeAs$iv = element3;
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtAnnotated)) {
            psiElement2 = null;
        }
        KtAnnotated ktAnnotated = (KtAnnotated)psiElement2;
        List list2 = ktAnnotated != null ? PsiUtilsKt.findSuppressedTools(ktAnnotated) : null;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @NotNull
    public LocalQuickFix createRemoveRedundantSuppressionFix(@NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        return new RemoveRedundantSuppression(toolId);
    }

    public boolean isSuppressionFor(@NotNull PsiElement elementWithSuppression, @NotNull PsiElement place, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)elementWithSuppression, (String)"elementWithSuppression");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        return elementWithSuppression == place || PsiTreeUtilKt.isAncestor((PsiElement)elementWithSuppression, (PsiElement)place, (boolean)false);
    }
}

