/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.quickfix.AbstractChangeFeatureSupportLevelFix$Companion$WhenMappings;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\tJ\b\u0010\u0014\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AbstractChangeFeatureSupportLevelFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "element", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "featureSupport", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "featureShortName", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageFeature;Lorg/jetbrains/kotlin/config/LanguageFeature$State;Ljava/lang/String;)V", "getFeature", "()Lorg/jetbrains/kotlin/config/LanguageFeature;", "getFeatureSupport", "()Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "featureSupportEnabled", "", "getFeatureSupportEnabled", "()Z", "getFamilyName", "getText", "Companion", "FeatureSupportIntentionActionsFactory", "kotlin.idea"})
public abstract class AbstractChangeFeatureSupportLevelFix
extends KotlinQuickFixAction<PsiElement> {
    @NotNull
    private final LanguageFeature feature;
    @NotNull
    private final LanguageFeature.State featureSupport;
    private final String featureShortName;
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected final boolean getFeatureSupportEnabled() {
        return this.featureSupport == LanguageFeature.State.ENABLED || this.featureSupport == LanguageFeature.State.ENABLED_WITH_WARNING;
    }

    @NotNull
    public final String getFamilyName() {
        return KotlinBundle.message("fix.change.feature.support.family", this.featureShortName);
    }

    @NotNull
    public String getText() {
        return Companion.getFixText(this.featureSupport, this.featureShortName);
    }

    @NotNull
    protected final LanguageFeature getFeature() {
        return this.feature;
    }

    @NotNull
    protected final LanguageFeature.State getFeatureSupport() {
        return this.featureSupport;
    }

    public AbstractChangeFeatureSupportLevelFix(@NotNull PsiElement element3, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State featureSupport, @NotNull String featureShortName) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)featureSupport, (String)"featureSupport");
        Intrinsics.checkNotNullParameter((Object)featureShortName, (String)"featureShortName");
        super(element3);
        this.feature = feature;
        this.featureSupport = featureSupport;
        this.featureShortName = featureShortName;
    }

    public /* synthetic */ AbstractChangeFeatureSupportLevelFix(PsiElement psiElement2, LanguageFeature languageFeature, LanguageFeature.State state, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = languageFeature.getPresentableName();
        }
        this(psiElement2, languageFeature, state, string);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\rH\u0004J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AbstractChangeFeatureSupportLevelFix$FeatureSupportIntentionActionsFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "allowWarningAndErrorMode", "", "quickFixConstructor", "Lkotlin/Function3;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "shouldConfigureInProject", "module", "Lcom/intellij/openapi/module/Module;", "kotlin.idea"})
    public static abstract class FeatureSupportIntentionActionsFactory
    extends KotlinIntentionActionsFactory {
        protected final boolean shouldConfigureInProject(@NotNull Module module2) {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Object object = KotlinFacet.Companion.get(module2);
            KotlinFacetSettings facetSettings = object != null && (object = (KotlinFacetConfiguration)object.getConfiguration()) != null ? object.getSettings() : null;
            return (facetSettings == null || facetSettings.getUseProjectSettings()) && BuildSystemTypeKt.getBuildSystemType(module2) == BuildSystemType.JPS;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected final List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic, @NotNull LanguageFeature feature, boolean allowWarningAndErrorMode, @NotNull Function3<? super PsiElement, ? super LanguageFeature, ? super LanguageFeature.State, ? extends IntentionAction> quickFixConstructor) {
            void $this$mapTo$iv$iv;
            List list2;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Intrinsics.checkNotNullParameter(quickFixConstructor, (String)"quickFixConstructor");
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.EXPERIMENTAL_FEATURE_ERROR)) {
                if ((LanguageFeature)((Pair)((DiagnosticWithParameters1)Errors.EXPERIMENTAL_FEATURE_ERROR.cast((UnboundDiagnostic)diagnostic)).getA()).getFirst() != feature) {
                    return CollectionsKt.emptyList();
                }
                list2 = !allowWarningAndErrorMode ? CollectionsKt.listOf((Object)LanguageFeature.State.ENABLED) : CollectionsKt.listOf((Object[])new LanguageFeature.State[]{LanguageFeature.State.ENABLED_WITH_WARNING, LanguageFeature.State.ENABLED});
            } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.EXPERIMENTAL_FEATURE_WARNING)) {
                if ((LanguageFeature)((Pair)((DiagnosticWithParameters1)Errors.EXPERIMENTAL_FEATURE_WARNING.cast((UnboundDiagnostic)diagnostic)).getA()).getFirst() != feature) {
                    return CollectionsKt.emptyList();
                }
                list2 = !allowWarningAndErrorMode ? CollectionsKt.listOf((Object)LanguageFeature.State.ENABLED) : CollectionsKt.listOf((Object[])new LanguageFeature.State[]{LanguageFeature.State.ENABLED, LanguageFeature.State.ENABLED_WITH_ERROR});
            } else {
                return CollectionsKt.emptyList();
            }
            List newFeatureSupports = list2;
            Iterable $this$map$iv = newFeatureSupports;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LanguageFeature.State state = (LanguageFeature.State)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IntentionAction intentionAction = (IntentionAction)quickFixConstructor.invoke((Object)diagnostic.getPsiElement(), (Object)feature, (Object)it);
                collection.add(intentionAction);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AbstractChangeFeatureSupportLevelFix$Companion;", "", "()V", "getFixText", "", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "featureShortName", "kotlin.idea"})
    public static final class Companion {
        @Nls
        @NotNull
        public final String getFixText(@NotNull LanguageFeature.State state, @NotNull String featureShortName) {
            String string;
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)featureShortName, (String)"featureShortName");
            switch (AbstractChangeFeatureSupportLevelFix$Companion$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    string = KotlinBundle.message("fix.change.feature.support.enabled", featureShortName);
                    break;
                }
                case 2: {
                    string = KotlinBundle.message("fix.change.feature.support.enabled.warning", featureShortName);
                    break;
                }
                case 3: 
                case 4: {
                    string = KotlinBundle.message("fix.change.feature.support.disabled", featureShortName);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

