/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.intentions.AddFullQualifierIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0094\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/UseFullyQualifiedCallFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "referenceExpression", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;)V", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class UseFullyQualifiedCallFix
extends KotlinQuickFixAction<KtNameReferenceExpression> {
    @NotNull
    private final FqName fqName;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.use.fully.qualified.call", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)this.getElement();
        if (ktNameReferenceExpression == null) {
            return;
        }
        KtNameReferenceExpression element3 = ktNameReferenceExpression;
        KtElement result2 = AddFullQualifierIntention.Companion.applyTo(element3, this.fqName);
        ShortenReferences.process$default(ShortenReferences.DEFAULT, result2, null, 2, null);
    }

    @NotNull
    public final FqName getFqName() {
        return this.fqName;
    }

    public UseFullyQualifiedCallFix(@NotNull FqName fqName2, @NotNull KtNameReferenceExpression referenceExpression) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
        super((PsiElement)referenceExpression);
        this.fqName = fqName2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/UseFullyQualifiedCallFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/UseFullyQualifiedCallFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected UseFullyQualifiedCallFix createAction(@NotNull Diagnostic diagnostic) {
            KtElement referenceExpression;
            KtElement ktElement;
            KtElement ktElement2;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters1 warning = (DiagnosticWithParameters1)Errors.COMPATIBILITY_WARNING.cast((UnboundDiagnostic)diagnostic);
            PsiElement psiElement2 = warning.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"warning.psiElement");
            KtElement element3 = (KtElement)psiElement2;
            Object object = warning.getA();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"warning.a");
            CallableDescriptor descriptor2 = (CallableDescriptor)object;
            FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor2);
            if (fqName2 == null) {
                return null;
            }
            FqName fqName3 = fqName2;
            if (element3 instanceof KtValueArgument) {
                KtCallableReferenceExpression expression2;
                KtExpression ktExpression = ((KtValueArgument)element3).getArgumentExpression();
                if (!(ktExpression instanceof KtCallableReferenceExpression)) {
                    ktExpression = null;
                }
                KtCallableReferenceExpression ktCallableReferenceExpression = expression2 = (KtCallableReferenceExpression)ktExpression;
                ktElement2 = (KtElement)(ktCallableReferenceExpression != null ? ktCallableReferenceExpression.getCallableReference() : null);
            } else {
                ktElement2 = element3;
            }
            if (!((ktElement = (referenceExpression = ktElement2)) instanceof KtNameReferenceExpression)) {
                ktElement = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktElement;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            KtNameReferenceExpression nameReferenceExpression = ktNameReferenceExpression;
            if (!AddFullQualifierIntention.Companion.isApplicableTo(nameReferenceExpression, (DeclarationDescriptor)descriptor2)) {
                return null;
            }
            return new UseFullyQualifiedCallFix(fqName3, nameReferenceExpression);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

