/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.RenderingUtilsKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"FUNCTION_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "formatClass", "", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "inCode", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "formatClassDescriptor", "formatFunction", "functionDescriptor", "formatFunctionDescriptor", "formatJavaOrLightMethod", "method", "Lcom/intellij/psi/PsiMethod;", "formatPsiClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "markAsJava", "formatPsiMethod", "psiMethod", "showContainingClass", "wrapOrSkip", "s", "kotlin.idea"})
public final class RenderingUtilsKt {
    private static final DescriptorRenderer FUNCTION_RENDERER = DescriptorRenderer.Companion.withOptions((Function1)FUNCTION_RENDERER.1.INSTANCE);

    @NotNull
    public static final String wrapOrSkip(@NotNull String s, boolean inCode) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return inCode ? "<code>" + s + "</code>" : s;
    }

    @NotNull
    public static final String formatClassDescriptor(@NotNull DeclarationDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        return IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.render(classDescriptor);
    }

    @NotNull
    public static final String formatPsiClass(@NotNull PsiClass psiClass2, boolean markAsJava, boolean inCode) {
        Intrinsics.checkNotNullParameter((Object)psiClass2, (String)"psiClass");
        Object description2 = null;
        String kind2 = psiClass2.isInterface() ? "interface " : "class ";
        description2 = kind2 + PsiFormatUtil.formatClass((PsiClass)psiClass2, (int)4355);
        description2 = RenderingUtilsKt.wrapOrSkip((String)description2, inCode);
        return markAsJava ? "[Java] " + (String)description2 : description2;
    }

    @NotNull
    public static final String formatClass(@NotNull DeclarationDescriptor classDescriptor, boolean inCode) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        PsiElement element3 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)classDescriptor);
        return element3 instanceof PsiClass ? RenderingUtilsKt.formatPsiClass((PsiClass)element3, false, inCode) : RenderingUtilsKt.wrapOrSkip(RenderingUtilsKt.formatClassDescriptor(classDescriptor), inCode);
    }

    @NotNull
    public static final String formatFunction(@NotNull DeclarationDescriptor functionDescriptor2, boolean inCode) {
        Intrinsics.checkNotNullParameter((Object)functionDescriptor2, (String)"functionDescriptor");
        PsiElement element3 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)functionDescriptor2);
        return element3 instanceof PsiMethod ? RenderingUtilsKt.formatPsiMethod((PsiMethod)element3, false, inCode) : RenderingUtilsKt.wrapOrSkip(RenderingUtilsKt.formatFunctionDescriptor(functionDescriptor2), inCode);
    }

    private static final String formatFunctionDescriptor(DeclarationDescriptor functionDescriptor2) {
        return FUNCTION_RENDERER.render(functionDescriptor2);
    }

    @NotNull
    public static final String formatPsiMethod(@NotNull PsiMethod psiMethod, boolean showContainingClass, boolean inCode) {
        String description2;
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        int options2 = 259;
        if (showContainingClass) {
            options2 |= 0x1000;
        }
        String string = description2 = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options2, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"description");
        description2 = RenderingUtilsKt.wrapOrSkip(string, inCode);
        return "[Java] " + description2;
    }

    @NotNull
    public static final String formatJavaOrLightMethod(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiElement originalDeclaration = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)method));
        return originalDeclaration instanceof KtDeclaration ? RenderingUtilsKt.formatFunctionDescriptor(ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)originalDeclaration, null, 1, null)) : RenderingUtilsKt.formatPsiMethod(method, false, false);
    }

    @NotNull
    public static final String formatClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)classOrObject, null, 1, null);
        if (declarationDescriptor == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return RenderingUtilsKt.formatClassDescriptor((DeclarationDescriptor)((ClassDescriptor)declarationDescriptor));
    }
}

