/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.utils;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/grazie/nlp/utils/CharUtils;", "", "()V", "controlChars", "", "Lkotlin/text/CharCategory;", "punctuationChars", "isControl", "", "char", "", "isPunctuation", "nlp-common"})
public final class CharUtils {
    private static final Set<CharCategory> controlChars;
    private static final Set<CharCategory> punctuationChars;
    @NotNull
    public static final CharUtils INSTANCE;

    public final boolean isPunctuation(char c) {
        block5: {
            block4: {
                if (punctuationChars.contains(CharsKt.getCategory((char)c))) {
                    return true;
                }
                char c2 = c;
                if ('!' <= c2 && '/' >= c2) break block4;
                c2 = c;
                if (':' <= c2 && '@' >= c2) break block4;
                c2 = c;
                if ('[' <= c2 && '`' >= c2) break block4;
                c2 = c;
                if ('{' > c2 || '~' < c2) break block5;
            }
            return true;
        }
        return false;
    }

    public final boolean isControl(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return false;
        }
        return controlChars.contains(CharsKt.getCategory((char)c));
    }

    private CharUtils() {
    }

    static {
        CharUtils charUtils;
        INSTANCE = charUtils = new CharUtils();
        controlChars = SetsKt.setOf((Object[])new CharCategory[]{CharCategory.UNASSIGNED, CharCategory.CONTROL, CharCategory.FORMAT, CharCategory.PRIVATE_USE, CharCategory.SURROGATE});
        punctuationChars = SetsKt.setOf((Object[])new CharCategory[]{CharCategory.DASH_PUNCTUATION, CharCategory.CONNECTOR_PUNCTUATION, CharCategory.END_PUNCTUATION, CharCategory.START_PUNCTUATION, CharCategory.OTHER_PUNCTUATION});
    }
}

