/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ObjectIntHashMap;

public class ObjectIntScatterMap<KType>
extends ObjectIntHashMap<KType> {
    public ObjectIntScatterMap() {
        this(4);
    }

    public ObjectIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType> ObjectIntScatterMap<KType> from(KType[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectIntScatterMap<KType> map2 = new ObjectIntScatterMap<KType>(keys.length);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            map2.put(keys[i2], values[i2]);
        }
        return map2;
    }
}

