/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.remote;

import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.GraziePlugin;
import com.intellij.grazie.ide.notification.GrazieToastNotifications;
import com.intellij.grazie.ide.ui.components.dsl.SwingKTKt;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.remote.GrazieRemote;
import com.intellij.grazie.remote.LangDownloader;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/remote/LangDownloader;", "", "()V", "doDownload", "", "Ljava/nio/file/Path;", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "presentableName", "", "Lorg/jetbrains/annotations/Nls;", "download", "", "project", "Lcom/intellij/openapi/project/Project;", "runDownload", "intellij.grazie.core"})
public final class LangDownloader {
    @NotNull
    public static final LangDownloader INSTANCE;

    public final boolean download(@NotNull Lang lang, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        if (GrazieRemote.INSTANCE.isAvailableLocally(lang)) {
            return true;
        }
        List<Path> result = this.runDownload(lang, project);
        Collection collection = result;
        if (!(collection == null || collection.isEmpty())) {
            UrlClassLoader urlClassLoader = UrlClassLoader.build().parent(GraziePlugin.INSTANCE.getClassLoader()).files(result).get();
            Intrinsics.checkNotNullExpressionValue((Object)urlClassLoader, (String)"UrlClassLoader.build().p\u2026     .files(result).get()");
            UrlClassLoader classLoader = urlClassLoader;
            GrazieDynamic.INSTANCE.addDynClassLoader((ClassLoader)classLoader);
            GrazieConfig.Companion.update((Function1<? super GrazieConfig.State, GrazieConfig.State>)((Function1)download.1.INSTANCE));
            GrazieConfig.Companion.stateChanged(GrazieConfig.Companion.get(), GrazieConfig.Companion.get());
            return true;
        }
        return false;
    }

    private final List<Path> runDownload(Lang lang, Project project) {
        try {
            String presentableName = SwingKTKt.msg("grazie.settings.proofreading.languages.download.name", lang.getNativeName());
            return (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(lang, presentableName){
                final /* synthetic */ Lang $lang;
                final /* synthetic */ String $presentableName;

                public final List<Path> compute() {
                    return LangDownloader.access$doDownload(LangDownloader.INSTANCE, this.$lang, this.$presentableName);
                }
                {
                    this.$lang = lang;
                    this.$presentableName = string;
                }
            }, presentableName, false, project);
        }
        catch (Throwable exception) {
            LangDownloader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LangDownloader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error(exception);
            Notification notification = GrazieToastNotifications.INSTANCE.getMISSED_LANGUAGES_GROUP$intellij_grazie_core().createNotification(SwingKTKt.msg("grazie.notification.missing-languages.download.failed.message", lang.getNativeName()), NotificationType.ERROR);
            notification.notify(project);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> doDownload(Lang lang, String presentableName) {
        void $this$mapTo$iv$iv;
        DownloadableFileService downloaderService = DownloadableFileService.getInstance();
        FileDownloader fileDownloader = downloaderService.createDownloader(CollectionsKt.listOf((Object)downloaderService.createFileDescription(lang.getRemote().getUrl(), lang.getRemote().getFileName())), presentableName);
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"downloaderService.create\u2026    presentableName\n    )");
        FileDownloader downloader = fileDownloader;
        List list = downloader.download(GrazieDynamic.INSTANCE.getDynamicFolder().toFile());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"downloader.download(Graz\u2026c.dynamicFolder.toFile())");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = ((File)it.first).toPath();
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    private LangDownloader() {
    }

    static {
        LangDownloader langDownloader;
        INSTANCE = langDownloader = new LangDownloader();
    }

    public static final /* synthetic */ List access$doDownload(LangDownloader $this, Lang lang, String presentableName) {
        return $this.doDownload(lang, presentableName);
    }
}

