/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.languagetool.languagemodel.BaseLanguageModel;
import org.languagetool.languagemodel.LuceneSingleIndexLanguageModel;

public class LuceneLanguageModel
extends BaseLanguageModel {
    private final List<LuceneSingleIndexLanguageModel> lms = new ArrayList<LuceneSingleIndexLanguageModel>();

    public static void validateDirectory(File topIndexDir) {
        File[] subDirs = LuceneLanguageModel.getSubDirectoriesOrNull(topIndexDir);
        if (subDirs == null || subDirs.length == 0) {
            LuceneSingleIndexLanguageModel.validateDirectory(topIndexDir);
        }
    }

    @Nullable
    private static File[] getSubDirectoriesOrNull(File topIndexDir) {
        return topIndexDir.listFiles((file2, name) -> name.matches("index-\\d+"));
    }

    public LuceneLanguageModel(File topIndexDir) {
        File[] subDirs = LuceneLanguageModel.getSubDirectoriesOrNull(topIndexDir);
        if (subDirs != null && subDirs.length > 0) {
            System.out.println("Running in multi-index mode with " + subDirs.length + " indexes: " + topIndexDir);
            for (File subDir : subDirs) {
                this.lms.add(new LuceneSingleIndexLanguageModel(subDir));
            }
        } else {
            this.lms.add(new LuceneSingleIndexLanguageModel(topIndexDir));
        }
    }

    @Override
    public long getCount(List<String> tokens) {
        return this.lms.stream().mapToLong(lm -> lm.getCount(tokens)).sum();
    }

    @Override
    public long getCount(String token) {
        return this.getCount(Arrays.asList(token));
    }

    @Override
    public long getTotalTokenCount() {
        return this.lms.stream().mapToLong(lm -> lm.getTotalTokenCount()).sum();
    }

    @Override
    public void close() {
        this.lms.forEach(lm -> lm.close());
    }

    public String toString() {
        return this.lms.toString();
    }
}

