/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.ListenerDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.NamedTest;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.SingleTestClass;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestClasses;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestExecutionContext;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestRequest;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestResultFormatter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.KeepAliveOutputStream;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class JUnitLauncherTask
extends Task {
    private Path classPath;
    private boolean haltOnFailure;
    private String failureProperty;
    private boolean printSummary;
    private final List<TestDefinition> tests = new ArrayList<TestDefinition>();
    private final List<ListenerDefinition> listeners = new ArrayList<ListenerDefinition>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader executionCL = this.createClassLoaderForTestExecution();
            Thread.currentThread().setContextClassLoader(executionCL);
            Launcher launcher = LauncherFactory.create();
            List<TestRequest> requests = this.buildTestRequests();
            for (TestRequest testRequest : requests) {
                try {
                    TestDefinition test = testRequest.getOwner();
                    LauncherDiscoveryRequest request = testRequest.getDiscoveryRequest().build();
                    ArrayList<Listener> testExecutionListeners = new ArrayList<Listener>();
                    Listener firstListener = new Listener();
                    testExecutionListeners.add(firstListener);
                    testExecutionListeners.addAll(this.getListeners(testRequest, executionCL));
                    PrintStream originalSysOut = System.out;
                    PrintStream originalSysErr = System.err;
                    try {
                        firstListener.switchedSysOutHandle = this.trySwitchSysOutErr(testRequest, StreamType.SYS_OUT);
                        firstListener.switchedSysErrHandle = this.trySwitchSysOutErr(testRequest, StreamType.SYS_ERR);
                        launcher.execute(request, testExecutionListeners.toArray(new TestExecutionListener[testExecutionListeners.size()]));
                    }
                    finally {
                        try {
                            System.setOut(originalSysOut);
                        }
                        catch (Exception exception) {}
                        try {
                            System.setErr(originalSysErr);
                        }
                        catch (Exception exception) {}
                    }
                    this.handleTestExecutionCompletion(test, firstListener.getSummary());
                }
                finally {
                    try {
                        testRequest.close();
                    }
                    catch (Exception e) {
                        this.log("Failed to cleanly close test request", e, 4);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }

    public void addConfiguredClassPath(Path path) {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        this.classPath.add(path);
    }

    public void addConfiguredTest(SingleTestClass test) {
        this.preConfigure(test);
        this.tests.add(test);
    }

    public void addConfiguredTestClasses(TestClasses testClasses) {
        this.preConfigure(testClasses);
        this.tests.add(testClasses);
    }

    public void addConfiguredListener(ListenerDefinition listener) {
        this.listeners.add(listener);
    }

    public void setHaltonfailure(boolean haltonfailure) {
        this.haltOnFailure = haltonfailure;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    private void preConfigure(TestDefinition test) {
        if (test.getHaltOnFailure() == null) {
            test.setHaltOnFailure(this.haltOnFailure);
        }
        if (test.getFailureProperty() == null) {
            test.setFailureProperty(this.failureProperty);
        }
    }

    private List<TestRequest> buildTestRequests() {
        if (this.tests.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TestRequest> requests = new ArrayList<TestRequest>();
        for (TestDefinition test : this.tests) {
            List<TestRequest> testRequests = test.createTestRequests(this);
            if (testRequests == null || testRequests.isEmpty()) continue;
            requests.addAll(testRequests);
        }
        return requests;
    }

    private List<TestExecutionListener> getListeners(TestRequest testRequest, ClassLoader classLoader) {
        TestDefinition test = testRequest.getOwner();
        List<ListenerDefinition> applicableListenerElements = test.getListeners().isEmpty() ? this.listeners : test.getListeners();
        ArrayList<TestExecutionListener> listeners = new ArrayList<TestExecutionListener>();
        Project project = this.getProject();
        for (ListenerDefinition applicableListener : applicableListenerElements) {
            if (!applicableListener.shouldUse(project)) {
                this.log("Excluding listener " + applicableListener.getClassName() + " since it's not applicable in the context of project " + project, 4);
                continue;
            }
            TestExecutionListener listener = this.requireTestExecutionListener(applicableListener, classLoader);
            if (listener instanceof TestResultFormatter) {
                this.setupResultFormatter(testRequest, applicableListener, (TestResultFormatter)listener);
            }
            listeners.add(listener);
        }
        return listeners;
    }

    private void setupResultFormatter(TestRequest testRequest, ListenerDefinition formatterDefinition, TestResultFormatter resultFormatter) {
        testRequest.closeUponCompletion(resultFormatter);
        resultFormatter.setContext(new InVMExecution());
        TestDefinition test = testRequest.getOwner();
        java.nio.file.Path outputDir = test.getOutputDir() != null ? Paths.get(test.getOutputDir(), new String[0]) : this.getProject().getBaseDir().toPath();
        String filename = formatterDefinition.requireResultFile(test);
        java.nio.file.Path resultOutputFile = Paths.get(outputDir.toString(), filename);
        try {
            OutputStream resultOutputStream = Files.newOutputStream(resultOutputFile, new OpenOption[0]);
            testRequest.closeUponCompletion(resultOutputStream);
            resultFormatter.setDestination(new KeepAliveOutputStream(resultOutputStream));
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        if (formatterDefinition.shouldSendSysOut()) {
            testRequest.addSysOutInterest(resultFormatter);
        }
        if (formatterDefinition.shouldSendSysErr()) {
            testRequest.addSysErrInterest(resultFormatter);
        }
    }

    private TestExecutionListener requireTestExecutionListener(ListenerDefinition listener, ClassLoader classLoader) {
        Class<?> klass;
        String className = listener.getClassName();
        if (className == null || className.trim().isEmpty()) {
            throw new BuildException("classname attribute value is missing on listener element");
        }
        try {
            klass = Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Failed to load listener class " + className, e);
        }
        if (!TestExecutionListener.class.isAssignableFrom(klass)) {
            throw new BuildException("Listener class " + className + " is not of type " + TestExecutionListener.class.getName());
        }
        try {
            return (TestExecutionListener)TestExecutionListener.class.cast(klass.newInstance());
        }
        catch (Exception e) {
            throw new BuildException("Failed to create an instance of listener " + className, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTestExecutionCompletion(TestDefinition test, TestExecutionSummary summary) {
        if (this.printSummary) {
            summary.printTo(new PrintWriter(System.out, true));
        }
        boolean hasTestFailures = summary.getTestsFailedCount() != 0L;
        try {
            if (hasTestFailures && test.getFailureProperty() != null) {
                this.getProject().setNewProperty(test.getFailureProperty(), "true");
            }
        }
        finally {
            if (hasTestFailures && test.isHaltOnFailure()) {
                String errorMessage = test instanceof NamedTest ? "Test " + ((NamedTest)((Object)test)).getName() + " has " + summary.getTestsFailedCount() + " failure(s)" : "Some test(s) have failure(s)";
                throw new BuildException(errorMessage);
            }
        }
    }

    private ClassLoader createClassLoaderForTestExecution() {
        if (this.classPath == null) {
            return this.getClass().getClassLoader();
        }
        return new AntClassLoader(this.getClass().getClassLoader(), this.getProject(), this.classPath, true);
    }

    private Optional<SwitchedStreamHandle> trySwitchSysOutErr(TestRequest testRequest, StreamType streamType) {
        SysOutErrStreamReader streamer;
        PipedInputStream pipedInputStream;
        switch (streamType) {
            case SYS_OUT: {
                if (testRequest.interestedInSysOut()) break;
                return Optional.empty();
            }
            case SYS_ERR: {
                if (testRequest.interestedInSysErr()) break;
                return Optional.empty();
            }
            default: {
                return Optional.empty();
            }
        }
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        try {
            pipedInputStream = new PipedInputStream(pipedOutputStream);
        }
        catch (IOException ioe) {
            return Optional.empty();
        }
        PrintStream printStream = new PrintStream(pipedOutputStream, true);
        switch (streamType) {
            case SYS_OUT: {
                System.setOut(new PrintStream(printStream));
                streamer = new SysOutErrStreamReader(this, pipedInputStream, StreamType.SYS_OUT, testRequest.getSysOutInterests());
                Thread sysOutStreamer = new Thread(streamer);
                sysOutStreamer.setDaemon(true);
                sysOutStreamer.setName("junitlauncher-sysout-stream-reader");
                sysOutStreamer.setUncaughtExceptionHandler((t, e) -> this.log("Failed in sysout streaming", e, 2));
                sysOutStreamer.start();
                break;
            }
            case SYS_ERR: {
                System.setErr(new PrintStream(printStream));
                streamer = new SysOutErrStreamReader(this, pipedInputStream, StreamType.SYS_ERR, testRequest.getSysErrInterests());
                Thread sysErrStreamer = new Thread(streamer);
                sysErrStreamer.setDaemon(true);
                sysErrStreamer.setName("junitlauncher-syserr-stream-reader");
                sysErrStreamer.setUncaughtExceptionHandler((t, e) -> this.log("Failed in syserr streaming", e, 2));
                sysErrStreamer.start();
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        return Optional.of(new SwitchedStreamHandle(pipedOutputStream, streamer));
    }

    private final class InVMExecution
    implements TestExecutionContext {
        private final Properties props = new Properties();

        InVMExecution() {
            this.props.putAll((Map<?, ?>)JUnitLauncherTask.this.getProject().getProperties());
        }

        @Override
        public Properties getProperties() {
            return this.props;
        }

        @Override
        public Optional<Project> getProject() {
            return Optional.of(JUnitLauncherTask.this.getProject());
        }
    }

    private final class Listener
    extends SummaryGeneratingListener {
        private Optional<SwitchedStreamHandle> switchedSysOutHandle;
        private Optional<SwitchedStreamHandle> switchedSysErrHandle;

        private Listener() {
        }

        public void testPlanExecutionFinished(TestPlan testPlan) {
            super.testPlanExecutionFinished(testPlan);
            if (this.switchedSysOutHandle.isPresent()) {
                SwitchedStreamHandle sysOut = this.switchedSysOutHandle.get();
                try {
                    this.closeAndWait(sysOut);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.switchedSysErrHandle.isPresent()) {
                SwitchedStreamHandle sysErr = this.switchedSysErrHandle.get();
                try {
                    this.closeAndWait(sysErr);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void closeAndWait(SwitchedStreamHandle handle) throws InterruptedException {
            FileUtils.close(handle.outputStream);
            if (handle.streamReader.contentDeliverer == null) {
                return;
            }
            handle.streamReader.contentDeliverer.completionLatch.await(2L, TimeUnit.SECONDS);
        }
    }

    private final class SwitchedStreamHandle {
        private final PipedOutputStream outputStream;
        private final SysOutErrStreamReader streamReader;

        SwitchedStreamHandle(PipedOutputStream outputStream, SysOutErrStreamReader streamReader) {
            this.streamReader = streamReader;
            this.outputStream = outputStream;
        }
    }

    private static final class SysOutErrContentDeliverer
    implements Runnable {
        private volatile boolean stop;
        private final Collection<TestResultFormatter> resultFormatters;
        private final StreamType streamType;
        private final BlockingQueue<byte[]> availableData = new LinkedBlockingQueue<byte[]>();
        private final CountDownLatch completionLatch = new CountDownLatch(1);

        SysOutErrContentDeliverer(StreamType streamType, Collection<TestResultFormatter> resultFormatters) {
            this.streamType = streamType;
            this.resultFormatters = resultFormatters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.stop) {
                    byte[] streamData;
                    try {
                        streamData = this.availableData.poll(2L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.completionLatch.countDown();
                        return;
                    }
                    if (streamData == null) continue;
                    this.deliver(streamData);
                }
                ArrayList remaining = new ArrayList();
                this.availableData.drainTo(remaining);
                if (!remaining.isEmpty()) {
                    for (byte[] data : remaining) {
                        this.deliver(data);
                    }
                }
            }
            finally {
                this.completionLatch.countDown();
            }
        }

        private void deliver(byte[] data) {
            if (data == null || data.length == 0) {
                return;
            }
            for (TestResultFormatter resultFormatter : this.resultFormatters) {
                switch (this.streamType) {
                    case SYS_OUT: {
                        resultFormatter.sysOutAvailable(data);
                        break;
                    }
                    case SYS_ERR: {
                        resultFormatter.sysErrAvailable(data);
                    }
                }
            }
        }
    }

    private static final class SysOutErrStreamReader
    implements Runnable {
        private static final byte[] EMPTY = new byte[0];
        private final JUnitLauncherTask task;
        private final InputStream sourceStream;
        private final StreamType streamType;
        private final Collection<TestResultFormatter> resultFormatters;
        private volatile SysOutErrContentDeliverer contentDeliverer;

        SysOutErrStreamReader(JUnitLauncherTask task, InputStream source, StreamType streamType, Collection<TestResultFormatter> resultFormatters) {
            this.task = task;
            this.sourceStream = source;
            this.streamType = streamType;
            this.resultFormatters = resultFormatters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SysOutErrContentDeliverer streamContentDeliver = new SysOutErrContentDeliverer(this.streamType, this.resultFormatters);
            Thread deliveryThread = new Thread(streamContentDeliver);
            deliveryThread.setName("junitlauncher-" + (this.streamType == StreamType.SYS_OUT ? "sysout" : "syserr") + "-stream-deliverer");
            deliveryThread.setDaemon(true);
            deliveryThread.start();
            this.contentDeliverer = streamContentDeliver;
            int numRead = -1;
            byte[] data = new byte[1024];
            try {
                while ((numRead = this.sourceStream.read(data)) != -1) {
                    byte[] copy = Arrays.copyOf(data, numRead);
                    streamContentDeliver.availableData.offer(copy);
                }
            }
            catch (IOException e) {
                this.task.log("Failed while streaming " + (this.streamType == StreamType.SYS_OUT ? "sysout" : "syserr") + " data", e, 2);
            }
            finally {
                streamContentDeliver.stop = true;
                streamContentDeliver.availableData.offer(EMPTY);
            }
        }
    }

    private static enum StreamType {
        SYS_OUT,
        SYS_ERR;

    }
}

