/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.externalSystem.util.environment.Environment;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.util.GradleProperties;
import org.jetbrains.plugins.gradle.util.GradlePropertiesImpl;
import org.jetbrains.plugins.gradle.util.GradlePropertiesUtil;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\n\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\n\u001a\u0018\u0010\u000e\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\n\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\nH\u0002\u001a \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\nH\u0002\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"GRADLE_CACHE_DIR_NAME", "", "GRADLE_JAVA_HOME_PROPERTY", "GRADLE_LOGGING_LEVEL_PROPERTY", "PROPERTIES_FILE_NAME", "USER_HOME", "findAndMergeProperties", "Lorg/jetbrains/plugins/gradle/util/GradleProperties;", "possiblePropertiesFiles", "", "Ljava/nio/file/Path;", "getGradleHomePropertiesPath", "getGradleProjectPropertiesPath", "externalProjectPath", "getGradleProperties", "project", "Lcom/intellij/openapi/project/Project;", "serviceDirectoryStr", "getGradleServiceDirectoryPath", "getPossiblePropertiesFiles", "loadGradleProperties", "propertiesPath", "loadProperties", "Ljava/util/Properties;", "propertiesFile", "mergeGradleProperties", "most", "other", "intellij.gradle.common"})
@JvmName(name="GradlePropertiesUtil")
public final class GradlePropertiesUtil {
    @NotNull
    public static final String USER_HOME = "user.home";
    @NotNull
    public static final String GRADLE_CACHE_DIR_NAME = ".gradle";
    @NotNull
    public static final String PROPERTIES_FILE_NAME = "gradle.properties";
    @NotNull
    public static final String GRADLE_JAVA_HOME_PROPERTY = "org.gradle.java.home";
    @NotNull
    public static final String GRADLE_LOGGING_LEVEL_PROPERTY = "org.gradle.logging.level";

    @NotNull
    public static final GradleProperties getGradleProperties(@NotNull Project project, @NotNull Path externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        return GradlePropertiesUtil.findAndMergeProperties(GradlePropertiesUtil.getPossiblePropertiesFiles(project, externalProjectPath2));
    }

    @NotNull
    public static final GradleProperties getGradleProperties(@Nullable String serviceDirectoryStr, @NotNull Path externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        return GradlePropertiesUtil.findAndMergeProperties(GradlePropertiesUtil.getPossiblePropertiesFiles(serviceDirectoryStr, externalProjectPath2));
    }

    /*
     * WARNING - void declaration
     */
    private static final GradleProperties findAndMergeProperties(List<? extends Path> possiblePropertiesFiles) {
        Sequence $this$reduce$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)possiblePropertiesFiles), (Function1)findAndMergeProperties.1.INSTANCE), (Function1)findAndMergeProperties.2.INSTANCE);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p2;
            GradleProperties gradleProperties = (GradleProperties)iterator$iv.next();
            GradleProperties p1 = (GradleProperties)accumulator$iv;
            boolean bl = false;
            accumulator$iv = GradlePropertiesUtil.mergeGradleProperties(p1, (GradleProperties)p2);
        }
        return (GradleProperties)accumulator$iv;
    }

    private static final List<Path> getPossiblePropertiesFiles(Project project, Path externalProjectPath2) {
        return CollectionsKt.listOfNotNull((Object[])new Path[]{GradlePropertiesUtil.getGradleServiceDirectoryPath(project), GradlePropertiesUtil.getGradleHomePropertiesPath(), GradlePropertiesUtil.getGradleProjectPropertiesPath(externalProjectPath2)});
    }

    private static final List<Path> getPossiblePropertiesFiles(String serviceDirectoryStr, Path externalProjectPath2) {
        return CollectionsKt.listOfNotNull((Object[])new Path[]{GradlePropertiesUtil.getGradleServiceDirectoryPath(serviceDirectoryStr), GradlePropertiesUtil.getGradleHomePropertiesPath(), GradlePropertiesUtil.getGradleProjectPropertiesPath(externalProjectPath2)});
    }

    private static final Path getGradleServiceDirectoryPath(Project project) {
        GradleLocalSettings gradleLocalSettings = GradleLocalSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleLocalSettings), (String)"GradleLocalSettings.getInstance(project)");
        String string2 = gradleLocalSettings.getGradleUserHome();
        if (string2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GradleLocalSettings.getI\u2026leUserHome ?: return null");
        String gradleUserHome2 = string2;
        return Paths.get(gradleUserHome2, PROPERTIES_FILE_NAME);
    }

    private static final Path getGradleServiceDirectoryPath(String serviceDirectoryStr) {
        Path path;
        String string2 = serviceDirectoryStr;
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            path = Paths.get(serviceDirectoryStr, PROPERTIES_FILE_NAME);
        } else {
            path = null;
        }
        return path;
    }

    private static final Path getGradleHomePropertiesPath() {
        String gradleUserHome2 = Environment.Companion.getVariable("GRADLE_USER_HOME");
        if (gradleUserHome2 != null) {
            return Paths.get(gradleUserHome2, PROPERTIES_FILE_NAME);
        }
        String userHome = Environment.Companion.getProperty(USER_HOME);
        if (userHome != null) {
            return Paths.get(userHome, GRADLE_CACHE_DIR_NAME, PROPERTIES_FILE_NAME);
        }
        return null;
    }

    private static final Path getGradleProjectPropertiesPath(Path externalProjectPath2) {
        Path path = externalProjectPath2.resolve(PROPERTIES_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"externalProjectPath.resolve(PROPERTIES_FILE_NAME)");
        return path;
    }

    private static final GradleProperties loadGradleProperties(Path propertiesPath) {
        GradleProperties.GradleProperty<String> gradleProperty;
        String logLevel;
        GradleProperties.GradleProperty<String> gradleProperty2;
        String javaHome;
        Properties properties = GradlePropertiesUtil.loadProperties(propertiesPath);
        if (properties == null) {
            return GradleProperties.EMPTY.INSTANCE;
        }
        Properties properties2 = properties;
        String string2 = javaHome = properties2.getProperty(GRADLE_JAVA_HOME_PROPERTY);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            gradleProperty2 = new GradleProperties.GradleProperty<String>(it, ((Object)propertiesPath).toString());
        } else {
            gradleProperty2 = null;
        }
        GradleProperties.GradleProperty<String> javaHomeProperty = gradleProperty2;
        String string4 = logLevel = properties2.getProperty(GRADLE_LOGGING_LEVEL_PROPERTY);
        if (string4 != null) {
            String string5;
            String it = string5 = string4;
            boolean bl = false;
            gradleProperty = new GradleProperties.GradleProperty<String>(it, ((Object)propertiesPath).toString());
        } else {
            gradleProperty = null;
        }
        GradleProperties.GradleProperty<String> logLevelProperty = gradleProperty;
        return new GradlePropertiesImpl(javaHomeProperty, logLevelProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties loadProperties(Path propertiesFile) {
        if (!PathKt.isFile((Path)propertiesFile) || !PathKt.exists((Path)propertiesFile)) {
            return null;
        }
        Properties properties = new Properties();
        try {
            Closeable closeable = PathKt.inputStream((Path)propertiesFile);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                properties.load(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return properties;
    }

    private static final GradleProperties mergeGradleProperties(GradleProperties most, GradleProperties other) {
        GradleProperties gradleProperties;
        if (most instanceof GradleProperties.EMPTY) {
            gradleProperties = other;
        } else if (other instanceof GradleProperties.EMPTY) {
            gradleProperties = most;
        } else {
            GradleProperties.GradleProperty<String> gradleProperty;
            GradleProperties.GradleProperty<String> gradleProperty2 = most.getJavaHomeProperty();
            if (gradleProperty2 == null) {
                gradleProperty2 = other.getJavaHomeProperty();
            }
            if ((gradleProperty = most.getGradleLoggingLevel()) == null) {
                gradleProperty = other.getGradleLoggingLevel();
            }
            gradleProperties = new GradlePropertiesImpl(gradleProperty2, gradleProperty);
        }
        return gradleProperties;
    }

    public static final /* synthetic */ GradleProperties access$loadGradleProperties(Path propertiesPath) {
        return GradlePropertiesUtil.loadGradleProperties(propertiesPath);
    }
}

