/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.metadata;

import java.lang.ref.SoftReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.metadata.KlibMetadataPackageFragment;
import org.jetbrains.kotlin.library.metadata.PackageAccessHandler;
import org.jetbrains.kotlin.library.metadata.SimplePackageAccessHandler;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/library/metadata/KlibMetadataDeserializedPackageFragment;", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataPackageFragment;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "packageAccessHandler", "Lorg/jetbrains/kotlin/library/metadata/PackageAccessHandler;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "partName", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/library/KotlinLibrary;Lorg/jetbrains/kotlin/library/metadata/PackageAccessHandler;Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/lang/String;)V", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "getProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "protoForNames", "getProtoForNames", "protoForNamesStorage", "Ljava/lang/ref/SoftReference;", "ensureStorage", "kotlin-util-klib-metadata"})
public class KlibMetadataDeserializedPackageFragment
extends KlibMetadataPackageFragment {
    @NotNull
    private final KotlinLibrary library;
    @Nullable
    private final PackageAccessHandler packageAccessHandler;
    @NotNull
    private final String partName;
    @NotNull
    private SoftReference<ProtoBuf.PackageFragment> protoForNamesStorage;

    public KlibMetadataDeserializedPackageFragment(@NotNull FqName fqName2, @NotNull KotlinLibrary library, @Nullable PackageAccessHandler packageAccessHandler, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor module, @NotNull String partName) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
        super(fqName2, storageManager, module);
        this.library = library;
        this.packageAccessHandler = packageAccessHandler;
        this.partName = partName;
        this.protoForNamesStorage = new SoftReference<Object>(null);
    }

    @Override
    @NotNull
    public ProtoBuf.PackageFragment getProtoForNames() {
        return this.ensureStorage();
    }

    private final ProtoBuf.PackageFragment ensureStorage() {
        ProtoBuf.PackageFragment tmp = this.protoForNamesStorage.get();
        if (tmp == null) {
            PackageAccessHandler packageAccessHandler = this.packageAccessHandler;
            if (packageAccessHandler == null) {
                packageAccessHandler = SimplePackageAccessHandler.INSTANCE;
            }
            String string2 = this.getFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.asString()");
            tmp = packageAccessHandler.loadPackageFragment(this.library, string2, this.partName);
            this.protoForNamesStorage = new SoftReference<ProtoBuf.PackageFragment>(tmp);
        }
        return tmp;
    }

    @Override
    @NotNull
    public ProtoBuf.PackageFragment getProto() {
        block0: {
            PackageAccessHandler packageAccessHandler = this.packageAccessHandler;
            if (packageAccessHandler == null) break block0;
            String string2 = this.getFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.asString()");
            packageAccessHandler.markNeededForLink(this.library, string2);
        }
        return this.getProtoForNames();
    }
}

