/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.List;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceLocator;
import org.gradle.internal.service.ServiceRegistry;

public class DependencyInjectingServiceLoader {
    private final ServiceRegistry serviceRegistry;

    public DependencyInjectingServiceLoader(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public <T> Iterable<T> load(Class<T> serviceType, ClassLoader classLoader) {
        final Instantiator instantiator = this.dependencyInjectingInstantiator();
        return Iterables.transform(this.implementationsOf(serviceType, classLoader), (Function)new Function<Class<? extends T>, T>(){

            public T apply(Class<? extends T> serviceImplementation) {
                return instantiator.newInstance(serviceImplementation, new Object[0]);
            }
        });
    }

    private <T> List<Class<? extends T>> implementationsOf(Class<T> serviceType, ClassLoader classLoader) {
        return new DefaultServiceLocator(classLoader).implementationsOf(serviceType);
    }

    private Instantiator dependencyInjectingInstantiator() {
        return this.serviceRegistry.get(InstantiatorFactory.class).inject(this.serviceRegistry);
    }
}

