/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependenciesMetadata;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.repositories.resolver.AbstractDependencyImpl;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public abstract class AbstractDependenciesMetadataAdapter<T extends DependencyMetadata<T>>
extends AbstractList<T>
implements DependenciesMetadata<T> {
    private final List<org.gradle.internal.component.model.DependencyMetadata> dependenciesMetadata;
    protected final Map<Integer, T> dependencyMetadataAdapters;
    private final Instantiator instantiator;
    private final NotationParser<Object, T> dependencyNotationParser;
    private final ImmutableAttributesFactory attributesFactory;

    public AbstractDependenciesMetadataAdapter(ImmutableAttributesFactory attributesFactory, List<org.gradle.internal.component.model.DependencyMetadata> dependenciesMetadata, Instantiator instantiator, NotationParser<Object, T> dependencyNotationParser) {
        this.attributesFactory = attributesFactory;
        this.dependenciesMetadata = dependenciesMetadata;
        this.dependencyMetadataAdapters = Maps.newHashMap();
        this.instantiator = instantiator;
        this.dependencyNotationParser = dependencyNotationParser;
    }

    protected abstract Class<? extends T> adapterImplementationType();

    protected abstract boolean isConstraint();

    protected abstract boolean isEndorsingStrictVersions(T var1);

    @Override
    public T get(int index) {
        if (!this.dependencyMetadataAdapters.containsKey(index)) {
            this.dependencyMetadataAdapters.put(index, (DependencyMetadata)this.instantiator.newInstance(this.adapterImplementationType(), this.attributesFactory, this.dependenciesMetadata, index));
        }
        return (T)((DependencyMetadata)this.dependencyMetadataAdapters.get(index));
    }

    @Override
    public int size() {
        return this.dependenciesMetadata.size();
    }

    @Override
    public T remove(int index) {
        Object componentDependencyMetadata = this.get(index);
        this.dependenciesMetadata.remove(index);
        this.dependencyMetadataAdapters.remove(index);
        return (T)componentDependencyMetadata;
    }

    @Override
    public void add(String dependencyNotation) {
        this.doAdd(dependencyNotation, null);
    }

    @Override
    public void add(Map<String, String> dependencyNotation) {
        this.doAdd(dependencyNotation, null);
    }

    @Override
    public void add(String dependencyNotation, Action<? super T> configureAction) {
        this.doAdd(dependencyNotation, configureAction);
    }

    @Override
    public void add(Map<String, String> dependencyNotation, Action<? super T> configureAction) {
        this.doAdd(dependencyNotation, configureAction);
    }

    private void doAdd(Object dependencyNotation, @Nullable Action<? super T> configureAction) {
        DependencyMetadata dependencyMetadata = (DependencyMetadata)this.dependencyNotationParser.parseNotation(dependencyNotation);
        if (dependencyMetadata instanceof AbstractDependencyImpl) {
            ((AbstractDependencyImpl)dependencyMetadata).setAttributes(this.attributesFactory.mutable());
        }
        if (configureAction != null) {
            configureAction.execute(dependencyMetadata);
        }
        this.dependenciesMetadata.add(this.toDependencyMetadata(dependencyMetadata));
    }

    private org.gradle.internal.component.model.DependencyMetadata toDependencyMetadata(T details) {
        ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(details.getModule(), DefaultImmutableVersionConstraint.of(details.getVersionConstraint()), details.getAttributes(), (Collection<Capability>)ImmutableList.of());
        return new GradleDependencyMetadata(selector, Collections.emptyList(), this.isConstraint(), this.isEndorsingStrictVersions(details), details.getReason(), false, null);
    }
}

