/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.file.pattern.PatternStep;

public class RegExpPatternStep
implements PatternStep {
    private static final String ESCAPE_CHARS = "\\[]^-&.{}()$+|<=!";
    private final Pattern pattern;

    public RegExpPatternStep(String pattern, boolean caseSensitive) {
        this.pattern = Pattern.compile(RegExpPatternStep.getRegExPattern(pattern), caseSensitive ? 0 : 2);
    }

    public String toString() {
        return "{regexp: " + this.pattern + "}";
    }

    protected static String getRegExPattern(String pattern) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char next = pattern.charAt(i);
            if (next == '*') {
                result2.append(".*");
                continue;
            }
            if (next == '?') {
                result2.append(".");
                continue;
            }
            if (ESCAPE_CHARS.indexOf(next) >= 0) {
                result2.append('\\');
                result2.append(next);
                continue;
            }
            result2.append(next);
        }
        return result2.toString();
    }

    @Override
    public boolean matches(String testString) {
        Matcher matcher = this.pattern.matcher(testString);
        return matcher.matches();
    }
}

