/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.internal.Cast;
import org.gradle.internal.DisplayName;

class TypeSanitizingTransformer<T>
implements Transformer<T, T> {
    private final DisplayName owner;
    private final ValueSanitizer<? super T> sanitizer;
    private final Class<? super T> targetType;

    public TypeSanitizingTransformer(DisplayName owner, ValueSanitizer<? super T> sanitizer, Class<? super T> targetType) {
        this.owner = owner;
        this.sanitizer = sanitizer;
        this.targetType = targetType;
    }

    public String toString() {
        return "check-type()";
    }

    @Override
    public T transform(T t) {
        Object v = Cast.uncheckedCast(this.sanitizer.sanitize(t));
        if (this.targetType.isInstance(v)) {
            return v;
        }
        throw new IllegalArgumentException(String.format("Cannot get the value of %s of type %s as the provider associated with this property returned a value of type %s.", this.owner.getDisplayName(), this.targetType.getName(), v.getClass().getName()));
    }
}

