/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.cache;

import java.io.Closeable;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.cache.GeneralCompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.serialization.HierarchicalNameSerializer;
import org.gradle.cache.Cache;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.MinimalPersistentCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.cache.scopes.GlobalScopedCache;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.HashCodeSerializer;

public class UserHomeScopedCompileCaches
implements GeneralCompileCaches,
Closeable {
    private final Cache<HashCode, ClassSetAnalysisData> classpathEntrySnapshotCache;
    private final PersistentCache cache;
    private final Cache<HashCode, ClassAnalysis> classAnalysisCache;

    public UserHomeScopedCompileCaches(GlobalScopedCache cacheRepository, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, StringInterner interner) {
        this.cache = cacheRepository.cache("javaCompile").withDisplayName("Java compile cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.OnDemand)).open();
        PersistentIndexedCacheParameters<HashCode, ClassSetAnalysisData> jarCacheParameters = PersistentIndexedCacheParameters.of("jarAnalysis", new HashCodeSerializer(), new ClassSetAnalysisData.Serializer(() -> new HierarchicalNameSerializer(interner))).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(20000, true));
        this.classpathEntrySnapshotCache = new MinimalPersistentCache<HashCode, ClassSetAnalysisData>(this.cache.createCache(jarCacheParameters));
        PersistentIndexedCacheParameters<HashCode, ClassAnalysis> classCacheParameters = PersistentIndexedCacheParameters.of("classAnalysis", new HashCodeSerializer(), new ClassAnalysis.Serializer(interner)).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(400000, true));
        this.classAnalysisCache = new MinimalPersistentCache<HashCode, ClassAnalysis>(this.cache.createCache(classCacheParameters));
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public Cache<HashCode, ClassSetAnalysisData> getClassSetAnalysisCache() {
        return this.classpathEntrySnapshotCache;
    }

    @Override
    public Cache<HashCode, ClassAnalysis> getClassAnalysisCache() {
        return this.classAnalysisCache;
    }
}

