/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileManager;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessorResult;
import org.gradle.api.internal.tasks.compile.incremental.processing.IncrementalAnnotationProcessorType;
import org.gradle.api.internal.tasks.compile.processing.ElementUtils;
import org.gradle.api.internal.tasks.compile.processing.IncrementalProcessingStrategy;

class AggregatingProcessingStrategy
extends IncrementalProcessingStrategy {
    AggregatingProcessingStrategy(AnnotationProcessorResult result2) {
        super(result2);
        result2.setType(IncrementalAnnotationProcessorType.AGGREGATING);
    }

    @Override
    public void recordProcessingInputs(Set<String> supportedAnnotationTypes, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.validateAnnotations(annotations);
        this.recordAggregatedTypes(supportedAnnotationTypes, annotations, roundEnv);
    }

    private void validateAnnotations(Set<? extends TypeElement> annotations) {
        for (TypeElement typeElement : annotations) {
            Retention retention = typeElement.getAnnotation(Retention.class);
            if (retention == null || retention.value() != RetentionPolicy.SOURCE) continue;
            this.result.setFullRebuildCause("'@" + typeElement.getSimpleName() + "' has source retention. Aggregating annotation processors require class or runtime retention");
        }
    }

    private void recordAggregatedTypes(Set<String> supportedAnnotationTypes, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (supportedAnnotationTypes.contains("*")) {
            this.result.getAggregatedTypes().addAll(AggregatingProcessingStrategy.namesOfElements(roundEnv.getRootElements()));
        } else {
            for (TypeElement typeElement : annotations) {
                this.result.getAggregatedTypes().addAll(AggregatingProcessingStrategy.namesOfElements(roundEnv.getElementsAnnotatedWith(typeElement)));
            }
        }
    }

    private static Set<String> namesOfElements(Set<? extends Element> orig) {
        if (orig == null || orig.isEmpty()) {
            return Collections.emptySet();
        }
        return orig.stream().map(ElementUtils::getTopLevelType).map(ElementUtils::getElementName).collect(Collectors.toSet());
    }

    @Override
    public void recordGeneratedType(CharSequence name, Element[] originatingElements) {
        this.result.getGeneratedAggregatingTypes().add(name.toString());
    }

    @Override
    public void recordGeneratedResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element[] originatingElements) {
        GeneratedResource.Location resourceLocation = GeneratedResource.Location.from(location);
        if (resourceLocation == null) {
            this.result.setFullRebuildCause(location + " is not supported for incremental annotation processing");
        } else {
            this.result.getGeneratedAggregatingResources().add(new GeneratedResource(resourceLocation, pkg, relativeName));
        }
    }

    public String toString() {
        return "Aggregating strategy for " + this.result.getClassName();
    }
}

