/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.buildtree.BuildInclusionCoordinator;
import org.gradle.internal.reflect.Instantiator;

public class DefaultBuildIncluder
implements BuildIncluder {
    private final BuildStateRegistry buildRegistry;
    private final BuildInclusionCoordinator coordinator;
    private final PublicBuildPath publicBuildPath;
    private final Instantiator instantiator;
    private final GradleInternal gradle;
    private final List<BuildDefinition> pluginBuildDefinitions = new ArrayList<BuildDefinition>();

    public DefaultBuildIncluder(BuildStateRegistry buildRegistry, BuildInclusionCoordinator coordinator, PublicBuildPath publicBuildPath, Instantiator instantiator, GradleInternal gradle) {
        this.buildRegistry = buildRegistry;
        this.coordinator = coordinator;
        this.publicBuildPath = publicBuildPath;
        this.instantiator = instantiator;
        this.gradle = gradle;
    }

    @Override
    public IncludedBuildState includeBuild(IncludedBuildSpec includedBuildSpec) {
        BuildDefinition buildDefinition = this.toBuildDefinition(includedBuildSpec, this.gradle);
        IncludedBuildState build = this.buildRegistry.addIncludedBuild(buildDefinition);
        this.coordinator.prepareForInclusion(build, buildDefinition.isPluginBuild());
        return build;
    }

    @Override
    public void registerPluginBuild(IncludedBuildSpec includedBuildSpec) {
        this.pluginBuildDefinitions.add(this.toBuildDefinition(includedBuildSpec, this.gradle));
    }

    @Override
    public Collection<IncludedBuildState> includeRegisteredPluginBuilds() {
        return this.pluginBuildDefinitions.stream().map(buildDefinition -> {
            IncludedBuildState build = this.buildRegistry.addIncludedBuild((BuildDefinition)buildDefinition);
            this.coordinator.prepareForInclusion(build, true);
            return build;
        }).collect(Collectors.toList());
    }

    private BuildDefinition toBuildDefinition(IncludedBuildSpec includedBuildSpec, GradleInternal gradle) {
        gradle.getOwner().assertCanAdd(includedBuildSpec);
        return includedBuildSpec.toBuildDefinition(gradle.getStartParameter(), this.publicBuildPath, this.instantiator);
    }
}

