/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.serialize.AbstractDecoder;
import org.gradle.internal.serialize.Decoder;

public class InputStreamBackedDecoder
extends AbstractDecoder
implements Decoder,
Closeable {
    private final DataInputStream inputStream;

    public InputStreamBackedDecoder(InputStream inputStream) {
        this(new DataInputStream(inputStream));
    }

    public InputStreamBackedDecoder(DataInputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    protected int maybeReadBytes(byte[] buffer, int offset, int count) throws IOException {
        return this.inputStream.read(buffer, offset, count);
    }

    @Override
    protected long maybeSkip(long count) throws IOException {
        return this.inputStream.skip(count);
    }

    @Override
    public long readLong() throws IOException {
        return this.inputStream.readLong();
    }

    @Override
    public int readInt() throws EOFException, IOException {
        return this.inputStream.readInt();
    }

    @Override
    public boolean readBoolean() throws EOFException, IOException {
        return this.inputStream.readBoolean();
    }

    @Override
    public String readString() throws EOFException, IOException {
        return this.inputStream.readUTF();
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)(this.inputStream.readByte() & 0xFF);
    }

    @Override
    public void readBytes(byte[] buffer, int offset, int count) throws IOException {
        this.inputStream.readFully(buffer, offset, count);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

