/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class KnownImplementationSnapshot
extends ImplementationSnapshot {
    private final HashCode classLoaderHash;

    public KnownImplementationSnapshot(String typeName, HashCode classLoaderHash) {
        super(typeName);
        this.classLoaderHash = classLoaderHash;
    }

    @Override
    public void appendToHasher(Hasher hasher) {
        hasher.putString(ImplementationSnapshot.class.getName());
        hasher.putString(this.getTypeName());
        hasher.putHash(this.classLoaderHash);
    }

    @Override
    protected boolean isSameSnapshot(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnownImplementationSnapshot that = (KnownImplementationSnapshot)o;
        if (!this.getTypeName().equals(that.getTypeName())) {
            return false;
        }
        return this.classLoaderHash.equals(that.classLoaderHash);
    }

    @Override
    @Nonnull
    public HashCode getClassLoaderHash() {
        return this.classLoaderHash;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    @Nullable
    public ImplementationSnapshot.UnknownReason getUnknownReason() {
        return null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnownImplementationSnapshot that = (KnownImplementationSnapshot)o;
        if (this == o) {
            return true;
        }
        if (!this.getTypeName().equals(that.getTypeName())) {
            return false;
        }
        return this.classLoaderHash.equals(that.classLoaderHash);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.classLoaderHash.hashCode();
        return result2;
    }

    public String toString() {
        return this.getTypeName() + "@" + this.classLoaderHash;
    }
}

