/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.launcher.bootstrap.ExecutionListener;

final class DebugLoggerWarningAction
implements Action<ExecutionListener> {
    static final String WARNING_MESSAGE_BODY;
    private final Logger logger;
    private final LoggingConfiguration loggingConfiguration;
    private final Action<ExecutionListener> action;

    DebugLoggerWarningAction(LoggingConfiguration loggingConfiguration, Action<ExecutionListener> action) {
        this(Logging.getLogger(DebugLoggerWarningAction.class), loggingConfiguration, action);
    }

    @VisibleForTesting
    DebugLoggerWarningAction(Logger logger, LoggingConfiguration loggingConfiguration, Action<ExecutionListener> action) {
        this.logger = Objects.requireNonNull(logger, "logger");
        this.loggingConfiguration = Objects.requireNonNull(loggingConfiguration, "loggingConfiguration");
        this.action = Objects.requireNonNull(action, "action");
    }

    private void logWarningIfEnabled() {
        if (LogLevel.DEBUG.equals((Object)this.loggingConfiguration.getLogLevel())) {
            this.logger.lifecycle(WARNING_MESSAGE_BODY);
        }
    }

    @Override
    public void execute(ExecutionListener executionListener) {
        this.logWarningIfEnabled();
        try {
            this.action.execute(executionListener);
        }
        finally {
            this.logWarningIfEnabled();
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("#############################################################################\n");
        sb.append("   WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING\n");
        sb.append('\n');
        sb.append("   Debug level logging will leak security sensitive information!\n");
        sb.append('\n');
        sb.append("   ").append(new DocumentationRegistry().getDocumentationFor("logging", "sec:debug_security")).append('\n');
        sb.append("#############################################################################\n");
        WARNING_MESSAGE_BODY = sb.toString();
    }
}

