/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.SetMediaSourcesEvent;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.Vp8PayloadType;
import org.jitsi.nlj.format.Vp9PayloadType;
import org.jitsi.nlj.rtp.ParsedVideoPacket;
import org.jitsi.nlj.rtp.codec.VideoCodecParser;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Packet;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Parser;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Parser;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u0016\u0010\u001a\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0014R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/VideoParser;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "signaledSources", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "[Lorg/jitsi/nlj/MediaSourceDesc;", "sources", "stats", "Lorg/jitsi/nlj/transform/node/incoming/VideoParser$Stats;", "videoCodecParser", "Lorg/jitsi/nlj/rtp/codec/VideoCodecParser;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getStats", "Lorg/jitsi/nlj/transform/node/incoming/VideoParser$Stats$Snapshot;", "handleEvent", "", "event", "Lorg/jitsi/nlj/Event;", "resetSources", "trace", "f", "Lkotlin/Function0;", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "Stats", "jitsi-media-transform"})
public final class VideoParser
extends TransformerNode {
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Stats stats;
    @NotNull
    private MediaSourceDesc[] sources;
    @NotNull
    private MediaSourceDesc[] signaledSources;
    @Nullable
    private VideoCodecParser videoCodecParser;

    public VideoParser(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("Video parser");
        this.streamInformationStore = streamInformationStore;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.stats = new Stats();
        this.sources = new MediaSourceDesc[0];
        this.signaledSources = this.sources;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Object $this$cdebug$iv;
        Logger logger;
        Object object;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        RtpPacket packet = (RtpPacket)packetInfo.packetAs();
        PayloadType payloadType = this.streamInformationStore.getRtpPayloadTypes().get((byte)packet.getPayloadType());
        if (payloadType == null) {
            VideoParser $this$transform_u24lambda_u2d0 = this;
            boolean bl = false;
            $this$transform_u24lambda_u2d0.logger.error("Unrecognized video payload type " + packet.getPayloadType() + ", cannot parse video information");
            Stats stats = $this$transform_u24lambda_u2d0.stats;
            int n = stats.getNumPacketsDroppedUnknownPt();
            stats.setNumPacketsDroppedUnknownPt(n + 1);
            return null;
        }
        PayloadType payloadType2 = payloadType;
        try {
            ParsedVideoPacket parsedVideoPacket;
            int n;
            boolean $i$f$cdebug;
            Logger $this$cdebug$iv2;
            void p2;
            int p1;
            byte[] p0;
            boolean $i$f$toOtherType;
            Packet this_$iv;
            object = payloadType2;
            if (object instanceof Vp8PayloadType) {
                this_$iv = packetInfo.getPacket();
                $i$f$toOtherType = false;
                Intrinsics.checkNotNullExpressionValue(this_$iv.buffer, "buffer");
                int n2 = this_$iv.length;
                int n3 = this_$iv.offset;
                p0 = this_$iv.buffer;
                boolean bl = false;
                Vp8Packet vp8Packet = (Vp8Packet)((Packet)new Vp8Packet(p0, p1, (int)p2));
                packetInfo.setPacket(vp8Packet);
                packetInfo.resetPayloadVerification();
                if (!(this.videoCodecParser instanceof Vp8Parser)) {
                    $this$cdebug$iv2 = this.logger;
                    $i$f$cdebug = false;
                    if ($this$cdebug$iv2.isDebugEnabled()) {
                        logger = $this$cdebug$iv2;
                        n = 0;
                        VideoCodecParser videoCodecParser = this.videoCodecParser;
                        logger.debug("Creating new VP8Parser, current videoCodecParser is " + (videoCodecParser != null ? videoCodecParser.getClass() : null));
                    }
                    this.resetSources();
                    packetInfo.setLayeringChanged(true);
                    this.videoCodecParser = new Vp8Parser(this.sources, this.logger);
                }
                parsedVideoPacket = vp8Packet;
            } else if (object instanceof Vp9PayloadType) {
                this_$iv = packetInfo.getPacket();
                $i$f$toOtherType = false;
                Intrinsics.checkNotNullExpressionValue(this_$iv.buffer, "buffer");
                n = this_$iv.length;
                p1 = this_$iv.offset;
                p0 = this_$iv.buffer;
                boolean bl = false;
                Vp9Packet vp9Packet = (Vp9Packet)((Packet)new Vp9Packet(p0, p1, (int)p2));
                packetInfo.setPacket(vp9Packet);
                packetInfo.resetPayloadVerification();
                if (!(this.videoCodecParser instanceof Vp9Parser)) {
                    $this$cdebug$iv2 = this.logger;
                    $i$f$cdebug = false;
                    if ($this$cdebug$iv2.isDebugEnabled()) {
                        logger = $this$cdebug$iv2;
                        boolean bl2 = false;
                        VideoCodecParser videoCodecParser = this.videoCodecParser;
                        logger.debug("Creating new VP9Parser, current videoCodecParser is " + (videoCodecParser != null ? videoCodecParser.getClass() : null));
                    }
                    this.resetSources();
                    packetInfo.setLayeringChanged(true);
                    this.videoCodecParser = new Vp9Parser(this.sources, this.logger);
                }
                parsedVideoPacket = vp9Packet;
            } else {
                if (this.videoCodecParser != null) {
                    Logger $this$cdebug$iv3 = this.logger;
                    boolean $i$f$cdebug2 = false;
                    if ($this$cdebug$iv3.isDebugEnabled()) {
                        Logger logger2 = $this$cdebug$iv3;
                        boolean bl = false;
                        VideoCodecParser videoCodecParser = this.videoCodecParser;
                        logger2.debug("Removing videoCodecParser on " + payloadType2.getClass() + " packet, current videoCodecParser is " + (videoCodecParser != null ? videoCodecParser.getClass() : null));
                    }
                    this.resetSources();
                    packetInfo.setLayeringChanged(true);
                    this.videoCodecParser = null;
                }
                return packetInfo;
            }
            Object it = object = parsedVideoPacket;
            boolean bl = false;
            VideoCodecParser videoCodecParser = this.videoCodecParser;
            if (videoCodecParser != null) {
                videoCodecParser.parse(packetInfo);
            }
        }
        catch (Exception e) {
            Intrinsics.checkNotNullExpressionValue(packet.buffer, "packet.buffer");
            this.logger.error("Exception parsing video packet.  Packet data is: " + ByteArrayExtensionsKt.toHex(packet.buffer, packet.offset, Math.min(packet.length, 80)), e);
            return null;
        }
        Object parsedPacket = object;
        if (((ParsedVideoPacket)parsedPacket).isKeyframe() && ((ParsedVideoPacket)parsedPacket).isStartOfFrame()) {
            $this$cdebug$iv = this.logger;
            int $i$f$cdebug = 0;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("Received a keyframe for ssrc " + packet.getSsrc() + " " + packet.getSequenceNumber());
            }
            $this$cdebug$iv = this.stats;
            $i$f$cdebug = ((Stats)$this$cdebug$iv).getNumKeyframes();
            ((Stats)$this$cdebug$iv).setNumKeyframes($i$f$cdebug + 1);
        }
        if (packetInfo.getLayeringChanged()) {
            $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("Layering structure changed for ssrc " + packet.getSsrc() + " " + packet.getSequenceNumber());
            }
            object = this.stats;
            int n = ((Stats)object).getNumLayeringChanges();
            ((Stats)object).setNumLayeringChanges(n + 1);
        }
        return packetInfo;
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof SetMediaSourcesEvent) {
            this.sources = ((SetMediaSourcesEvent)event).getMediaSourceDescs();
            this.signaledSources = ((SetMediaSourcesEvent)event).getSignaledMediaSourceDescs();
            VideoCodecParser videoCodecParser = this.videoCodecParser;
            if (videoCodecParser != null) {
                videoCodecParser.setSources(this.sources);
            }
        }
        super.handleEvent(event);
    }

    private final void resetSources() {
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Resetting sources to signaled sources: " + ArraysKt.joinToString$default(this.signaledSources, (CharSequence)"\n", null, null, 0, null, null, 62, null));
        }
        block0: for (MediaSourceDesc signaledSource : this.signaledSources) {
            for (MediaSourceDesc source : this.sources) {
                if (source.getPrimarySSRC() != signaledSource.getPrimarySSRC()) continue;
                for (RtpEncodingDesc signaledEncoding : signaledSource.getRtpEncodings()) {
                    source.setEncodingLayers(signaledEncoding.getLayers$jitsi_media_transform(), signaledEncoding.getPrimarySSRC());
                }
                continue block0;
            }
        }
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d9 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        this.stats.addToNodeStatsBlock($this$getNodeStats_u24lambda_u2d9);
        return nodeStatsBlock;
    }

    @NotNull
    public final Stats.Snapshot getStats() {
        return this.stats.snapshot();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/VideoParser$Stats;", "", "()V", "numKeyframes", "", "getNumKeyframes", "()I", "setNumKeyframes", "(I)V", "numLayeringChanges", "getNumLayeringChanges", "setNumLayeringChanges", "numPacketsDroppedUnknownPt", "getNumPacketsDroppedUnknownPt", "setNumPacketsDroppedUnknownPt", "addToNodeStatsBlock", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "nodeStatsBlock", "snapshot", "Lorg/jitsi/nlj/transform/node/incoming/VideoParser$Stats$Snapshot;", "Snapshot", "jitsi-media-transform"})
    public static final class Stats {
        private int numKeyframes;
        private int numLayeringChanges;
        private int numPacketsDroppedUnknownPt;

        public final int getNumKeyframes() {
            return this.numKeyframes;
        }

        public final void setNumKeyframes(int n) {
            this.numKeyframes = n;
        }

        public final int getNumLayeringChanges() {
            return this.numLayeringChanges;
        }

        public final void setNumLayeringChanges(int n) {
            this.numLayeringChanges = n;
        }

        public final int getNumPacketsDroppedUnknownPt() {
            return this.numPacketsDroppedUnknownPt;
        }

        public final void setNumPacketsDroppedUnknownPt(int n) {
            this.numPacketsDroppedUnknownPt = n;
        }

        @NotNull
        public final Snapshot snapshot() {
            return new Snapshot(this.numKeyframes, this.numLayeringChanges, this.numPacketsDroppedUnknownPt);
        }

        @NotNull
        public final NodeStatsBlock addToNodeStatsBlock(@NotNull NodeStatsBlock nodeStatsBlock) {
            NodeStatsBlock nodeStatsBlock2;
            Intrinsics.checkNotNullParameter(nodeStatsBlock, "nodeStatsBlock");
            NodeStatsBlock $this$addToNodeStatsBlock_u24lambda_u2d0 = nodeStatsBlock2 = nodeStatsBlock;
            boolean bl = false;
            $this$addToNodeStatsBlock_u24lambda_u2d0.addNumber("num_packets_dropped_unknown_pt", this.numPacketsDroppedUnknownPt);
            $this$addToNodeStatsBlock_u24lambda_u2d0.addNumber("num_keyframes", this.numKeyframes);
            $this$addToNodeStatsBlock_u24lambda_u2d0.addNumber("num_layering_changes", this.numLayeringChanges);
            return nodeStatsBlock2;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\b\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/VideoParser$Stats$Snapshot;", "", "numKeyframes", "", "numLayeringChanges", "numPacketsDroppedUnknownPt", "(III)V", "getNumKeyframes", "()I", "getNumLayeringChanges", "setNumLayeringChanges", "(I)V", "getNumPacketsDroppedUnknownPt", "setNumPacketsDroppedUnknownPt", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "toString", "", "jitsi-media-transform"})
        public static final class Snapshot {
            private final int numKeyframes;
            private int numLayeringChanges;
            private int numPacketsDroppedUnknownPt;

            public Snapshot(int numKeyframes, int numLayeringChanges, int numPacketsDroppedUnknownPt) {
                this.numKeyframes = numKeyframes;
                this.numLayeringChanges = numLayeringChanges;
                this.numPacketsDroppedUnknownPt = numPacketsDroppedUnknownPt;
            }

            public final int getNumKeyframes() {
                return this.numKeyframes;
            }

            public final int getNumLayeringChanges() {
                return this.numLayeringChanges;
            }

            public final void setNumLayeringChanges(int n) {
                this.numLayeringChanges = n;
            }

            public final int getNumPacketsDroppedUnknownPt() {
                return this.numPacketsDroppedUnknownPt;
            }

            public final void setNumPacketsDroppedUnknownPt(int n) {
                this.numPacketsDroppedUnknownPt = n;
            }

            @NotNull
            public final OrderedJsonObject toJson() {
                OrderedJsonObject orderedJsonObject;
                OrderedJsonObject $this$toJson_u24lambda_u2d0 = orderedJsonObject = new OrderedJsonObject();
                boolean bl = false;
                $this$toJson_u24lambda_u2d0.put("num_packets_dropped_unknown_pt", (Object)this.numPacketsDroppedUnknownPt);
                $this$toJson_u24lambda_u2d0.put("num_keyframes", (Object)this.numKeyframes);
                $this$toJson_u24lambda_u2d0.put("num_layering_changes", (Object)this.numLayeringChanges);
                return orderedJsonObject;
            }

            public final int component1() {
                return this.numKeyframes;
            }

            public final int component2() {
                return this.numLayeringChanges;
            }

            public final int component3() {
                return this.numPacketsDroppedUnknownPt;
            }

            @NotNull
            public final Snapshot copy(int numKeyframes, int numLayeringChanges, int numPacketsDroppedUnknownPt) {
                return new Snapshot(numKeyframes, numLayeringChanges, numPacketsDroppedUnknownPt);
            }

            public static /* synthetic */ Snapshot copy$default(Snapshot snapshot, int n, int n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = snapshot.numKeyframes;
                }
                if ((n4 & 2) != 0) {
                    n2 = snapshot.numLayeringChanges;
                }
                if ((n4 & 4) != 0) {
                    n3 = snapshot.numPacketsDroppedUnknownPt;
                }
                return snapshot.copy(n, n2, n3);
            }

            @NotNull
            public String toString() {
                return "Snapshot(numKeyframes=" + this.numKeyframes + ", numLayeringChanges=" + this.numLayeringChanges + ", numPacketsDroppedUnknownPt=" + this.numPacketsDroppedUnknownPt + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.numKeyframes);
                result2 = result2 * 31 + Integer.hashCode(this.numLayeringChanges);
                result2 = result2 * 31 + Integer.hashCode(this.numPacketsDroppedUnknownPt);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Snapshot)) {
                    return false;
                }
                Snapshot snapshot = (Snapshot)other;
                if (this.numKeyframes != snapshot.numKeyframes) {
                    return false;
                }
                if (this.numLayeringChanges != snapshot.numLayeringChanges) {
                    return false;
                }
                return this.numPacketsDroppedUnknownPt == snapshot.numPacketsDroppedUnknownPt;
            }
        }
    }
}

