/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.MacAddress;

public final class IpV6NeighborDiscoveryTargetLinkLayerAddressOption
implements IcmpV6CommonPacket.IpV6NeighborDiscoveryOption {
    private static final long serialVersionUID = 172728262141108390L;
    private static final int TYPE_OFFSET = 0;
    private static final int TYPE_SIZE = 1;
    private static final int LENGTH_OFFSET = 1;
    private static final int LENGTH_SIZE = 1;
    private static final int LINK_LAYER_ADDRESS_OFFSET = 2;
    private final IpV6NeighborDiscoveryOptionType type = IpV6NeighborDiscoveryOptionType.TARGET_LINK_LAYER_ADDRESS;
    private final byte length;
    private final byte[] linkLayerAddress;

    public static IpV6NeighborDiscoveryTargetLinkLayerAddressOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV6NeighborDiscoveryTargetLinkLayerAddressOption(rawData, offset, length);
    }

    private IpV6NeighborDiscoveryTargetLinkLayerAddressOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 8) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 7. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[0 + offset] != (Byte)this.getType().value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The type must be: ").append(this.getType().valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = rawData[1 + offset];
        int lengthInByte = this.getLengthAsInt() * 8;
        if (length < lengthInByte) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data is too short to build this option. ").append(lengthInByte).append(" bytes data is needed. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (this.length == 0) {
            throw new IllegalRawDataException("The length field value must not be zero.");
        }
        this.linkLayerAddress = ByteArrays.getSubArray(rawData, 2 + offset, lengthInByte - 2);
    }

    private IpV6NeighborDiscoveryTargetLinkLayerAddressOption(Builder builder2) {
        if (builder2 == null || builder2.linkLayerAddress == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.linkLayerAddress: ").append(builder2.linkLayerAddress);
            throw new NullPointerException(sb.toString());
        }
        this.linkLayerAddress = new byte[builder2.linkLayerAddress.length];
        System.arraycopy(builder2.linkLayerAddress, 0, this.linkLayerAddress, 0, builder2.linkLayerAddress.length);
        if (builder2.correctLengthAtBuild) {
            if (this.length() % 8 != 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("linkLayerAddress's length is invalid. linkLayerAddress: ").append(ByteArrays.toHexString(this.linkLayerAddress, " "));
                throw new IllegalArgumentException(sb.toString());
            }
            this.length = (byte)(this.length() / 8);
        } else {
            this.length = builder2.length;
        }
    }

    @Override
    public IpV6NeighborDiscoveryOptionType getType() {
        return this.type;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public byte[] getLinkLayerAddress() {
        byte[] copy2 = new byte[this.linkLayerAddress.length];
        System.arraycopy(this.linkLayerAddress, 0, copy2, 0, this.linkLayerAddress.length);
        return copy2;
    }

    public MacAddress getLinkLayerAddressAsMacAddress() {
        return MacAddress.getByAddress(this.linkLayerAddress);
    }

    @Override
    public int length() {
        return this.linkLayerAddress.length + 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getType().value();
        rawData[1] = this.length;
        System.arraycopy(this.linkLayerAddress, 0, rawData, 2, this.linkLayerAddress.length);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Type: ").append(this.getType());
        sb.append("] [Length: ").append(this.getLengthAsInt()).append(" (").append(this.getLengthAsInt() * 8);
        sb.append(" bytes)] [linkLayerAddress: ").append(ByteArrays.toHexString(this.linkLayerAddress, " "));
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IpV6NeighborDiscoveryTargetLinkLayerAddressOption other = (IpV6NeighborDiscoveryTargetLinkLayerAddressOption)obj;
        return this.length == other.length && Arrays.equals(this.linkLayerAddress, other.linkLayerAddress);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.length;
        result2 = 31 * result2 + Arrays.hashCode(this.linkLayerAddress);
        return result2;
    }

    public static final class Builder
    implements LengthBuilder<IpV6NeighborDiscoveryTargetLinkLayerAddressOption> {
        private byte length;
        private byte[] linkLayerAddress;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(IpV6NeighborDiscoveryTargetLinkLayerAddressOption option) {
            this.length = option.length;
            this.linkLayerAddress = option.linkLayerAddress;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder linkLayerAddress(byte[] linkLayerAddress) {
            this.linkLayerAddress = linkLayerAddress;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV6NeighborDiscoveryTargetLinkLayerAddressOption build() {
            return new IpV6NeighborDiscoveryTargetLinkLayerAddressOption(this);
        }
    }
}

