/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import java.net.URI;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.InvalidConfigurationException;
import org.testcontainers.dockerclient.TransportConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.LocalDirectorySSLConfig;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.utility.CommandLine;
import org.testcontainers.utility.DockerMachineClient;

@Deprecated
public final class DockerMachineClientProviderStrategy
extends DockerClientProviderStrategy {
    private static final Logger log = LoggerFactory.getLogger(DockerMachineClientProviderStrategy.class);
    private final AtomicReference<Object> transportConfig = new AtomicReference();

    private TransportConfig resolveTransportConfig() throws InvalidConfigurationException {
        boolean installed = DockerMachineClient.instance().isInstalled();
        Preconditions.checkArgument(installed, "docker-machine executable was not found on PATH (" + Arrays.toString(CommandLine.getSystemPath()) + ")");
        Optional<String> machineNameOptional = DockerMachineClient.instance().getDefaultMachine();
        Preconditions.checkArgument(machineNameOptional.isPresent(), "docker-machine is installed but no default machine could be found");
        String machineName = machineNameOptional.get();
        log.info("Found docker-machine, and will use machine named {}", (Object)machineName);
        DockerMachineClient.instance().ensureMachineRunning(machineName);
        String dockerDaemonUrl = DockerMachineClient.instance().getDockerDaemonUrl(machineName);
        log.info("Docker daemon URL for docker machine {} is {}", (Object)machineName, (Object)dockerDaemonUrl);
        return TransportConfig.builder().dockerHost(URI.create(dockerDaemonUrl)).sslConfig(new LocalDirectorySSLConfig(Paths.get(System.getProperty("user.home") + "/.docker/machine/certs/", new String[0]).toString())).build();
    }

    @Override
    protected boolean isApplicable() {
        boolean installed = DockerMachineClient.instance().isInstalled();
        if (!installed) {
            log.info("docker-machine executable was not found on PATH ({})", (Object)Arrays.toString(CommandLine.getSystemPath()));
            return false;
        }
        Optional<String> machineNameOptional = DockerMachineClient.instance().getDefaultMachine();
        if (!machineNameOptional.isPresent()) {
            log.info("docker-machine is installed but no default machine could be found");
        }
        return true;
    }

    @Override
    protected boolean isPersistable() {
        return false;
    }

    @Override
    protected int getPriority() {
        return 0;
    }

    @Override
    public String getDescription() {
        return "docker-machine";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransportConfig getTransportConfig() {
        Object value = this.transportConfig.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.transportConfig;
            synchronized (atomicReference) {
                value = this.transportConfig.get();
                if (value == null) {
                    TransportConfig actualValue = this.resolveTransportConfig();
                    value = actualValue == null ? this.transportConfig : actualValue;
                    this.transportConfig.set(value);
                }
            }
        }
        return (TransportConfig)(value == this.transportConfig ? null : value);
    }
}

