/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.Futures;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class IncludeSectionHelper
implements SectionHelper {
    static final String DEFAULT_NAME = "$default$";
    private static final String TEMPLATE = "template";
    protected final Supplier<Template> template;
    protected final Map<String, SectionBlock> extendingBlocks;
    protected final Map<String, Expression> parameters;
    protected final boolean isIsolated;

    public IncludeSectionHelper(Supplier<Template> templateSupplier, Map<String, SectionBlock> extendingBlocks, Map<String, Expression> parameters, boolean isIsolated) {
        this.template = templateSupplier;
        this.extendingBlocks = extendingBlocks;
        this.parameters = parameters;
        this.isIsolated = isIsolated;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        if (this.parameters.isEmpty() && this.optimizeIfNoParams()) {
            SectionNode root = ((TemplateImpl)this.template.get()).root;
            if (this.isIsolated) {
                return root.resolve(context.newResolutionContext(null, this.extendingBlocks));
            }
            if (this.extendingBlocks.isEmpty()) {
                return root.resolve(context.resolutionContext());
            }
            return root.resolve(context.resolutionContext().createChild(null, this.extendingBlocks));
        }
        CompletableFuture<ResultNode> result = new CompletableFuture<ResultNode>();
        Futures.evaluateParams(this.parameters, context.resolutionContext()).whenComplete((evaluatedParams, t1) -> {
            if (t1 != null) {
                result.completeExceptionally((Throwable)t1);
            } else {
                this.addAdditionalEvaluatedParams(context, (Map<String, Object>)evaluatedParams);
                try {
                    Mapper data = Mapper.wrap(evaluatedParams);
                    ResolutionContext resolutionContext = this.isIsolated ? context.newResolutionContext(data, this.extendingBlocks) : context.resolutionContext().createChild(data, this.extendingBlocks);
                    SectionNode root = ((TemplateImpl)this.template.get()).root;
                    root.resolve(resolutionContext).whenComplete((resultNode, t2) -> {
                        if (t2 != null) {
                            result.completeExceptionally((Throwable)t2);
                        } else {
                            result.complete((ResultNode)resultNode);
                        }
                    });
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    protected boolean optimizeIfNoParams() {
        return true;
    }

    protected void addAdditionalEvaluatedParams(SectionHelper.SectionResolutionContext context, Map<String, Object> evaluatedParams) {
    }

    static enum Code implements ErrorCode
    {
        MULTIPLE_INSERTS_OF_NAME,
        TEMPLATE_NOT_FOUND;


        @Override
        public String getName() {
            return "INCLUDE_" + this.name();
        }
    }

    static abstract class AbstractIncludeFactory<T extends SectionHelper>
    implements SectionHelperFactory<T> {
        static final String ISOLATED = "_isolated";
        static final String ISOLATED_DEFAULT_VALUE = "false";

        AbstractIncludeFactory() {
        }

        @Override
        public boolean treatUnknownSectionsAsBlocks() {
            return true;
        }

        @Override
        public Scope initializeBlock(Scope outerScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                for (Map.Entry<String, String> entry : block.getParameters().entrySet()) {
                    String value;
                    String key = entry.getKey();
                    if (this.ignoreParameterInit(key, value = entry.getValue())) continue;
                    if (this.useDefaultedKey(key, value)) {
                        key = value;
                    }
                    block.addExpression(key, value);
                }
                return outerScope;
            }
            return outerScope;
        }

        @Override
        public T initialize(final SectionHelperFactory.SectionInitContext context) {
            Map<String, Expression> params;
            Map<String, SectionBlock> extendingBlocks;
            boolean isEmpty = context.getBlocks().size() == 1 && context.getBlocks().get(0).isEmpty();
            boolean isolatedValue = false;
            if (isEmpty) {
                extendingBlocks = Collections.emptyMap();
            } else {
                extendingBlocks = new HashMap();
                for (SectionBlock sectionBlock : context.getBlocks()) {
                    String string = sectionBlock.id.equals("$main") ? IncludeSectionHelper.DEFAULT_NAME : sectionBlock.label;
                    if (extendingBlocks.put(string, sectionBlock) == null) continue;
                    throw sectionBlock.error("multiple blocks define the content for the \\{#insert\\} section of name [{name}]").code(Code.MULTIPLE_INSERTS_OF_NAME).origin(context.getOrigin()).argument("name", string).build();
                }
            }
            if (context.getParameters().size() == 1) {
                params = Collections.emptyMap();
            } else {
                params = new HashMap();
                for (Map.Entry<String, String> entry : context.getParameters().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (value.equals(ISOLATED)) {
                        isolatedValue = true;
                        continue;
                    }
                    this.handleParamInit(key, value, context, params);
                }
            }
            final String string = this.getTemplateId(context);
            final Engine engine = context.getEngine();
            Supplier<Template> template = new Supplier<Template>(){

                @Override
                public Template get() {
                    Template template = engine.getTemplate(string);
                    if (template == null) {
                        throw engine.error("included template [{templateId}] not found").code(Code.TEMPLATE_NOT_FOUND).argument("templateId", string).origin(context.getOrigin()).build();
                    }
                    return template;
                }
            };
            return this.newHelper(template, params, extendingBlocks, isolatedValue ? true : Boolean.parseBoolean(context.getParameterOrDefault(ISOLATED, ISOLATED_DEFAULT_VALUE)), context);
        }

        protected abstract String getTemplateId(SectionHelperFactory.SectionInitContext var1);

        protected void handleParamInit(String key, String value, SectionHelperFactory.SectionInitContext context, Map<String, Expression> params) {
            if (this.ignoreParameterInit(key, value)) {
                return;
            }
            if (this.useDefaultedKey(key, value)) {
                key = value;
            }
            params.put(key, context.getExpression(key));
        }

        protected boolean useDefaultedKey(String key, String value) {
            return LiteralSupport.INTEGER_LITERAL_PATTERN.matcher(key).matches() && this.isSinglePart(value);
        }

        protected boolean isSinglePart(String value) {
            return Expressions.splitParts(value).size() == 1;
        }

        protected abstract boolean ignoreParameterInit(String var1, String var2);

        protected abstract T newHelper(Supplier<Template> var1, Map<String, Expression> var2, Map<String, SectionBlock> var3, boolean var4, SectionHelperFactory.SectionInitContext var5);
    }

    public static class Factory
    extends AbstractIncludeFactory<IncludeSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("include");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(IncludeSectionHelper.TEMPLATE).addParameter(Parameter.builder("_isolated").defaultValue("false").optional().valuePredicate(v -> "_isolated".equals(v))).build();
        }

        @Override
        protected boolean ignoreParameterInit(String key, String value) {
            return key.equals(IncludeSectionHelper.TEMPLATE) || key.equals("_isolated") || value.equals("_isolated");
        }

        @Override
        protected String getTemplateId(SectionHelperFactory.SectionInitContext context) {
            String templateParam = context.getParameter(IncludeSectionHelper.TEMPLATE);
            if (LiteralSupport.isStringLiteralSeparator(templateParam.charAt(0))) {
                templateParam = templateParam.substring(1, templateParam.length() - 1);
            }
            return templateParam;
        }

        @Override
        protected IncludeSectionHelper newHelper(Supplier<Template> template, Map<String, Expression> params, Map<String, SectionBlock> extendingBlocks, boolean isolated, SectionHelperFactory.SectionInitContext context) {
            return new IncludeSectionHelper(template, extendingBlocks, params, isolated);
        }
    }
}

