"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveReport = void 0;

var _uuid = require("uuid");

var _backendModel = require("../../model/backendModel");

var _uiToBackend = require("../utils/converters/uiToBackend");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const saveReport = async (report, opensearchReportsClient) => {
  const timePending = Date.now();
  const {
    time_from: timeFrom,
    time_to: timeTo,
    query_url: queryUrl,
    report_definition: reportDefinition
  } = report;
  const reqBody = {
    beginTimeMs: timeFrom,
    endTimeMs: timeTo,
    reportDefinitionDetails: {
      id: (0, _uuid.v1)(),
      lastUpdatedTimeMs: timePending,
      createdTimeMs: timePending,
      reportDefinition: { ...(0, _uiToBackend.uiToBackendReportDefinition)(reportDefinition),
        trigger: {
          triggerType: 'Download' // TODO: this is a corner case for in-context menu button download only

        }
      }
    },
    // download from in-context menu should always pass executing state to backend
    // TODO: set to success, since update report status API in temporarily unavailable, need change back to pending later
    status: _backendModel.BACKEND_REPORT_STATE.success,
    inContextDownloadUrlPath: queryUrl
  };
  const opensearchResp = await opensearchReportsClient.callAsCurrentUser('opensearch_reports.createReport', {
    body: reqBody
  });
  return opensearchResp;
};

exports.saveReport = saveReport;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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