/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.carrot2.attrs.AcceptingVisitor;
import org.carrot2.attrs.AliasMapper;
import org.carrot2.attrs.AttrBoolean;
import org.carrot2.attrs.AttrDouble;
import org.carrot2.attrs.AttrEnum;
import org.carrot2.attrs.AttrInteger;
import org.carrot2.attrs.AttrObject;
import org.carrot2.attrs.AttrObjectArray;
import org.carrot2.attrs.AttrString;
import org.carrot2.attrs.AttrStringArray;
import org.carrot2.attrs.AttrVisitor;
import org.carrot2.attrs.ClassNameMapper;

class FlatKeysAttrVisitor
implements AttrVisitor {
    final Function<String, Object> classToInstance = arg_0 -> ((ClassNameMapper)AliasMapper.SPI_DEFAULTS).fromName(arg_0);
    final ArrayDeque<String> keyPath = new ArrayDeque();
    final LinkedHashMap<String, String> attrs;

    FlatKeysAttrVisitor(LinkedHashMap<String, String> attrs) {
        this.attrs = attrs;
    }

    public void visit(String key, AttrBoolean attr) {
        this.ifKeyExists(key, (path, value) -> attr.set(value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value))));
    }

    public void visit(String key, AttrInteger attr) {
        this.ifKeyExists(key, (path, value) -> attr.set(value == null ? null : Integer.valueOf(Integer.parseInt(value))));
    }

    public void visit(String key, AttrDouble attr) {
        this.ifKeyExists(key, (path, value) -> attr.set(value == null ? null : Double.valueOf(Double.parseDouble(value))));
    }

    public void visit(String key, AttrString attr) {
        this.ifKeyExists(key, (path, value) -> attr.set(value));
    }

    public void visit(String key, AttrStringArray attr) {
        this.ifKeyExists(key, (path, value) -> {
            if (value == null) {
                attr.set(new String[0]);
            } else {
                attr.set(value.split(",\\s*"));
            }
        });
    }

    public <T extends Enum<T>> void visit(String key, AttrEnum<T> attr) {
        this.ifKeyExists(key, (path, value) -> {
            try {
                attr.set(Enum.valueOf(attr.enumClass(), value));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Value at key '%s' should be an enum constant of class '%s', but no such constant exists: '%s' (available constants: %s)", key, attr.enumClass().getSimpleName(), this.toDebugString(value), EnumSet.allOf(attr.enumClass())));
            }
        });
    }

    public <T extends AcceptingVisitor> void visit(String key, AttrObject<T> attr) {
        this.ifKeyExists(key, (path, value) -> {
            if (value == null) {
                attr.set(null);
            } else {
                AcceptingVisitor t = (AcceptingVisitor)this.safeCast(this.classToInstance.apply((String)value), key, attr.getInterfaceClass());
                attr.set(t);
            }
        });
        AcceptingVisitor t = attr.get();
        if (t != null) {
            this.withKey(key, path -> t.accept((AttrVisitor)this));
        }
    }

    public <T extends AcceptingVisitor> void visit(String key, AttrObjectArray<T> attr) {
        this.ifKeyExists(key, (path, value) -> {
            throw new RuntimeException("Setting arrays of objects not implemented for attribute: " + key + " (" + attr.getDescription() + ")");
        });
    }

    private <T> T safeCast(Object value, String key, Class<T> clazz) {
        if (value == null) {
            return null;
        }
        if (!clazz.isInstance(value)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Value at key '%s' should be an instance of '%s', but encountered class '%s': '%s'", key, clazz.getSimpleName(), value.getClass().getSimpleName(), this.toDebugString(value)));
        }
        return clazz.cast(value);
    }

    private String toDebugString(Object value) {
        if (value == null) {
            return "[null]";
        }
        if (value instanceof Object[]) {
            return Arrays.deepToString((Object[])value);
        }
        return Objects.toString(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withKey(String key, Consumer<String> pathConsumer) {
        this.keyPath.addLast(key);
        try {
            String path = String.join((CharSequence)".", this.keyPath);
            pathConsumer.accept(path);
        }
        finally {
            this.keyPath.removeLast();
        }
    }

    private void ifKeyExists(String key, BiConsumer<String, String> pathConsumer) {
        this.withKey(key, path -> {
            if (this.attrs.containsKey(path)) {
                String value = this.attrs.get(path);
                if (value.trim().isEmpty()) {
                    value = null;
                }
                pathConsumer.accept((String)path, value);
            }
        });
    }
}

